/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run.editor;

import com.android.ddmlib.IDevice;
import com.android.tools.idea.run.AndroidDevice;
import com.android.tools.idea.run.ConnectedAndroidDevice;
import com.android.tools.idea.run.DeviceCount;
import com.android.tools.idea.run.DeviceFutures;
import com.android.tools.idea.run.DevicePickerStateService;
import com.android.tools.idea.run.LaunchCompatibilityChecker;
import com.android.tools.idea.run.ManualTargetChooser;
import com.android.tools.idea.run.TargetSelectionMode;
import com.android.tools.idea.run.editor.DeployTarget;
import com.android.tools.idea.run.editor.DeployTargetConfigurable;
import com.android.tools.idea.run.editor.DeployTargetConfigurableContext;
import com.android.tools.idea.run.editor.DeployTargetPickerDialog;
import com.android.tools.idea.run.editor.DeployTargetProvider;
import com.android.tools.idea.run.editor.DeployTargetState;
import com.android.tools.idea.run.editor.RealizedDeployTarget;
import com.google.common.collect.Sets;
import com.intellij.execution.Executor;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.ui.components.JBCheckBox;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JComponent;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ShowChooserTargetProvider
extends DeployTargetProvider<State> {
    public static final String ID = TargetSelectionMode.SHOW_DIALOG.name();

    @Override
    @NotNull
    public String getId() {
        return ID;
    }

    @Override
    @NotNull
    public String getDisplayName() {
        return "Open Select Deployment Target Dialog";
    }

    @Override
    @NotNull
    public State createState() {
        return new State();
    }

    @Override
    public boolean requiresRuntimePrompt() {
        return true;
    }

    @Nullable
    public DeployTarget getCachedDeployTarget(@NotNull Executor executor, @NotNull AndroidFacet facet, @NotNull DeviceCount deviceCount, @NotNull Map<String, DeployTargetState> deployTargetStates, int runConfigId) {
        State showChooserState = (State)deployTargetStates.get(this.getId());
        Project project = facet.getModule().getProject();
        if (showChooserState.USE_LAST_SELECTED_DEVICE) {
            DeployTarget target = DevicePickerStateService.getInstance(project).getDeployTargetPickerResult(runConfigId);
            if (target != null && target.hasCustomRunProfileState(executor)) {
                return target;
            }
            Collection<IDevice> devices = ManualTargetChooser.getLastUsedDevices(project, runConfigId, deviceCount);
            if (!devices.isEmpty()) {
                return new RealizedDeployTarget(null, null, DeviceFutures.forDevices(devices));
            }
        }
        return null;
    }

    @Override
    @Nullable
    public DeployTarget showPrompt(@NotNull Executor executor, @NotNull ExecutionEnvironment env, @NotNull AndroidFacet facet, @NotNull DeviceCount deviceCount, boolean androidTests, @NotNull Map<String, DeployTargetState> deployTargetStates, int runConfigId, @NotNull LaunchCompatibilityChecker compatibilityChecker) {
        State showChooserState = (State)deployTargetStates.get(this.getId());
        Project project = facet.getModule().getProject();
        DeployTarget cachedDeployTarget = this.getCachedDeployTarget(executor, facet, deviceCount, deployTargetStates, runConfigId);
        if (cachedDeployTarget != null) {
            return cachedDeployTarget;
        }
        List<DeployTargetProvider<DeployTargetState>> applicableTargets = ShowChooserTargetProvider.getTargetsProvidingRunProfileState(executor, androidTests);
        DeployTargetPickerDialog dialog2 = new DeployTargetPickerDialog(runConfigId, facet, deviceCount, applicableTargets, deployTargetStates, compatibilityChecker);
        if (dialog2.showAndGet()) {
            DeployTarget result2 = dialog2.getSelectedDeployTarget();
            if (result2 == null) {
                return null;
            }
            if (showChooserState.USE_LAST_SELECTED_DEVICE) {
                DevicePickerStateService.getInstance(project).setDeployPickerResult(runConfigId, result2.hasCustomRunProfileState(executor) ? result2 : null);
                DevicePickerStateService.getInstance(project).setDevicesUsedInLaunch(runConfigId, ShowChooserTargetProvider.getRunningDevices(dialog2.getSelectedDevices()), ManualTargetChooser.getOnlineDevices(project));
            }
            return result2;
        }
        return null;
    }

    private static Set<IDevice> getRunningDevices(@NotNull List<AndroidDevice> selectedDevices) {
        HashSet result2 = Sets.newHashSet();
        for (AndroidDevice device : selectedDevices) {
            if (device instanceof ConnectedAndroidDevice) {
                result2.add(((ConnectedAndroidDevice)device).getDevice());
                continue;
            }
            return Collections.emptySet();
        }
        return result2;
    }

    @NotNull
    private static List<DeployTargetProvider<DeployTargetState>> getTargetsProvidingRunProfileState(@NotNull Executor executor, boolean androidTests) {
        ArrayList<DeployTargetProvider<DeployTargetState>> targets = new ArrayList<DeployTargetProvider<DeployTargetState>>();
        for (DeployTargetProvider target : DeployTargetProvider.getProviders()) {
            if (!target.showInDevicePicker(executor) || !target.isApplicable(androidTests, false)) continue;
            targets.add(target);
        }
        return targets;
    }

    @Override
    protected boolean isApplicable(boolean testConfiguration, boolean deviceSnapshotComboBoxVisible) {
        return !deviceSnapshotComboBoxVisible;
    }

    @Override
    public DeployTargetConfigurable createConfigurable(@NotNull Project project, @NotNull Disposable parentDisposable, @NotNull DeployTargetConfigurableContext context) {
        return new ShowChooserConfigurable();
    }

    @Override
    public DeployTarget<State> getDeployTarget() {
        throw new IllegalStateException("The results from the device picker should have been used.");
    }

    private static class ShowChooserConfigurable
    implements DeployTargetConfigurable<State> {
        private final JBCheckBox myCheckbox = new JBCheckBox("Use same device for future launches");

        @Override
        @Nullable
        public JComponent createComponent() {
            return this.myCheckbox;
        }

        @Override
        public void resetFrom(@NotNull State state, int uniqueID) {
            this.myCheckbox.setSelected(state.USE_LAST_SELECTED_DEVICE);
        }

        @Override
        public void applyTo(@NotNull State state, int uniqueID) {
            state.USE_LAST_SELECTED_DEVICE = this.myCheckbox.isSelected();
        }
    }

    public static final class State
    extends DeployTargetState {
        public boolean USE_LAST_SELECTED_DEVICE;
    }
}

