/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run.editor;

import com.android.ddmlib.IDevice;
import com.android.tools.idea.run.DeviceCount;
import com.android.tools.idea.run.DeviceFutures;
import com.android.tools.idea.run.DeviceSelectionUtils;
import com.android.tools.idea.run.TargetDeviceFilter;
import com.android.tools.idea.run.TargetSelectionMode;
import com.android.tools.idea.run.editor.DeployTarget;
import com.android.tools.idea.run.editor.DeployTargetConfigurable;
import com.android.tools.idea.run.editor.DeployTargetConfigurableContext;
import com.android.tools.idea.run.editor.DeployTargetProvider;
import com.android.tools.idea.run.editor.DeployTargetState;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.Executor;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import java.util.Collection;
import javax.swing.JComponent;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UsbDeviceTargetProvider
extends DeployTargetProvider {
    @Override
    @NotNull
    public String getId() {
        return TargetSelectionMode.USB_DEVICE.name();
    }

    @Override
    @NotNull
    public String getDisplayName() {
        return "USB Device";
    }

    @NotNull
    public DeployTargetState createState() {
        return new State();
    }

    @Override
    protected boolean isApplicable(boolean testConfiguration, boolean deviceSnapshotComboBoxVisible) {
        return !deviceSnapshotComboBoxVisible;
    }

    public DeployTargetConfigurable createConfigurable(@NotNull Project project, @NotNull Disposable parentDisposable, @NotNull DeployTargetConfigurableContext context) {
        return new TargetConfigurable();
    }

    public DeployTarget getDeployTarget() {
        return new DeployTarget(){

            @Override
            public boolean hasCustomRunProfileState(@NotNull Executor executor) {
                return false;
            }

            public RunProfileState getRunProfileState(@NotNull Executor executor, @NotNull ExecutionEnvironment env, @NotNull DeployTargetState state) throws ExecutionException {
                return null;
            }

            @Nullable
            public DeviceFutures getDevices(@NotNull DeployTargetState state, @NotNull AndroidFacet facet, @NotNull DeviceCount deviceCount, boolean debug, int runConfigId) {
                Collection<IDevice> runningDevices = DeviceSelectionUtils.chooseRunningDevice(facet, new TargetDeviceFilter.UsbDeviceFilter(), deviceCount);
                if (runningDevices == null) {
                    return null;
                }
                return DeviceFutures.forDevices(runningDevices);
            }
        };
    }

    private static class TargetConfigurable
    implements DeployTargetConfigurable<State> {
        private TargetConfigurable() {
        }

        @Override
        @Nullable
        public JComponent createComponent() {
            return null;
        }

        @Override
        public void resetFrom(@NotNull State state, int uniqueID) {
        }

        @Override
        public void applyTo(@NotNull State state, int uniqueID) {
        }
    }

    public static final class State
    extends DeployTargetState {
    }
}

