/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run.tasks;

import com.android.ddmlib.IDevice;
import com.android.tools.deployer.AdbClient;
import com.android.tools.deployer.AdbInstaller;
import com.android.tools.deployer.DeployMetric;
import com.android.tools.deployer.Deployer;
import com.android.tools.deployer.DeployerException;
import com.android.tools.deployer.Installer;
import com.android.tools.deployer.UIService;
import com.android.tools.idea.log.LogWrapper;
import com.android.tools.idea.run.ConsolePrinter;
import com.android.tools.idea.run.DeploymentService;
import com.android.tools.idea.run.IdeService;
import com.android.tools.idea.run.tasks.LaunchResult;
import com.android.tools.idea.run.tasks.LaunchTask;
import com.android.tools.idea.run.ui.BaseAction;
import com.android.tools.idea.run.util.LaunchStatus;
import com.android.utils.ILogger;
import com.google.common.base.Stopwatch;
import com.google.wireless.android.sdk.stats.LaunchTaskDetail;
import com.intellij.execution.Executor;
import com.intellij.execution.executors.DefaultDebugExecutor;
import com.intellij.execution.filters.HyperlinkInfo;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationListener;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.playback.commands.ActionCommand;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.ToolWindowId;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.swing.event.HyperlinkEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractDeployTask
implements LaunchTask {
    public static final int MIN_API_VERSION = 26;
    private static final NotificationGroup NOTIFICATION_GROUP = NotificationGroup.toolWindowGroup((String)"UnifiedDeployTask", (String)ToolWindowId.RUN);
    @NotNull
    private final Project myProject;
    @NotNull
    private final Map<String, List<File>> myPackages;
    @NotNull
    protected List<LaunchTaskDetail> mySubTaskDetails;
    private final boolean myFallback;
    public static final Logger LOG = Logger.getInstance(AbstractDeployTask.class);

    public AbstractDeployTask(@NotNull Project project, @NotNull Map<String, List<File>> packages, boolean fallback) {
        this.myProject = project;
        this.myPackages = packages;
        this.myFallback = fallback;
        this.mySubTaskDetails = new ArrayList<LaunchTaskDetail>();
    }

    @Override
    public int getDuration() {
        return 20;
    }

    @Override
    public boolean perform(@NotNull IDevice device, @NotNull LaunchStatus launchStatus, @NotNull ConsolePrinter printer) {
        return false;
    }

    @Override
    public LaunchResult run(@NotNull Executor executor, @NotNull IDevice device, @NotNull LaunchStatus launchStatus, @NotNull ConsolePrinter printer) {
        Stopwatch stopwatch = Stopwatch.createStarted();
        LogWrapper logger = new LogWrapper(LOG);
        ArrayList<DeployMetric> metrics = new ArrayList<DeployMetric>();
        long vmClockStartNs = System.nanoTime();
        long wallClockStartMs = System.currentTimeMillis();
        AdbClient adb = new AdbClient(device, (ILogger)logger);
        AdbInstaller installer = new AdbInstaller(this.getLocalInstaller(), adb, metrics, (ILogger)logger);
        DeploymentService service = DeploymentService.getInstance(this.myProject);
        IdeService ideService = new IdeService(this.myProject);
        Deployer deployer = new Deployer(adb, service.getDexDatabase(), service.getTaskRunner(), (Installer)installer, (UIService)ideService, metrics, (ILogger)logger);
        ArrayList<String> idsSkippedInstall = new ArrayList<String>();
        for (Map.Entry<String, List<File>> entry : this.myPackages.entrySet()) {
            String applicationId2 = entry.getKey();
            List<File> apkFiles = entry.getValue();
            try {
                Deployer.Result result2 = this.perform(device, deployer, applicationId2, apkFiles);
                this.addSubTaskDetails(metrics, vmClockStartNs, wallClockStartMs);
                if (!result2.skippedInstall) continue;
                idsSkippedInstall.add(applicationId2);
            }
            catch (DeployerException e) {
                logger.warning("%s failed: %s %s", new Object[]{this.getDescription(), e.getMessage(), e.getDetails()});
                return this.toLaunchResult(executor, e, printer);
            }
        }
        stopwatch.stop();
        long duration = stopwatch.elapsed(TimeUnit.MILLISECONDS);
        if (idsSkippedInstall.isEmpty()) {
            String content = String.format("%s successfully finished in %s.", this.getDescription(), StringUtil.formatDuration((long)duration));
            NOTIFICATION_GROUP.createNotification(content, NotificationType.INFORMATION).setImportant(false).notify(this.myProject);
            logger.info("%s", new Object[]{content});
        } else {
            String title = String.format("%s successfully finished in %s.", this.getDescription(), StringUtil.formatDuration((long)duration));
            String content = this.createSkippedApkInstallMessage(idsSkippedInstall, idsSkippedInstall.size() == this.myPackages.size());
            NOTIFICATION_GROUP.createNotification(title, content, NotificationType.INFORMATION, null).setImportant(false).notify(this.myProject);
            logger.info("%s. %s", new Object[]{title, content});
        }
        return new LaunchResult();
    }

    protected abstract String getFailureTitle();

    protected abstract Deployer.Result perform(IDevice var1, Deployer var2, String var3, List<File> var4) throws DeployerException;

    private String getLocalInstaller() {
        File path = new File(PathManager.getHomePath(), "plugins/android/resources/installer");
        if (!path.exists()) {
            path = new File(PathManager.getHomePath(), "../../bazel-genfiles/tools/base/deploy/installer/android-installer");
        }
        return path.getAbsolutePath();
    }

    protected static List<String> getPathsToInstall(@NotNull List<File> apkFiles) {
        return apkFiles.stream().map(File::getPath).collect(Collectors.toList());
    }

    @NotNull
    protected Project getProject() {
        return this.myProject;
    }

    private void addSubTaskDetails(@NotNull Collection<DeployMetric> metrics, long startNanoTime, long startWallClockMs) {
        for (DeployMetric metric : metrics) {
            if (metric.getName().isEmpty()) continue;
            LaunchTaskDetail.Builder detail = LaunchTaskDetail.newBuilder();
            long startOffsetMs = TimeUnit.NANOSECONDS.toMillis(metric.getStartTimeNs() - startNanoTime);
            long endOffsetMs = TimeUnit.NANOSECONDS.toMillis(metric.getEndTimeNs() - startNanoTime);
            detail.setId(this.getId() + "." + metric.getName()).setStartTimestampMs(startWallClockMs + startOffsetMs).setEndTimestampMs(startWallClockMs + endOffsetMs).setTid((int)metric.getThreadId());
            if (metric.hasStatus()) {
                detail.setStatus(metric.getStatus());
            }
            this.mySubTaskDetails.add(detail.build());
        }
    }

    @Override
    @NotNull
    public Collection<LaunchTaskDetail> getSubTaskDetails() {
        return this.mySubTaskDetails;
    }

    public LaunchResult toLaunchResult(@NotNull Executor executor, @NotNull DeployerException e, @NotNull ConsolePrinter printer) {
        LaunchResult result2 = new LaunchResult();
        result2.setSuccess(false);
        StringBuilder bubbleError = new StringBuilder(this.getFailureTitle());
        bubbleError.append("\n");
        bubbleError.append(e.getMessage());
        DeployerException.Error error = e.getError();
        if (error.getResolution() != DeployerException.ResolutionAction.NONE) {
            if (!this.myFallback) {
                bubbleError.append(String.format("\n<a href='%s'>%s</a>", error.getResolution(), error.getCallToAction()));
            } else {
                bubbleError.append(String.format("\n%s will be done automatically</a>", error.getCallToAction()));
            }
        }
        result2.setError(bubbleError.toString());
        result2.setConsoleError(this.getFailureTitle() + "\n" + e.getMessage() + "\n" + e.getDetails());
        result2.setErrorId(e.getId());
        DeploymentHyperlinkInfo hyperlinkInfo = new DeploymentHyperlinkInfo(executor, error.getResolution(), printer);
        result2.setConsoleHyperlink(error.getCallToAction(), hyperlinkInfo);
        result2.setNotificationListener(new DeploymentErrorNotificationListener(error.getResolution(), hyperlinkInfo));
        if (this.myFallback) {
            result2.addOnFinishedCallback(() -> hyperlinkInfo.navigate(this.myProject));
        }
        return result2;
    }

    protected abstract String createSkippedApkInstallMessage(List<String> var1, boolean var2);

    private class DeploymentHyperlinkInfo
    implements HyperlinkInfo {
        @Nullable
        private final String myActionId;
        @NotNull
        private final ConsolePrinter myPrinter;

        public DeploymentHyperlinkInfo(@NotNull Executor executor, @NotNull DeployerException.ResolutionAction resolutionAction, ConsolePrinter printer) {
            this.myPrinter = printer;
            switch (resolutionAction) {
                case APPLY_CHANGES: {
                    this.myActionId = "android.deploy.ApplyChanges";
                    break;
                }
                case RUN_APP: {
                    this.myActionId = DefaultDebugExecutor.EXECUTOR_ID.equals(executor.getId()) ? "Debug" : "Run";
                    break;
                }
                case RETRY: {
                    this.myActionId = AbstractDeployTask.this.getId();
                    break;
                }
                default: {
                    this.myActionId = null;
                }
            }
        }

        public void navigate(@NotNull Project project) {
            BaseAction.DisableMessage message2;
            if (this.myActionId == null) {
                return;
            }
            ActionManager manager = ActionManager.getInstance();
            AnAction action2 = manager.getAction(this.myActionId);
            if (action2 == null) {
                return;
            }
            if (action2 instanceof BaseAction && (message2 = BaseAction.getDisableMessage(project)) != null) {
                this.myPrinter.stderr(String.format("%s is disabled because %s.", action2.getTemplatePresentation().getText(), message2.getDescription()));
                return;
            }
            manager.tryToExecute(action2, ActionCommand.getInputEvent((String)"android.deploy.ApplyChanges"), null, "unknown", true);
        }
    }

    private class DeploymentErrorNotificationListener
    implements NotificationListener {
        @NotNull
        private final DeployerException.ResolutionAction myResolutionAction;
        @NotNull
        private final DeploymentHyperlinkInfo myHyperlinkInfo;

        public DeploymentErrorNotificationListener(@NotNull DeployerException.ResolutionAction resolutionAction, DeploymentHyperlinkInfo hyperlinkInfo) {
            this.myResolutionAction = resolutionAction;
            this.myHyperlinkInfo = hyperlinkInfo;
        }

        public void hyperlinkUpdate(@NotNull Notification notification, @NotNull HyperlinkEvent event) {
            if (event.getEventType() == HyperlinkEvent.EventType.ACTIVATED && event.getDescription().equals(this.myResolutionAction.name())) {
                this.myHyperlinkInfo.navigate(AbstractDeployTask.this.myProject);
            }
        }
    }
}

