/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run.tasks;

import com.android.ddmlib.IDevice;
import com.android.tools.idea.run.ConsolePrinter;
import com.android.tools.idea.run.activity.AndroidActivityLauncher;
import com.android.tools.idea.run.activity.StartActivityFlagsProvider;
import com.android.tools.idea.run.tasks.LaunchTask;
import com.android.tools.idea.run.tasks.ShellCommandLauncher;
import com.android.tools.idea.run.util.LaunchStatus;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ActivityLaunchTask
implements LaunchTask {
    @NotNull
    private final String myApplicationId;
    @NotNull
    private final StartActivityFlagsProvider myStartActivityFlagsProvider;

    public ActivityLaunchTask(@NotNull String applicationId2, @NotNull StartActivityFlagsProvider startActivityFlagsProvider) {
        this.myApplicationId = applicationId2;
        this.myStartActivityFlagsProvider = startActivityFlagsProvider;
    }

    @Override
    @NotNull
    public String getDescription() {
        return "Launching activity";
    }

    @Override
    public int getDuration() {
        return 2;
    }

    @Override
    public boolean perform(@NotNull IDevice device, @NotNull LaunchStatus launchStatus, @NotNull ConsolePrinter printer) {
        String command = this.getStartActivityCommand(device, launchStatus, printer);
        if (command == null) {
            return false;
        }
        return ShellCommandLauncher.execute(command, device, launchStatus, printer, 15L, TimeUnit.SECONDS);
    }

    @Nullable
    public String getStartActivityCommand(@NotNull IDevice device, @NotNull LaunchStatus launchStatus, @NotNull ConsolePrinter printer) {
        String activityName = this.getQualifiedActivityName(device, printer);
        if (activityName == null) {
            return null;
        }
        String activityPath = AndroidActivityLauncher.getLauncherActivityPath(this.myApplicationId, activityName);
        return AndroidActivityLauncher.getStartActivityCommand(activityPath, this.myStartActivityFlagsProvider.getFlags(device));
    }

    @Nullable
    protected abstract String getQualifiedActivityName(@NotNull IDevice var1, @NotNull ConsolePrinter var2);
}

