/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run.tasks;

import com.android.ddmlib.Client;
import com.android.ddmlib.IDevice;
import com.android.tools.deployer.ClassRedefiner;
import com.android.tools.deployer.Deployer;
import com.android.tools.deployer.DeployerException;
import com.android.tools.idea.run.tasks.AbstractDeployTask;
import com.android.tools.idea.run.util.DebuggerRedefiner;
import com.google.common.collect.ImmutableMap;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import java.io.File;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

public class ApplyCodeChangesTask
extends AbstractDeployTask {
    private static final Logger LOG = Logger.getInstance(ApplyCodeChangesTask.class);
    private static final String ID = "APPLY_CODE_CHANGES";

    public ApplyCodeChangesTask(@NotNull Project project, @NotNull Map<String, List<File>> packages, boolean fallback) {
        super(project, packages, fallback);
    }

    @Override
    @NotNull
    public String getId() {
        return ID;
    }

    private ImmutableMap<Integer, ClassRedefiner> makeSpecificRedefiners(Project project, IDevice device) throws DeployerException {
        if (!DebuggerRedefiner.hasDebuggersAttached(project)) {
            return ImmutableMap.of();
        }
        ImmutableMap.Builder debugRedefiners = ImmutableMap.builder();
        for (Client client : device.getClients()) {
            if (!client.isDebuggerAttached()) continue;
            DebuggerRedefiner debugRedefiner = new DebuggerRedefiner(project, client.getDebuggerListenPort());
            debugRedefiners.put((Object)client.getClientData().getPid(), (Object)debugRedefiner);
        }
        return debugRedefiners.build();
    }

    @Override
    protected Deployer.Result perform(IDevice device, Deployer deployer, String applicationId2, List<File> files2) throws DeployerException {
        LOG.info("Applying code changes to application: " + applicationId2);
        ImmutableMap<Integer, ClassRedefiner> redefiners = this.makeSpecificRedefiners(this.getProject(), device);
        return deployer.codeSwap(ApplyCodeChangesTask.getPathsToInstall(files2), redefiners);
    }

    @Override
    @NotNull
    public String getDescription() {
        return "Apply Code Changes";
    }

    @Override
    @NotNull
    public String getFailureTitle() {
        return "Changes were not applied.";
    }

    @Override
    @NotNull
    protected String createSkippedApkInstallMessage(List<String> skippedApkList, boolean all) {
        if (all) {
            return "No code changes detected.";
        }
        return "No code changes detected. The ollowing APK(s) are not installed: " + skippedApkList.stream().collect(Collectors.joining(", "));
    }
}

