/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run.tasks;

import com.android.ddmlib.IDevice;
import com.android.tools.deployer.Deployer;
import com.android.tools.deployer.DeployerException;
import com.android.tools.deployer.InstallOptions;
import com.android.tools.idea.flags.StudioFlags;
import com.android.tools.idea.run.tasks.AbstractDeployTask;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import java.io.File;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

public class DeployTask
extends AbstractDeployTask {
    private static final Logger LOG = Logger.getInstance(DeployTask.class);
    private static final String ID = "DEPLOY";
    private final String userInstallOptions;

    public DeployTask(@NotNull Project project, @NotNull Map<String, List<File>> packages, String userInstallOptions) {
        super(project, packages, false);
        this.userInstallOptions = userInstallOptions;
    }

    @Override
    @NotNull
    public String getId() {
        return ID;
    }

    @Override
    protected Deployer.Result perform(IDevice device, Deployer deployer, String applicationId2, List<File> files2) throws DeployerException {
        InstallOptions.Builder options = InstallOptions.builder().setAllowDebuggable();
        if (device.supportsFeature(IDevice.HardwareFeature.EMBEDDED)) {
            options.setGrantAllPermissions();
        }
        if (device.getVersion().isGreaterOrEqualThan(28)) {
            options.setInstallFullApk();
        }
        if (this.userInstallOptions != null) {
            options.setUserInstallOptions(this.userInstallOptions);
        }
        LOG.info("Installing application: " + applicationId2);
        Deployer.InstallMode installMode = Deployer.InstallMode.DELTA;
        if (!((Boolean)StudioFlags.DELTA_INSTALL.get()).booleanValue()) {
            installMode = Deployer.InstallMode.FULL;
        }
        return deployer.install(applicationId2, DeployTask.getPathsToInstall(files2), options.build(), installMode);
    }

    @Override
    @NotNull
    public String getDescription() {
        return "Install";
    }

    @Override
    @NotNull
    public String getFailureTitle() {
        return "Installation did not succeed.";
    }

    @Override
    @NotNull
    protected String createSkippedApkInstallMessage(List<String> skippedApkList, boolean all) {
        if (all) {
            return "App restart successful without requiring a re-install.";
        }
        return "App restart successful without re-installing the following APK(s): " + skippedApkList.stream().collect(Collectors.joining(", "));
    }
}

