/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run.tasks;

import com.android.ddmlib.AndroidDebugBridge;
import com.android.ddmlib.IDevice;
import com.android.tools.idea.gradle.util.DynamicAppUtils;
import com.android.tools.idea.instantapp.InstantAppSdks;
import com.android.tools.idea.run.ApkFileUnit;
import com.android.tools.idea.run.ApkInfo;
import com.android.tools.idea.run.ConsolePrinter;
import com.android.tools.idea.run.tasks.LaunchTask;
import com.android.tools.idea.run.util.LaunchStatus;
import com.google.android.instantapps.sdk.api.ExtendedSdk;
import com.google.android.instantapps.sdk.api.HandlerResult;
import com.google.android.instantapps.sdk.api.ProgressIndicator;
import com.google.android.instantapps.sdk.api.ResultStream;
import com.google.android.instantapps.sdk.api.StatusCode;
import com.google.common.collect.ImmutableList;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.ui.Messages;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RunInstantAppTask
implements LaunchTask {
    private static final String ID = "RUN_INSTANT_APP";
    @NotNull
    private final Collection<ApkInfo> myPackages;
    @Nullable
    private final String myDeepLink;
    @NotNull
    private final InstantAppSdks mySdk;
    @NotNull
    private final List<String> myDisabledFeatures;

    public RunInstantAppTask(@NotNull Collection<ApkInfo> packages, @Nullable String link, @NotNull List<String> disabledFeatures) {
        this.myPackages = packages;
        this.myDeepLink = link;
        this.mySdk = InstantAppSdks.getInstance();
        this.myDisabledFeatures = disabledFeatures;
    }

    public RunInstantAppTask(@NotNull Collection<ApkInfo> packages, @Nullable String link) {
        this(packages, link, (List<String>)ImmutableList.of());
    }

    @Override
    @NotNull
    public String getDescription() {
        return "Uploading and launching Instant App";
    }

    @Override
    public int getDuration() {
        return 20;
    }

    @Override
    public boolean perform(@NotNull IDevice device, @NotNull LaunchStatus launchStatus, final @NotNull ConsolePrinter printer) {
        if (launchStatus.isLaunchTerminated()) {
            return false;
        }
        if (this.myPackages.size() != 1) {
            printer.stderr("Package not found or not unique.");
            return false;
        }
        URL url = null;
        if (this.myDeepLink != null && !this.myDeepLink.isEmpty()) {
            try {
                url = new URL(this.myDeepLink);
            }
            catch (MalformedURLException e) {
                printer.stderr("Invalid launch URL: " + this.myDeepLink);
                return false;
            }
        }
        ResultStream resultStream = new ResultStream(){

            public void write(HandlerResult result2) {
                if (result2.isError()) {
                    ApplicationManager.getApplication().invokeLater(() -> Messages.showWarningDialog((String)result2.getDetail(), (String)"Instant App Deployment Failed"));
                    printer.stderr(result2.toString());
                    RunInstantAppTask.getLogger().warn((Throwable)new RunInstantAppException(result2.getMessage()));
                } else {
                    printer.stdout(result2.toString());
                }
            }
        };
        try {
            ExtendedSdk aiaSdk = this.mySdk.loadLibrary();
            assert (aiaSdk != null);
            ApkInfo apkInfo = this.myPackages.iterator().next();
            List<ApkFileUnit> artifactFiles = apkInfo.getFiles();
            StatusCode status = RunInstantAppTask.isSingleZipFile(artifactFiles) ? aiaSdk.getRunHandler().runZip(artifactFiles.get(0).getApkFile(), url, AndroidDebugBridge.getSocketAddress(), device.getSerialNumber(), null, resultStream, (ProgressIndicator)new NullProgressIndicator()) : aiaSdk.getRunHandler().runApks((ImmutableList)artifactFiles.stream().filter(apkFileUnit -> DynamicAppUtils.isFeatureEnabled(this.myDisabledFeatures, apkFileUnit)).map(ApkFileUnit::getApkFile).collect(ImmutableList.toImmutableList()), url, AndroidDebugBridge.getSocketAddress(), device.getSerialNumber(), null, resultStream, (ProgressIndicator)new NullProgressIndicator());
            return status == StatusCode.SUCCESS;
        }
        catch (Exception e) {
            printer.stderr(e.toString());
            RunInstantAppTask.getLogger().error((Throwable)new RunInstantAppException(e));
            return false;
        }
    }

    @Override
    @NotNull
    public String getId() {
        return ID;
    }

    @NotNull
    private static Logger getLogger() {
        return Logger.getInstance(RunInstantAppTask.class);
    }

    private static boolean isSingleZipFile(List<ApkFileUnit> artifactFiles) {
        return artifactFiles.size() == 1 && artifactFiles.get(0).getApkFile().getName().toLowerCase().endsWith(".zip");
    }

    @NotNull
    public Collection<ApkInfo> getPackages() {
        return this.myPackages;
    }

    private static class NullProgressIndicator
    implements ProgressIndicator {
        private NullProgressIndicator() {
        }

        public void setProgress(double v) {
        }
    }

    public static class RunInstantAppException
    extends Exception {
        private RunInstantAppException(@NotNull String message2) {
            super(message2);
        }

        private RunInstantAppException(@NotNull Throwable t) {
            super(t);
        }
    }
}

