/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run.tasks;

import com.android.ddmlib.IDevice;
import com.android.ddmlib.InstallException;
import com.android.ddmlib.IotInstallChecker;
import com.android.tools.idea.run.ConsolePrinter;
import com.android.tools.idea.run.RetryingInstaller;
import com.android.tools.idea.run.tasks.LaunchTask;
import com.android.tools.idea.run.util.LaunchStatus;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.annotations.NotNull;

public class UninstallIotLauncherAppsTask
implements LaunchTask {
    private static final String ID = "UNINSTALL_IOT";
    private final String myPackageName;
    private final RetryingInstaller.Prompter myPrompter;
    private final IotInstallChecker myChecker;

    public UninstallIotLauncherAppsTask(Project project, String packageName) {
        this(packageName, new IotInstallChecker(), new RetryingInstaller.UserPrompter(project));
    }

    UninstallIotLauncherAppsTask(String packageName, IotInstallChecker checker, RetryingInstaller.Prompter prompter) {
        this.myPackageName = packageName;
        this.myPrompter = prompter;
        this.myChecker = checker;
    }

    @Override
    @NotNull
    public String getDescription() {
        return "Uninstalling other IoT apps";
    }

    @Override
    public int getDuration() {
        return 20;
    }

    @Override
    public boolean perform(@NotNull IDevice device, @NotNull LaunchStatus launchStatus, @NotNull ConsolePrinter printer) {
        if (!device.supportsFeature(IDevice.HardwareFeature.EMBEDDED)) {
            return true;
        }
        Set installedIotLauncherApps = this.myChecker.getInstalledIotLauncherApps(device);
        installedIotLauncherApps.remove(this.myPackageName);
        if (!installedIotLauncherApps.isEmpty()) {
            String otherApplicationIds = StringUtil.join((Collection)installedIotLauncherApps, (String)"\n");
            String reason = AndroidBundle.message("deployment.failed.uninstall.prompt.androidthings.text", otherApplicationIds);
            if (this.myPrompter.showQuestionPrompt(reason)) {
                TreeMap<String, InstallException> failedUninstallApps = new TreeMap<String, InstallException>();
                for (Object app : installedIotLauncherApps) {
                    try {
                        device.uninstallPackage((String)app);
                    }
                    catch (InstallException installException) {
                        failedUninstallApps.put((String)app, installException);
                    }
                }
                if (!failedUninstallApps.isEmpty()) {
                    StringBuffer sb = new StringBuffer();
                    for (Map.Entry entry : failedUninstallApps.entrySet()) {
                        sb.append(entry.getKey());
                        sb.append(": ");
                        sb.append(entry.getValue());
                        sb.append("\n");
                    }
                    String errorMessage = AndroidBundle.message("deployment.failed.uninstall.prompt.androidthings.errortext", sb.toString());
                    this.myPrompter.showErrorMessage(errorMessage);
                    return false;
                }
            } else {
                printer.stdout("Installation aborted");
                return false;
            }
        }
        return true;
    }

    @Override
    @NotNull
    public String getId() {
        return ID;
    }
}

