/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run.ui;

import com.android.tools.idea.run.ui.BaseAction;
import com.intellij.execution.RunManager;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.KeyboardShortcut;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.SystemInfo;
import icons.StudioIcons;
import javax.swing.KeyStroke;
import org.jetbrains.android.util.AndroidCommonUtils;
import org.jetbrains.annotations.NotNull;

public class ApplyChangesAction
extends BaseAction {
    public static final String ID = "android.deploy.ApplyChanges";
    public static final Key<Boolean> KEY = Key.create((String)"android.deploy.ApplyChanges");
    public static final String NAME = "Apply Changes and Restart Activity";
    private static final Shortcut SHORTCUT = new KeyboardShortcut(KeyStroke.getKeyStroke(SystemInfo.isMac ? "control meta R" : "control F10"), null);
    private static final String DESC = "Attempt to apply resource and code changes and restart activity.";

    public ApplyChangesAction() {
        super(ID, NAME, KEY, StudioIcons.Shell.Toolbar.APPLY_ALL_CHANGES, SHORTCUT, DESC);
    }

    @Override
    public void update(@NotNull AnActionEvent e) {
        ConfigurationType type;
        String id;
        super.update(e);
        Project project = e.getProject();
        if (project == null) {
            return;
        }
        RunnerAndConfigurationSettings runConfig = RunManager.getInstance((Project)project).getSelectedConfiguration();
        if (runConfig != null && (AndroidCommonUtils.isTestConfiguration((String)(id = (type = runConfig.getType()).getId())) || AndroidCommonUtils.isInstrumentationTestConfiguration((String)id))) {
            this.disableAction(e.getPresentation(), new BaseAction.DisableMessage(BaseAction.DisableMessage.DisableMode.DISABLED, "test project", "the selected configuration is a test configuration"));
        }
    }
}

