/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run.ui;

import com.android.tools.idea.run.ui.BaseAction;
import com.intellij.execution.RunManager;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.KeyboardShortcut;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.SystemInfo;
import icons.StudioIcons;
import javax.swing.KeyStroke;
import org.jetbrains.android.util.AndroidCommonUtils;
import org.jetbrains.annotations.NotNull;

public class CodeSwapAction
extends BaseAction {
    public static final String ID = "android.deploy.CodeSwap";
    public static final Key<Boolean> KEY = Key.create((String)"android.deploy.CodeSwap");
    public static final String NAME = "Apply Code Changes";
    private static final Shortcut SHORTCUT = new KeyboardShortcut(KeyStroke.getKeyStroke(SystemInfo.isMac ? "control meta shift R" : "control alt F10"), null);
    private static final String DESC = "Attempt to apply only code changes without restarting anything.";

    public CodeSwapAction() {
        super(ID, NAME, KEY, StudioIcons.Shell.Toolbar.APPLY_CODE_SWAP, SHORTCUT, DESC);
    }

    @Override
    public void update(@NotNull AnActionEvent e) {
        ConfigurationType type;
        String id;
        super.update(e);
        Project project = e.getProject();
        if (project == null) {
            return;
        }
        RunnerAndConfigurationSettings runConfig = RunManager.getInstance((Project)project).getSelectedConfiguration();
        if (runConfig != null && AndroidCommonUtils.isTestConfiguration((String)(id = (type = runConfig.getType()).getId()))) {
            this.disableAction(e.getPresentation(), new BaseAction.DisableMessage(BaseAction.DisableMessage.DisableMode.DISABLED, "test project", "the selected configuration is a test configuration"));
        }
    }
}

