/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run.util;

import com.android.tools.deploy.proto.Deploy;
import com.android.tools.deployer.ClassRedefiner;
import com.android.tools.deployer.DeployerException;
import com.android.tools.deployer.JdiBasedClassRedefiner;
import com.intellij.debugger.DebuggerManagerEx;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.DebuggerManagerThreadImpl;
import com.intellij.debugger.engine.JavaExecutionStack;
import com.intellij.debugger.engine.SuspendContextImpl;
import com.intellij.debugger.engine.events.DebuggerCommandImpl;
import com.intellij.debugger.impl.DebuggerContextImpl;
import com.intellij.debugger.impl.DebuggerSession;
import com.intellij.debugger.impl.MultiProcessCommand;
import com.intellij.debugger.jdi.ThreadReferenceProxyImpl;
import com.intellij.debugger.jdi.VirtualMachineProxyImpl;
import com.intellij.debugger.ui.breakpoints.BreakpointManager;
import com.intellij.debugger.ui.breakpoints.StackCapturingLineBreakpoint;
import com.intellij.execution.configurations.RemoteConnection;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.util.concurrency.Semaphore;
import com.intellij.xdebugger.XDebugSession;
import com.sun.jdi.VirtualMachine;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.IntStream;
import javax.swing.SwingUtilities;

public class DebuggerRedefiner
implements ClassRedefiner {
    private final Project project;
    private final int debuggerPort;
    private ClassRedefiner.RedefineClassSupportState supportState = null;

    public DebuggerRedefiner(Project project, int debuggerPort) {
        this.project = project;
        this.debuggerPort = debuggerPort;
    }

    public ClassRedefiner.RedefineClassSupportState canRedefineClass() {
        if (this.supportState != null) {
            return this.supportState;
        }
        MultiProcessCommand commands2 = new MultiProcessCommand();
        Collection debuggerSessions = DebuggerManagerEx.getInstanceEx((Project)this.project).getSessions();
        ArrayList<1> tasks = new ArrayList<1>(debuggerSessions.size());
        final AtomicReference result2 = new AtomicReference();
        for (final DebuggerSession debuggerSession : debuggerSessions) {
            RemoteConnection s = debuggerSession.getProcess().getConnection();
            String address = s.getAddress();
            int projectDebuggerPort = Integer.parseInt(address);
            if (this.debuggerPort != projectDebuggerPort) continue;
            DebuggerCommandImpl command = new DebuggerCommandImpl(){

                protected void action() {
                    result2.set(DebuggerRedefiner.this.canRedefineClassInternal(debuggerSession));
                }
            };
            commands2.addCommand(debuggerSession.getProcess(), command);
            tasks.add(command);
        }
        commands2.run();
        tasks.forEach(cmd -> cmd.waitFor());
        this.supportState = (ClassRedefiner.RedefineClassSupportState)result2.get();
        return this.supportState;
    }

    private ClassRedefiner.RedefineClassSupportState canRedefineClassInternal(DebuggerSession debuggerSession) {
        DebuggerManagerThreadImpl.assertIsManagerThread();
        DebugProcessImpl debugProcess = debuggerSession.getProcess();
        VirtualMachineProxyImpl virtualMachineProxy = debugProcess.getVirtualMachineProxy();
        if (virtualMachineProxy.canRedefineClasses()) {
            return new ClassRedefiner.RedefineClassSupportState(ClassRedefiner.RedefineClassSupport.FULL, null);
        }
        Collection allThreads = virtualMachineProxy.allThreads();
        for (ThreadReferenceProxyImpl thread : allThreads) {
            if (!thread.name().equals("main") || thread.isSuspended()) continue;
            return new ClassRedefiner.RedefineClassSupportState(ClassRedefiner.RedefineClassSupport.MAIN_THREAD_RUNNING, "main");
        }
        for (ThreadReferenceProxyImpl thread : allThreads) {
            if (!thread.isAtBreakpoint()) continue;
            ClassRedefiner.RedefineClassSupportState state = new ClassRedefiner.RedefineClassSupportState(ClassRedefiner.RedefineClassSupport.NEEDS_AGENT_SERVER, thread.name());
            return state;
        }
        return new ClassRedefiner.RedefineClassSupportState(ClassRedefiner.RedefineClassSupport.NONE, null);
    }

    public Deploy.SwapResponse redefine(final Deploy.SwapRequest request) throws DeployerException {
        MultiProcessCommand commands2 = new MultiProcessCommand();
        Collection debuggerSessions = DebuggerManagerEx.getInstanceEx((Project)this.project).getSessions();
        ArrayList<2> tasks = new ArrayList<2>(debuggerSessions.size());
        if (debuggerSessions.isEmpty()) {
            return (Deploy.SwapResponse)Deploy.SwapResponse.newBuilder().setStatus(Deploy.SwapResponse.Status.NO_DEBUGGER_SESSIONS).build();
        }
        final List exceptions = Collections.synchronizedList(new LinkedList());
        for (final DebuggerSession debuggerSession : debuggerSessions) {
            DebuggerCommandImpl command = new DebuggerCommandImpl(){

                protected void action() {
                    try {
                        DebuggerRedefiner.this.redefine(DebuggerRedefiner.this.project, debuggerSession, request);
                    }
                    catch (DeployerException e) {
                        exceptions.add(e);
                    }
                }

                protected void commandCancelled() {
                    debuggerSession.setModifiedClassesScanRequired(true);
                }
            };
            commands2.addCommand(debuggerSession.getProcess(), command);
            tasks.add(command);
        }
        commands2.run();
        tasks.forEach(cmd -> cmd.waitFor());
        if (!exceptions.isEmpty()) {
            throw (DeployerException)((Object)exceptions.get(0));
        }
        return (Deploy.SwapResponse)Deploy.SwapResponse.newBuilder().setStatus(Deploy.SwapResponse.Status.OK).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void redefine(Project project, DebuggerSession session, Deploy.SwapRequest request) throws DeployerException {
        try {
            DebuggerRedefiner.disableBreakPoints(project, session);
            VirtualMachine vm = session.getProcess().getVirtualMachineProxy().getVirtualMachine();
            new JdiBasedClassRedefiner(vm, this.canRedefineClass()).redefine(request);
        }
        finally {
            DebuggerRedefiner.enableBreakPoints(project, session);
        }
    }

    public static boolean hasDebuggersAttached(Project project) {
        return !DebuggerManagerEx.getInstanceEx((Project)project).getSessions().isEmpty();
    }

    private static void disableBreakPoints(Project project, DebuggerSession debuggerSession) {
        DebuggerManagerThreadImpl.assertIsManagerThread();
        DebugProcessImpl debugProcess = debuggerSession.getProcess();
        BreakpointManager breakpointManager = DebuggerManagerEx.getInstanceEx((Project)project).getBreakpointManager();
        breakpointManager.disableBreakpoints(debugProcess);
        StackCapturingLineBreakpoint.deleteAll((DebugProcessImpl)debugProcess);
        VirtualMachineProxyImpl virtualMachineProxy = debugProcess.getVirtualMachineProxy();
        if (Registry.is((String)"debugger.resume.yourkit.threads")) {
            virtualMachineProxy.allThreads().stream().filter(ThreadReferenceProxyImpl::isResumeOnHotSwap).filter(ThreadReferenceProxyImpl::isSuspended).forEach(t -> IntStream.range(0, t.getSuspendCount()).forEach(i2 -> t.resume()));
        }
    }

    private static void enableBreakPoints(Project project, DebuggerSession debuggerSession) {
        JavaExecutionStack stack;
        DebuggerManagerThreadImpl.assertIsManagerThread();
        DebugProcessImpl debugProcess = debuggerSession.getProcess();
        BreakpointManager breakpointManager = DebuggerManagerEx.getInstanceEx((Project)project).getBreakpointManager();
        debugProcess.onHotSwapFinished();
        DebuggerContextImpl context = debuggerSession.getContextManager().getContext();
        SuspendContextImpl suspendContext = context.getSuspendContext();
        if (suspendContext != null && (stack = suspendContext.getActiveExecutionStack()) != null) {
            stack.initTopFrame();
        }
        Semaphore waitSemaphore = new Semaphore();
        waitSemaphore.down();
        SwingUtilities.invokeLater(() -> {
            try {
                if (!project.isDisposed()) {
                    breakpointManager.reloadBreakpoints();
                    debugProcess.getRequestsManager().clearWarnings();
                    debuggerSession.refresh(false);
                    XDebugSession session = debuggerSession.getXDebugSession();
                    if (session != null) {
                        session.rebuildViews();
                    }
                }
            }
            finally {
                waitSemaphore.up();
            }
        });
        waitSemaphore.waitFor();
        if (!project.isDisposed()) {
            breakpointManager.enableBreakpoints(debugProcess);
            StackCapturingLineBreakpoint.createAll((DebugProcessImpl)debugProcess);
        }
    }
}

