/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run.util;

import com.android.tools.idea.run.util.LaunchStatus;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessOutputTypes;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ProcessHandlerLaunchStatus
implements LaunchStatus {
    @NotNull
    private ProcessHandler myHandler;
    private boolean myTerminated;

    public ProcessHandlerLaunchStatus(@NotNull ProcessHandler handler) {
        this.myHandler = handler;
    }

    @NotNull
    public ProcessHandler getProcessHandler() {
        return this.myHandler;
    }

    public void setProcessHandler(@NotNull ProcessHandler handler) {
        this.myHandler = handler;
    }

    @Override
    public boolean isLaunchTerminated() {
        return this.myTerminated || this.myHandler.isProcessTerminated() || this.myHandler.isProcessTerminating();
    }

    @Override
    public void terminateLaunch(@Nullable String reason, boolean destroyProcess) {
        this.myTerminated = true;
        this.myHandler.notifyTextAvailable(reason + "\n", ProcessOutputTypes.STDERR);
        if (destroyProcess) {
            this.myHandler.destroyProcess();
        }
    }
}

