/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.sampledata.datasource;

import com.android.ide.common.util.PathString;
import com.android.tools.idea.projectsystem.ProjectSystemUtil;
import com.google.common.base.Charsets;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.function.Function;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ResourceContent
implements Function<OutputStream, Exception> {
    private static final Logger LOG = Logger.getInstance(ResourceContent.class);
    private static final String[] LIB_CUSTOM_PATHS = new String[]{"/plugins/android/lib/sampleData", "/../adt/idea/android/lib/sampleData", "/community/android/android/lib/sampleData"};
    byte[] myContent;

    private ResourceContent(@NotNull byte[] content) {
        this.myContent = content;
    }

    @Nullable
    public static File getSampleDataBaseDir() {
        String homePath = FileUtil.toSystemIndependentName((String)PathManager.getHomePath());
        StringBuilder notFoundPaths = new StringBuilder();
        for (String path : LIB_CUSTOM_PATHS) {
            String jarPath = homePath + path;
            VirtualFile rootDir = LocalFileSystem.getInstance().findFileByPath(FileUtil.toSystemIndependentName((String)jarPath));
            if (rootDir != null) {
                File rootFile = VfsUtilCore.virtualToIoFile((VirtualFile)rootDir);
                if (!rootFile.exists()) continue;
                LOG.debug("Sample data base dir found at " + jarPath);
                return rootFile;
            }
            notFoundPaths.append(jarPath).append('\n');
        }
        LOG.warn("Unable to sampleData in paths:\n" + notFoundPaths.toString());
        return null;
    }

    @Nullable
    public static File getSampleDataUserDir(AndroidFacet facet) {
        PathString sampleDataDirectory = ProjectSystemUtil.getModuleSystem(facet.getModule()).getSampleDataDirectory();
        return sampleDataDirectory != null ? sampleDataDirectory.toFile() : null;
    }

    @NotNull
    public static ResourceContent fromDirectory(@NotNull String relativePath) {
        File baseDir = ResourceContent.getSampleDataBaseDir();
        File sampleDataPath = baseDir != null ? new File(baseDir, relativePath) : null;
        File[] files2 = sampleDataPath != null && sampleDataPath.isDirectory() ? sampleDataPath.listFiles() : null;
        StringBuilder content = new StringBuilder();
        if (files2 != null) {
            for (File file : files2) {
                content.append(file.getAbsolutePath()).append('\n');
            }
        }
        return new ResourceContent(content.toString().getBytes(Charsets.UTF_8));
    }

    @NotNull
    public static ResourceContent fromInputStream(@NotNull InputStream stream) {
        byte[] content;
        try (ByteArrayOutputStream bytes = new ByteArrayOutputStream();){
            int count;
            byte[] buffer = new byte[1024];
            while ((count = stream.read(buffer)) != -1) {
                bytes.write(buffer, 0, count);
            }
            content = bytes.toByteArray();
        }
        catch (IOException e) {
            content = new byte[]{};
        }
        return new ResourceContent(content);
    }

    @Override
    public Exception apply(OutputStream stream) {
        try {
            stream.write(this.myContent);
        }
        catch (IOException e) {
            return e;
        }
        return null;
    }
}

