/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.sdk;

import com.android.tools.idea.IdeInfo;
import com.android.tools.idea.gradle.project.sync.hyperlink.DownloadAndroidStudioHyperlink;
import com.android.tools.idea.gradle.project.sync.hyperlink.DownloadJdk8Hyperlink;
import com.android.tools.idea.gradle.project.sync.hyperlink.SelectJdkFromFileSystemHyperlink;
import com.android.tools.idea.gradle.project.sync.hyperlink.UseEmbeddedJdkHyperlink;
import com.android.tools.idea.gradle.project.sync.hyperlink.UseJavaHomeAsJdkHyperlink;
import com.android.tools.idea.gradle.util.EmbeddedDistributionPaths;
import com.android.tools.idea.project.hyperlink.NotificationHyperlink;
import com.android.tools.idea.sdk.IdeSdks;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Lists;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.CapturingAnsiEscapesAwareProcessHandler;
import com.intellij.ide.impl.NewProjectUtil;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.JavaSdk;
import com.intellij.openapi.projectRoots.JavaSdkVersion;
import com.intellij.openapi.projectRoots.ProjectJdkTable;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkType;
import com.intellij.openapi.projectRoots.impl.SdkConfigurationUtil;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.util.SystemProperties;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Jdks {
    @NotNull
    private static final Logger LOG = Logger.getInstance(Jdks.class);
    @NonNls
    public static final String DOWNLOAD_JDK_8_URL = "http://www.oracle.com/technetwork/java/javase/downloads/jdk8-downloads-2133151.html";
    private static final LanguageLevel DEFAULT_LANG_LEVEL = LanguageLevel.JDK_1_8;
    @NotNull
    private final IdeInfo myIdeInfo;

    @NotNull
    public static Jdks getInstance() {
        return (Jdks)ServiceManager.getService(Jdks.class);
    }

    public Jdks(@NotNull IdeInfo ideInfo) {
        this.myIdeInfo = ideInfo;
    }

    @Nullable
    public Sdk chooseOrCreateJavaSdk() {
        return this.chooseOrCreateJavaSdk(null);
    }

    @Nullable
    public Sdk chooseOrCreateJavaSdk(@Nullable LanguageLevel langLevel) {
        if (langLevel == null) {
            langLevel = DEFAULT_LANG_LEVEL;
        }
        if (this.myIdeInfo.isAndroidStudio() && !IdeSdks.getInstance().isUsingEmbeddedJdk()) {
            File viableJdkPath = EmbeddedDistributionPaths.getInstance().tryToGetEmbeddedJdkPath();
            if (viableJdkPath == null) {
                viableJdkPath = new File(System.getProperty("java.home"));
            }
            Sdk jdk = this.createJdk(viableJdkPath.getPath());
            assert (jdk != null && this.isApplicableJdk(jdk, langLevel));
            return jdk;
        }
        for (Sdk sdk : ProjectJdkTable.getInstance().getAllJdks()) {
            if (!this.isApplicableJdk(sdk, langLevel)) continue;
            return sdk;
        }
        String jdkHomePath = Jdks.getJdkHomePath(langLevel);
        if (jdkHomePath != null) {
            return this.createJdk(jdkHomePath);
        }
        return null;
    }

    public boolean isApplicableJdk(@NotNull Sdk jdk) {
        return this.isApplicableJdk(jdk, null);
    }

    public boolean isApplicableJdk(@NotNull Sdk jdk, @Nullable LanguageLevel langLevel) {
        JavaSdkVersion version2;
        if (!(jdk.getSdkType() instanceof JavaSdk)) {
            return false;
        }
        if (langLevel == null) {
            langLevel = DEFAULT_LANG_LEVEL;
        }
        if ((version2 = JavaSdk.getInstance().getVersion(jdk)) != null) {
            return Jdks.hasMatchingLangLevel(version2, langLevel);
        }
        return false;
    }

    @Nullable
    private static String getJdkHomePath(@NotNull LanguageLevel langLevel) {
        ArrayList jdkHomePaths = new ArrayList(JavaSdk.getInstance().suggestHomePaths());
        if (jdkHomePaths.isEmpty()) {
            return null;
        }
        ArrayList<String> list = new ArrayList<String>();
        String javaHome = SystemProperties.getJavaHome();
        if (javaHome != null && !javaHome.isEmpty()) {
            Iterator it = jdkHomePaths.iterator();
            while (it.hasNext()) {
                String path = (String)it.next();
                if (path == null || !javaHome.startsWith(path)) continue;
                it.remove();
                list.add(path);
            }
        }
        list.addAll(jdkHomePaths);
        return Jdks.getBestJdkHomePath(list, langLevel);
    }

    @Nullable
    private static String getBestJdkHomePath(@NotNull Collection<String> jdkHomePaths, @NotNull LanguageLevel langLevel) {
        ArrayList roots = Lists.newArrayList();
        for (String jdkHomePath : jdkHomePaths) {
            if (!StringUtil.isNotEmpty((String)jdkHomePath)) continue;
            roots.add(jdkHomePath);
            roots.addAll(Jdks.getChildrenPaths(jdkHomePath));
        }
        return Jdks.getBestJdk(roots, langLevel);
    }

    @NotNull
    private static List<String> getChildrenPaths(@NotNull String dirPath) {
        File dir = new File(dirPath);
        if (!dir.isDirectory()) {
            return Collections.emptyList();
        }
        ArrayList childrenPaths = Lists.newArrayList();
        for (File child : FileUtil.notNullize((File[])dir.listFiles())) {
            boolean directory = child.isDirectory();
            if (!directory) continue;
            childrenPaths.add(child.getAbsolutePath());
        }
        return childrenPaths;
    }

    @Nullable
    private static String getBestJdk(@NotNull List<String> jdkRoots, @NotNull LanguageLevel langLevel) {
        String bestJdk = null;
        for (String jdkRoot : jdkRoots) {
            if (!JavaSdk.getInstance().isValidSdkHome(jdkRoot)) continue;
            if (bestJdk == null && Jdks.hasMatchingLangLevel(jdkRoot, langLevel)) {
                bestJdk = jdkRoot;
                continue;
            }
            if (bestJdk == null) continue;
            bestJdk = Jdks.selectJdk(bestJdk, jdkRoot, langLevel);
        }
        return bestJdk;
    }

    @Nullable
    private static String selectJdk(@NotNull String jdk1, @NotNull String jdk2, @NotNull LanguageLevel langLevel) {
        if (Jdks.hasMatchingLangLevel(jdk1, langLevel)) {
            return jdk1;
        }
        if (Jdks.hasMatchingLangLevel(jdk2, langLevel)) {
            return jdk2;
        }
        return null;
    }

    private static boolean hasMatchingLangLevel(@NotNull String jdkRoot, @NotNull LanguageLevel langLevel) {
        JavaSdkVersion version2 = Jdks.getVersion(jdkRoot);
        if (version2 == null) {
            version2 = JavaSdkVersion.JDK_1_0;
        }
        return Jdks.hasMatchingLangLevel(version2, langLevel);
    }

    @VisibleForTesting
    static boolean hasMatchingLangLevel(@NotNull JavaSdkVersion jdkVersion, @NotNull LanguageLevel langLevel) {
        LanguageLevel max = jdkVersion.getMaxLanguageLevel();
        return max.isAtLeast(langLevel);
    }

    @Nullable
    public JavaSdkVersion findVersion(@NotNull File jdkRoot) {
        return Jdks.getVersion(jdkRoot.getPath());
    }

    @Nullable
    private static JavaSdkVersion getVersion(String jdkRoot) {
        String version2 = JavaSdk.getInstance().getVersionString(jdkRoot);
        return StringUtil.isEmpty((String)version2) ? null : JavaSdkVersion.fromVersionString((String)version2);
    }

    @Nullable
    public Sdk createJdk(@NotNull String jdkHomePath) {
        Sdk jdk = SdkConfigurationUtil.createAndAddSDK((String)jdkHomePath, (SdkType)JavaSdk.getInstance());
        if (jdk == null) {
            String msg = String.format("Unable to create JDK from path '%1$s'", jdkHomePath);
            LOG.error(msg);
        }
        return jdk;
    }

    @Nullable
    public Sdk createEmbeddedJdk() {
        if (this.myIdeInfo.isAndroidStudio()) {
            File path = EmbeddedDistributionPaths.getInstance().tryToGetEmbeddedJdkPath();
            if (path == null) {
                return null;
            }
            Sdk jdk = this.createJdk(path.getPath());
            assert (jdk != null);
            return jdk;
        }
        return null;
    }

    public void setJdk(@NotNull Project project, @NotNull Sdk jdk) {
        NewProjectUtil.applyJdkToProject((Project)project, (Sdk)jdk);
    }

    @NotNull
    public List<NotificationHyperlink> getWrongJdkQuickFixes(@NotNull Project project) {
        ArrayList quickFixes = Lists.newArrayList();
        if (this.myIdeInfo.isAndroidStudio()) {
            UseJavaHomeAsJdkHyperlink useJavaHomeHyperlink;
            String javaHome;
            IdeSdks ideSdks = IdeSdks.getInstance();
            if (!ideSdks.isUsingJavaHomeJdk() && (javaHome = IdeSdks.getJdkFromJavaHome()) != null && ideSdks.validateJdkPath(new File(javaHome)) != null && (useJavaHomeHyperlink = UseJavaHomeAsJdkHyperlink.create()) != null) {
                quickFixes.add(useJavaHomeHyperlink);
            }
            if (quickFixes.isEmpty()) {
                File embeddedJdkPath = EmbeddedDistributionPaths.getInstance().tryToGetEmbeddedJdkPath();
                if (embeddedJdkPath != null && Jdks.isJdkRunnableOnPlatform(embeddedJdkPath.getAbsolutePath())) {
                    quickFixes.add(new UseEmbeddedJdkHyperlink());
                } else {
                    quickFixes.add(new DownloadAndroidStudioHyperlink());
                }
            }
        }
        quickFixes.add(new DownloadJdk8Hyperlink());
        SelectJdkFromFileSystemHyperlink selectJdkHyperlink = SelectJdkFromFileSystemHyperlink.create(project);
        if (selectJdkHyperlink != null) {
            quickFixes.add(selectJdkHyperlink);
        }
        return quickFixes;
    }

    public static boolean isJdkRunnableOnPlatform(@NotNull Sdk jdk) {
        if (!(jdk.getSdkType() instanceof JavaSdk)) {
            return false;
        }
        if (!SystemInfo.isWindows || !SystemInfo.is32Bit) {
            return true;
        }
        JavaSdk javaSdk = (JavaSdk)jdk.getSdkType();
        String javaExecutablePath = javaSdk.getVMExecutablePath(jdk);
        return Jdks.runAndCheckJVM(javaExecutablePath);
    }

    private static boolean isJdkRunnableOnPlatform(@NotNull String jdkHome) {
        return Jdks.runAndCheckJVM(FileUtil.join((String[])new String[]{jdkHome, "bin", "java"}));
    }

    private static boolean runAndCheckJVM(@NotNull String javaExecutablePath) {
        LOG.info("Checking java binary: " + javaExecutablePath);
        GeneralCommandLine commandLine = new GeneralCommandLine(new String[]{javaExecutablePath});
        commandLine.addParameter("-version");
        try {
            CapturingAnsiEscapesAwareProcessHandler process = new CapturingAnsiEscapesAwareProcessHandler(commandLine);
            int exitCode = process.runProcess().getExitCode();
            return exitCode == 0;
        }
        catch (ExecutionException e) {
            LOG.info("Could not invoke 'java -version'", (Throwable)e);
            return false;
        }
    }
}

