/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.sdk;

import com.android.repository.api.Downloader;
import com.android.repository.api.ProgressIndicator;
import com.android.repository.api.SettingsController;
import com.android.sdklib.devices.Storage;
import com.android.tools.idea.sdk.StudioSettingsController;
import com.android.tools.idea.sdk.progress.StudioProgressIndicatorAdapter;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.io.HttpRequests;
import com.intellij.util.io.RequestBuilder;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.Locale;
import org.jetbrains.annotations.NotNull;

public class StudioDownloader
implements Downloader {
    @NotNull
    private final SettingsController mySettingsController;

    public StudioDownloader() {
        this(StudioSettingsController.getInstance());
    }

    StudioDownloader(@NotNull SettingsController settingsController) {
        this.mySettingsController = settingsController;
    }

    public InputStream downloadAndStream(@NotNull URL url, @NotNull ProgressIndicator indicator) throws IOException {
        Path file = this.downloadFully(url, indicator);
        if (file == null) {
            return null;
        }
        return Files.newInputStream(file, StandardOpenOption.DELETE_ON_CLOSE);
    }

    public void downloadFully(@NotNull URL url, @NotNull File target, String checksum, @NotNull ProgressIndicator indicator) throws IOException {
        this.doDownloadFully(url, target, checksum, false, indicator);
    }

    public void downloadFullyWithCaching(@NotNull URL url, @NotNull File target, String checksum, @NotNull ProgressIndicator indicator) throws IOException {
        this.doDownloadFully(url, target, checksum, true, indicator);
    }

    private void doDownloadFully(@NotNull URL url, @NotNull File target, String checksum, boolean allowNetworkCaches, @NotNull ProgressIndicator indicator) throws IOException {
        if (target.exists() && checksum != null && checksum.equals(Downloader.hash((InputStream)new BufferedInputStream(new FileInputStream(target)), (long)target.length(), (ProgressIndicator)indicator))) {
            return;
        }
        String preparedUrl = this.prepareUrl(url);
        indicator.logInfo("Downloading " + preparedUrl);
        indicator.setText("Downloading...");
        indicator.setSecondaryText(preparedUrl);
        RequestBuilder rb = HttpRequests.request((String)preparedUrl).productNameAsUserAgent();
        if (this.mySettingsController.getForceHttp()) {
            rb.forceHttps(false);
        }
        rb.tuner(c -> c.setUseCaches(allowNetworkCaches));
        rb.connect(request -> {
            long contentLength = request.getConnection().getContentLength();
            return request.saveToFile(target, (com.intellij.openapi.progress.ProgressIndicator)new DownloadProgressIndicator(indicator, contentLength));
        });
    }

    public Path downloadFully(@NotNull URL url, @NotNull ProgressIndicator indicator) throws IOException {
        String suffix = url.getPath();
        suffix = suffix.substring(suffix.lastIndexOf(47) + 1);
        File tempFile = FileUtil.createTempFile((String)"StudioDownloader", (String)suffix, (boolean)true);
        tempFile.deleteOnExit();
        this.downloadFully(url, tempFile, null, indicator);
        return tempFile.toPath();
    }

    @NotNull
    String prepareUrl(@NotNull URL url) {
        String prepared = url.toExternalForm();
        if (this.mySettingsController.getForceHttp() && StringUtil.startsWith((CharSequence)prepared, (CharSequence)"https:")) {
            prepared = "http:" + prepared.substring(6);
        }
        return prepared;
    }

    private static class DownloadProgressIndicator
    extends StudioProgressIndicatorAdapter {
        private final long mContentLength;
        private final String mTotalDisplaySize;
        private int mCurrentPercentage;
        private Storage.Unit mReasonableUnit;

        public DownloadProgressIndicator(@NotNull ProgressIndicator wrapped, long contentLength) {
            super(wrapped);
            this.mContentLength = contentLength;
            Storage storage = new Storage(this.mContentLength);
            this.mReasonableUnit = storage.getLargestReasonableUnits();
            this.mTotalDisplaySize = storage.toUiString(1);
        }

        @Override
        public void setFraction(double fraction) {
            super.setFraction(fraction);
            this.checkCanceled();
            int percentage = (int)(fraction * 100.0);
            if (percentage == this.mCurrentPercentage) {
                return;
            }
            this.mCurrentPercentage = percentage;
            long downloadedSize = (long)(fraction * (double)this.mContentLength);
            double downloadedSizeInReasonableUnits = new Storage(downloadedSize).getPreciseSizeAsUnit(this.mReasonableUnit);
            this.setText(String.format(Locale.US, "Downloading (%1$d%%): %2$.1f / %3$s ...", this.mCurrentPercentage, downloadedSizeInReasonableUnits, this.mTotalDisplaySize));
        }
    }
}

