/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.sdk;

import com.android.repository.api.Channel;
import com.android.repository.api.SettingsController;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.RoamingType;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.updateSettings.impl.ChannelStatus;
import com.intellij.openapi.updateSettings.impl.UpdateSettings;
import java.net.Proxy;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="StudioSettingsController", storages={@Storage(value="remotesdk.xml", roamingType=RoamingType.DISABLED)})
public class StudioSettingsController
implements PersistentStateComponent<PersistentState>,
SettingsController {
    private PersistentState myState = new PersistentState();

    public boolean getForceHttp() {
        return this.myState.myForceHttp;
    }

    public void setForceHttp(boolean forceHttp) {
        this.myState.myForceHttp = forceHttp;
    }

    public boolean getDisableSdkPatches() {
        return this.myState.myDisableSdkPatches;
    }

    public void setDisableSdkPatches(boolean disableSdkPatches) {
        this.myState.myDisableSdkPatches = disableSdkPatches;
    }

    @Nullable
    public Channel getChannel() {
        Channel res = null;
        ChannelStatus channelStatus = UpdateSettings.getInstance().getSelectedChannelStatus();
        switch (channelStatus) {
            case RELEASE: {
                res = Channel.create((int)0);
                break;
            }
            case BETA: {
                res = Channel.create((int)1);
                break;
            }
            case MILESTONE: {
                res = Channel.create((int)2);
                break;
            }
            case EAP: {
                res = Channel.create((int)3);
                break;
            }
            default: {
                return null;
            }
        }
        res.setValue(channelStatus.getDisplayName());
        return res;
    }

    @Nullable
    public PersistentState getState() {
        return this.myState;
    }

    public void loadState(@NotNull PersistentState state) {
        this.myState = state;
    }

    public static SettingsController getInstance() {
        return (SettingsController)ServiceManager.getService(StudioSettingsController.class);
    }

    @NotNull
    public Proxy getProxy() {
        assert (false) : "StudioSettingsController does not contain proxy information.\nUse StudioDownloader or HttpsRequests to download within Studio";
        return Proxy.NO_PROXY;
    }

    private StudioSettingsController() {
    }

    public static class PersistentState {
        public boolean myForceHttp;
        public boolean myDisableSdkPatches;
    }
}

