/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.sdk.progress;

import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import org.jetbrains.annotations.NotNull;

public class StudioProgressIndicatorAdapter
implements ProgressIndicator {
    private static final double UPDATE_THRESHOLD = 0.01;
    private final com.android.repository.api.ProgressIndicator myWrapped;
    private final ProgressIndicator myExistingIndicator;

    public StudioProgressIndicatorAdapter(com.android.repository.api.ProgressIndicator wrapped) {
        this(wrapped, ProgressManager.getInstance().getProgressIndicator());
    }

    public StudioProgressIndicatorAdapter(com.android.repository.api.ProgressIndicator wrapped, ProgressIndicator existing2) {
        this.myWrapped = wrapped;
        this.myExistingIndicator = existing2;
    }

    public void start() {
        if (this.myExistingIndicator != null) {
            this.myExistingIndicator.start();
        }
    }

    public void stop() {
        if (this.myExistingIndicator != null) {
            this.myExistingIndicator.stop();
        }
    }

    public boolean isRunning() {
        if (this.myExistingIndicator != null) {
            return this.myExistingIndicator.isRunning();
        }
        return !this.myWrapped.isCanceled();
    }

    public void cancel() {
        if (this.myExistingIndicator != null) {
            this.myExistingIndicator.cancel();
        }
        this.myWrapped.cancel();
    }

    public boolean isCanceled() {
        if (this.myExistingIndicator != null) {
            if (this.myExistingIndicator.isCanceled()) {
                this.myWrapped.cancel();
            }
            return this.myExistingIndicator.isCanceled();
        }
        return this.myWrapped.isCanceled();
    }

    public void setText(String text) {
        if (this.myExistingIndicator != null) {
            this.myExistingIndicator.setText(text);
        }
        this.myWrapped.setText(text);
    }

    public String getText() {
        if (this.myExistingIndicator != null) {
            return this.myExistingIndicator.getText();
        }
        return "";
    }

    public void setText2(String text) {
        if (this.myExistingIndicator != null) {
            this.myExistingIndicator.setText2(text);
        }
        this.myWrapped.setSecondaryText(text);
    }

    public String getText2() {
        if (this.myExistingIndicator != null) {
            return this.myExistingIndicator.getText2();
        }
        return "";
    }

    public double getFraction() {
        if (this.myExistingIndicator != null) {
            return this.myExistingIndicator.getFraction();
        }
        return 0.0;
    }

    public void setFraction(double fraction) {
        if (Math.abs(this.myWrapped.getFraction() - fraction) < 0.01) {
            return;
        }
        if (this.myExistingIndicator != null) {
            this.myExistingIndicator.setFraction(fraction);
        }
        this.myWrapped.setFraction(fraction);
    }

    public void pushState() {
        if (this.myExistingIndicator != null) {
            this.myExistingIndicator.pushState();
        }
    }

    public void popState() {
        if (this.myExistingIndicator != null) {
            this.myExistingIndicator.popState();
        }
    }

    public void startNonCancelableSection() {
    }

    public void finishNonCancelableSection() {
    }

    public boolean isModal() {
        if (this.myExistingIndicator != null) {
            return this.myExistingIndicator.isModal();
        }
        return true;
    }

    @NotNull
    public ModalityState getModalityState() {
        if (this.myExistingIndicator != null) {
            return this.myExistingIndicator.getModalityState();
        }
        return ModalityState.defaultModalityState();
    }

    public void setModalityProgress(ProgressIndicator modalityProgress) {
        if (this.myExistingIndicator != null) {
            this.myExistingIndicator.setModalityProgress(modalityProgress);
        }
    }

    public boolean isIndeterminate() {
        if (this.myExistingIndicator != null) {
            return this.myExistingIndicator.isIndeterminate();
        }
        return this.myWrapped.isIndeterminate();
    }

    public void setIndeterminate(boolean indeterminate) {
        if (this.myExistingIndicator != null) {
            this.myExistingIndicator.setIndeterminate(indeterminate);
        }
        this.myWrapped.setIndeterminate(indeterminate);
    }

    public void checkCanceled() throws ProcessCanceledException {
        if (this.myExistingIndicator != null) {
            this.myExistingIndicator.checkCanceled();
        }
        if (this.myWrapped.isCanceled() && this.myWrapped.isCancellable()) {
            throw new ProcessCanceledException();
        }
    }

    public boolean isPopupWasShown() {
        if (this.myExistingIndicator != null) {
            return this.myExistingIndicator.isPopupWasShown();
        }
        return false;
    }

    public boolean isShowing() {
        if (this.myExistingIndicator != null) {
            return this.myExistingIndicator.isShowing();
        }
        return true;
    }
}

