/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.startup;

import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.Constraints;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.EmptyAction;
import org.jetbrains.annotations.NotNull;

public final class Actions {
    private Actions() {
    }

    public static void hideAction(@NotNull String actionId) {
        AnAction oldAction = ActionManager.getInstance().getAction(actionId);
        if (oldAction != null) {
            Actions.replaceAction(actionId, (AnAction)new EmptyAction());
        }
    }

    public static void replaceAction(@NotNull String actionId, @NotNull AnAction newAction) {
        ActionManager actionManager = ActionManager.getInstance();
        AnAction oldAction = actionManager.getAction(actionId);
        if (oldAction != null) {
            newAction.getTemplatePresentation().setIcon(oldAction.getTemplatePresentation().getIcon());
            actionManager.replaceAction(actionId, newAction);
        } else {
            actionManager.registerAction(actionId, newAction);
        }
    }

    public static void moveAction(@NotNull String actionId, @NotNull String oldGroupId, @NotNull String groupId, @NotNull Constraints constraints) {
        ActionManager actionManager = ActionManager.getInstance();
        AnAction action2 = actionManager.getActionOrStub(actionId);
        AnAction group = actionManager.getAction(groupId);
        AnAction oldGroup = actionManager.getAction(oldGroupId);
        if (action2 != null && oldGroup instanceof DefaultActionGroup && group instanceof DefaultActionGroup) {
            ((DefaultActionGroup)oldGroup).remove(action2);
            ((DefaultActionGroup)group).add(action2, constraints);
        }
    }
}

