/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.startup;

import com.android.annotations.concurrency.Slow;
import com.android.annotations.concurrency.UiThread;
import com.android.prefs.AndroidLocation;
import com.android.sdklib.IAndroidTarget;
import com.android.tools.idea.actions.AndroidActionGroupRemover;
import com.android.tools.idea.actions.AndroidImportModuleAction;
import com.android.tools.idea.actions.AndroidImportProjectAction;
import com.android.tools.idea.actions.AndroidNewModuleAction;
import com.android.tools.idea.actions.AndroidNewModuleInGroupAction;
import com.android.tools.idea.actions.AndroidNewProjectAction;
import com.android.tools.idea.actions.AndroidOpenFileAction;
import com.android.tools.idea.actions.CreateLibraryFromFilesAction;
import com.android.tools.idea.deploy.DeployActionsInitializer;
import com.android.tools.idea.gradle.actions.AndroidTemplateProjectSettingsGroup;
import com.android.tools.idea.gradle.actions.AndroidTemplateProjectStructureAction;
import com.android.tools.idea.io.FilePaths;
import com.android.tools.idea.npw.PathValidationResult;
import com.android.tools.idea.sdk.AndroidSdks;
import com.android.tools.idea.sdk.IdeSdks;
import com.android.tools.idea.sdk.VersionCheck;
import com.android.tools.idea.sdk.wizard.SdkQuickfixUtils;
import com.android.tools.idea.startup.Actions;
import com.android.tools.idea.startup.AndroidSdkInitializer;
import com.android.tools.idea.ui.GuiTestingService;
import com.android.tools.idea.welcome.config.FirstRunWizardMode;
import com.android.tools.idea.welcome.wizard.AndroidStudioWelcomeScreenProvider;
import com.android.utils.Pair;
import com.intellij.ide.AppLifecycleListener;
import com.intellij.ide.projectView.actions.MarkRootGroup;
import com.intellij.ide.projectView.impl.MoveModuleToGroupTopLevel;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationDisplayType;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationListener;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.Anchor;
import com.intellij.openapi.actionSystem.Constraints;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkModificator;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ui.UIUtil;
import java.io.File;
import java.util.ArrayDeque;
import java.util.List;
import javax.swing.event.HyperlinkEvent;
import org.jetbrains.android.sdk.AndroidPlatform;
import org.jetbrains.android.sdk.AndroidSdkAdditionalData;
import org.jetbrains.android.sdk.AndroidSdkUtils;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GradleSpecificInitializer
implements Runnable {
    private static final Logger LOG = Logger.getInstance(GradleSpecificInitializer.class);
    @NotNull
    public static final String TEMPLATE_PROJECT_SETTINGS_GROUP_ID = "TemplateProjectSettingsGroup";

    @Override
    public void run() {
        GradleSpecificInitializer.setUpNewProjectActions();
        DeployActionsInitializer.installActions();
        GradleSpecificInitializer.setUpWelcomeScreenActions();
        GradleSpecificInitializer.replaceProjectPopupActions();
        Actions.replaceAction(TEMPLATE_PROJECT_SETTINGS_GROUP_ID, (AnAction)new AndroidTemplateProjectSettingsGroup());
        GradleSpecificInitializer.setUpGradleViewToolbarActions();
        GradleSpecificInitializer.checkInstallPath();
        ActionManager actionManager = ActionManager.getInstance();
        AnAction pluginAction = actionManager.getAction("StartupWizard");
        pluginAction.getTemplatePresentation().setVisible(false);
        if (AndroidSdkUtils.isAndroidSdkManagerEnabled()) {
            ApplicationManager.getApplication().executeOnPooledThread(GradleSpecificInitializer::setupSdk);
        }
    }

    @Slow
    private static void setupSdk() {
        try {
            if (GradleSpecificInitializer.setupSdkSilently()) {
                GradleSpecificInitializer.finishSdkSetup();
            }
        }
        catch (Exception e) {
            LOG.error("Unexpected error while setting up SDKs: ", (Throwable)e);
            return;
        }
        UIUtil.invokeLaterIfNeeded(GradleSpecificInitializer::setUpSdkInteractively);
    }

    @UiThread
    private static void setUpSdkInteractively() {
        File androidSdkPath = GradleSpecificInitializer.getAndroidSdkPath();
        if (androidSdkPath == null) {
            return;
        }
        FirstRunWizardMode wizardMode = AndroidStudioWelcomeScreenProvider.getWizardMode();
        boolean promptSdkSelection = wizardMode == null;
        Sdk sdk = AndroidSdkUtils.createNewAndroidPlatform(androidSdkPath.getPath(), promptSdkSelection);
        if (sdk != null) {
            String sdkNamePrefix = "Android ";
            if (sdk.getName().startsWith(sdkNamePrefix)) {
                Sdk jdk;
                SdkModificator sdkModificator = sdk.getSdkModificator();
                sdkModificator.setName(sdkNamePrefix + sdk.getName().substring(sdkNamePrefix.length()));
                sdkModificator.commitChanges();
                AndroidSdkAdditionalData additionalData = AndroidSdks.getInstance().getAndroidSdkAdditionalData(sdk);
                if (additionalData != null && (jdk = additionalData.getJavaSdk()) != null) {
                    sdkModificator = jdk.getSdkModificator();
                    sdkModificator.setName("JDK");
                    sdkModificator.commitChanges();
                }
                IdeSdks.getInstance().createAndroidSdkPerAndroidTarget(androidSdkPath);
            }
        }
        ApplicationManager.getApplication().executeOnPooledThread(() -> {
            try {
                GradleSpecificInitializer.finishSdkSetup();
            }
            catch (Exception e) {
                LOG.error("Unexpected error while setting up SDKs: ", (Throwable)e);
            }
        });
    }

    private static void finishSdkSetup() {
        GradleSpecificInitializer.checkAndroidSdkHome();
        GradleSpecificInitializer.checkAndSetAndroidSdkSources();
    }

    private static void checkInstallPath() {
        if (PathManager.getHomePath().contains("!")) {
            final Application app = ApplicationManager.getApplication();
            app.getMessageBus().connect((Disposable)app).subscribe(AppLifecycleListener.TOPIC, (Object)new AppLifecycleListener(){

                public void appStarting(Project project) {
                    app.invokeLater(() -> {
                        String message2 = String.format("%1$s must not be installed in a path containing '!' or Gradle sync will fail!", ApplicationNamesInfo.getInstance().getProductName());
                        Notification notification = GradleSpecificInitializer.getNotificationGroup().createNotification(message2, NotificationType.ERROR);
                        notification.setImportant(true);
                        Notifications.Bus.notify((Notification)notification);
                    });
                }
            });
        }
    }

    private static void setUpGradleViewToolbarActions() {
        Actions.hideAction("ExternalSystem.RefreshAllProjects");
        Actions.hideAction("ExternalSystem.SelectProjectDataToImport");
    }

    private static void setUpNewProjectActions() {
        Actions.replaceAction("OpenFile", (AnAction)new AndroidOpenFileAction());
        Actions.replaceAction("NewProject", new AndroidNewProjectAction());
        Actions.replaceAction("NewModule", new AndroidNewModuleAction());
        Actions.replaceAction("NewModuleInGroup", new AndroidNewModuleInGroupAction());
        Actions.replaceAction("ImportProject", new AndroidImportProjectAction());
        Actions.replaceAction("CreateLibraryFromFile", new CreateLibraryFromFilesAction());
        Actions.replaceAction("ImportModule", new AndroidImportModuleAction());
        Actions.hideAction("GenerateAntBuild");
        Actions.hideAction("AddFrameworkSupport");
        Actions.hideAction("BuildArtifact");
        Actions.hideAction("RunTargetAction");
    }

    private static void setUpWelcomeScreenActions() {
        System.setProperty("ide.new.welcome.screen.force", "true");
        Actions.replaceAction("WelcomeScreen.OpenProject", (AnAction)new AndroidOpenFileAction("Open an existing Android Studio project"));
        Actions.replaceAction("WelcomeScreen.CreateNewProject", new AndroidNewProjectAction("Start a new Android Studio project"));
        Actions.replaceAction("WelcomeScreen.ImportProject", new AndroidImportProjectAction("Import project (Gradle, Eclipse ADT, etc.)"));
        Actions.replaceAction("WelcomeScreen.Configure.ProjectStructure", (AnAction)new AndroidTemplateProjectStructureAction("Default Project Structure..."));
        Actions.replaceAction("TemplateProjectStructure", (AnAction)new AndroidTemplateProjectStructureAction("Default Project Structure..."));
        Actions.moveAction("WelcomeScreen.ImportProject", "WelcomeScreen.QuickStart.IDEA", "WelcomeScreen.QuickStart", new Constraints(Anchor.AFTER, "WelcomeScreen.GetFromVcs"));
        ActionManager actionManager = ActionManager.getInstance();
        AnAction getFromVcsAction = actionManager.getAction("WelcomeScreen.GetFromVcs");
        if (getFromVcsAction != null) {
            getFromVcsAction.getTemplatePresentation().setText("Check out project from Version Control");
        }
    }

    private static void replaceProjectPopupActions() {
        ArrayDeque<Pair> stack = new ArrayDeque<Pair>();
        stack.add(Pair.of(null, (Object)ActionManager.getInstance().getAction("ProjectViewPopupMenu")));
        while (!stack.isEmpty()) {
            Pair entry = (Pair)stack.pop();
            DefaultActionGroup parent = (DefaultActionGroup)entry.getFirst();
            AnAction action2 = (AnAction)entry.getSecond();
            if (action2 instanceof DefaultActionGroup) {
                DefaultActionGroup actionGroup = (DefaultActionGroup)action2;
                for (AnAction child : actionGroup.getChildActionsOrStubs()) {
                    stack.push(Pair.of((Object)actionGroup, (Object)child));
                }
            }
            if (action2 instanceof MoveModuleToGroupTopLevel) {
                parent.remove(action2);
                parent.add((AnAction)new AndroidActionGroupRemover((ActionGroup)action2, "Move Module to Group"), new Constraints(Anchor.AFTER, "OpenModuleSettings"));
                continue;
            }
            if (!(action2 instanceof MarkRootGroup)) continue;
            parent.remove(action2);
            parent.add((AnAction)new AndroidActionGroupRemover((ActionGroup)action2, "Mark Directory As"), new Constraints(Anchor.AFTER, "OpenModuleSettings"));
        }
    }

    private static void notifyInvalidSdk() {
        String key = "android.invalid.sdk.message";
        String message2 = AndroidBundle.message(key, new Object[0]);
        NotificationListener.Adapter listener2 = new NotificationListener.Adapter(){

            protected void hyperlinkActivated(@NotNull Notification notification, @NotNull HyperlinkEvent e) {
                SdkQuickfixUtils.showAndroidSdkManager();
                notification.expire();
            }
        };
        GradleSpecificInitializer.addStartupWarning(message2, (NotificationListener)listener2);
    }

    private static void addStartupWarning(final @NotNull String message2, final @Nullable NotificationListener listener2) {
        final Application app = ApplicationManager.getApplication();
        app.getMessageBus().connect((Disposable)app).subscribe(AppLifecycleListener.TOPIC, (Object)new AppLifecycleListener(){

            public void appStarting(Project project) {
                app.invokeLater(() -> {
                    Notification notification = GradleSpecificInitializer.getNotificationGroup().createNotification("SDK Validation", message2, NotificationType.WARNING, listener2);
                    notification.setImportant(true);
                    Notifications.Bus.notify((Notification)notification);
                });
            }
        });
    }

    private static NotificationGroup getNotificationGroup() {
        NotificationGroup group = NotificationGroup.findRegisteredGroup((String)"System Health");
        if (group == null) {
            group = new NotificationGroup("Gradle Initializer", NotificationDisplayType.STICKY_BALLOON, true);
        }
        return group;
    }

    @Slow
    private static boolean setupSdkSilently() {
        IdeSdks ideSdks = IdeSdks.getInstance();
        File androidHome = ideSdks.getAndroidSdkPath();
        if (androidHome != null) {
            String androidHomePath = androidHome.getAbsolutePath();
            PathValidationResult result2 = PathValidationResult.validateLocation(androidHomePath, "Android SDK location", false, PathValidationResult.WritableCheckMode.DO_NOT_CHECK);
            if (result2.isError()) {
                GradleSpecificInitializer.notifyInvalidSdk();
            }
            return true;
        }
        if (GuiTestingService.getInstance().isGuiTestingMode() || ApplicationManager.getApplication().isUnitTestMode() || ApplicationManager.getApplication().isHeadlessEnvironment()) {
            return true;
        }
        Sdk sdk = GradleSpecificInitializer.findFirstCompatibleAndroidSdk();
        if (sdk != null) {
            String sdkHomePath = sdk.getHomePath();
            assert (sdkHomePath != null);
            ideSdks.createAndroidSdkPerAndroidTarget(FilePaths.toSystemDependentPath((String)sdkHomePath));
            return true;
        }
        return false;
    }

    private static void checkAndroidSdkHome() {
        try {
            AndroidLocation.checkAndroidSdkHome();
        }
        catch (AndroidLocation.AndroidLocationException e) {
            GradleSpecificInitializer.addStartupWarning(e.getMessage(), null);
        }
    }

    @Nullable
    private static Sdk findFirstCompatibleAndroidSdk() {
        List<Sdk> sdks = AndroidSdks.getInstance().getAllAndroidSdks();
        for (Sdk sdk : sdks) {
            String sdkPath = sdk.getHomePath();
            if (!VersionCheck.isCompatibleVersion(sdkPath)) continue;
            return sdk;
        }
        if (!sdks.isEmpty()) {
            return sdks.get(0);
        }
        return null;
    }

    @Nullable
    private static File getAndroidSdkPath() {
        return AndroidSdkInitializer.findOrGetAndroidSdkPath();
    }

    private static void checkAndSetAndroidSdkSources() {
        for (Sdk sdk : AndroidSdks.getInstance().getAllAndroidSdks()) {
            GradleSpecificInitializer.checkAndSetSources(sdk);
        }
    }

    private static void checkAndSetSources(@NotNull Sdk sdk) {
        VirtualFile[] storedSources = sdk.getRootProvider().getFiles(OrderRootType.SOURCES);
        if (storedSources.length > 0) {
            return;
        }
        AndroidPlatform platform = AndroidPlatform.getInstance(sdk);
        if (platform != null) {
            SdkModificator sdkModificator = sdk.getSdkModificator();
            IAndroidTarget target = platform.getTarget();
            AndroidSdks.getInstance().findAndSetPlatformSources(target, sdkModificator);
            sdkModificator.commitChanges();
        }
    }
}

