/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.stats;

import com.android.ide.common.gradle.model.IdeBaseArtifact;
import com.android.tools.analytics.TestSupportLibraries;
import com.android.tools.analytics.UsageTracker;
import com.android.tools.idea.gradle.model.java.JarLibraryDependency;
import com.android.tools.idea.gradle.project.model.AndroidModuleModel;
import com.android.tools.idea.gradle.project.model.JavaModuleModel;
import com.android.tools.idea.stats.AndroidStudioUsageTracker;
import com.android.tools.idea.stats.TestRunUtil;
import com.android.tools.idea.testartifacts.junit.AndroidJUnitConfiguration;
import com.android.tools.idea.util.ModuleExtensionsKt;
import com.google.wireless.android.sdk.stats.AndroidStudioEvent;
import com.google.wireless.android.sdk.stats.TestLibraries;
import com.google.wireless.android.sdk.stats.TestRun;
import com.intellij.execution.ExecutionListener;
import com.intellij.execution.ExecutionManager;
import com.intellij.execution.configurations.JavaRunConfigurationModule;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.testframework.sm.runner.SMTRunnerEventsAdapter;
import com.intellij.execution.testframework.sm.runner.SMTRunnerEventsListener;
import com.intellij.execution.testframework.sm.runner.SMTestProxy;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ProjectComponent;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Key;
import com.intellij.util.messages.MessageBusConnection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.gradle.tooling.model.GradleModuleVersion;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\u0018\u0000 \u001d2\u00020\u00012\u00020\u00022\u00020\u0003:\u0001\u001dB\r\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0010\u0010\u000f\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J \u0010\u0012\u001a\u00020\n2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J(\u0010\u0019\u001a\u00020\n2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\b\u0010\u001c\u001a\u00020\nH\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u001e"}, d2={"Lcom/android/tools/idea/stats/AnalyticsTestRunnerEventsListener;", "Lcom/intellij/execution/testframework/sm/runner/SMTRunnerEventsAdapter;", "Lcom/intellij/execution/ExecutionListener;", "Lcom/intellij/openapi/components/ProjectComponent;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "findTestLibraries", "", "module", "Lcom/intellij/openapi/module/Module;", "testLibraries", "Lcom/google/wireless/android/sdk/stats/TestLibraries$Builder;", "onTestingFinished", "testsRoot", "Lcom/intellij/execution/testframework/sm/runner/SMTestProxy$SMRootTestProxy;", "processStarted", "executorId", "", "env", "Lcom/intellij/execution/runners/ExecutionEnvironment;", "handler", "Lcom/intellij/execution/process/ProcessHandler;", "processTerminated", "exitCode", "", "projectOpened", "Companion", "intellij.android.core"})
public final class AnalyticsTestRunnerEventsListener
extends SMTRunnerEventsAdapter
implements ExecutionListener,
ProjectComponent {
    @NotNull
    private final Project project;
    private static final Key<TestRun.Builder> TEST_RUN_KEY;
    public static final Companion Companion;

    public void projectOpened() {
        MessageBusConnection connection = this.project.getMessageBus().connect();
        connection.subscribe(SMTRunnerEventsListener.TEST_STATUS, (Object)this);
        connection.subscribe(ExecutionManager.EXECUTION_TOPIC, (Object)this);
    }

    public void processStarted(@NotNull String executorId, @NotNull ExecutionEnvironment env, @NotNull ProcessHandler handler) {
        TestRun.Builder builder;
        RunProfile runProfile = env.getRunProfile();
        if (!(runProfile instanceof AndroidJUnitConfiguration)) {
            runProfile = null;
        }
        AndroidJUnitConfiguration androidJUnitConfiguration = (AndroidJUnitConfiguration)runProfile;
        if (androidJUnitConfiguration == null) {
            return;
        }
        AndroidJUnitConfiguration runConfiguration = androidJUnitConfiguration;
        TestRun.Builder $receiver = builder = TestRun.newBuilder();
        boolean bl = false;
        $receiver.setTestInvocationType(TestRun.TestInvocationType.ANDROID_STUDIO_TEST);
        $receiver.setTestKind(TestRun.TestKind.UNIT_TEST);
        TestRun.Builder testRunProtoBuilder = builder;
        TestLibraries.Builder testLibraries = TestLibraries.newBuilder();
        boolean $i$f$runReadAction = false;
        ApplicationManager.getApplication().runReadAction(new Computable<T>(this, runConfiguration, testLibraries){
            final /* synthetic */ AnalyticsTestRunnerEventsListener this$0;
            final /* synthetic */ AndroidJUnitConfiguration $runConfiguration$inlined;
            final /* synthetic */ TestLibraries.Builder $testLibraries$inlined;
            {
                this.this$0 = analyticsTestRunnerEventsListener;
                this.$runConfiguration$inlined = androidJUnitConfiguration;
                this.$testLibraries$inlined = builder;
            }

            public final T compute() {
                boolean bl = false;
                Module configurationModule = ((JavaRunConfigurationModule)this.$runConfiguration$inlined.getConfigurationModule()).getModule();
                if (configurationModule != null) {
                    AnalyticsTestRunnerEventsListener.access$findTestLibraries(this.this$0, configurationModule, this.$testLibraries$inlined);
                } else {
                    for (Module module : this.$runConfiguration$inlined.getAllModules()) {
                        AnalyticsTestRunnerEventsListener.access$findTestLibraries(this.this$0, module, this.$testLibraries$inlined);
                    }
                }
                return (T)Unit.INSTANCE;
            }
        });
        testRunProtoBuilder.setTestLibraries(testLibraries.build());
        handler.putUserData(TEST_RUN_KEY, (Object)testRunProtoBuilder);
    }

    /*
     * WARNING - void declaration
     */
    private final void findTestLibraries(Module module, TestLibraries.Builder testLibraries) {
        AndroidFacet androidFacet = ModuleExtensionsKt.getAndroidFacet(module);
        if (androidFacet != null) {
            AndroidModuleModel androidModuleModel = AndroidModuleModel.get(androidFacet);
            if (androidModuleModel == null || (androidModuleModel = androidModuleModel.getSelectedVariant()) == null || (androidModuleModel = androidModuleModel.getUnitTestArtifact()) == null) {
                return;
            }
            TestRunUtil.recordTestLibraries(testLibraries, (IdeBaseArtifact)androidModuleModel);
        } else {
            List dependencies;
            List list;
            Object object = JavaModuleModel.get(module);
            if (object != null && (object = ((JavaModuleModel)object).getJarLibraryDependencies()) != null) {
                void $receiver$iv$iv;
                Iterable $receiver$iv = (Iterable)object;
                Iterable iterable = $receiver$iv;
                Collection destination$iv$iv = new ArrayList();
                void $receiver$iv$iv$iv = $receiver$iv$iv;
                Iterator iterator = $receiver$iv$iv$iv.iterator();
                while (iterator.hasNext()) {
                    GradleModuleVersion gradleModuleVersion;
                    Object element$iv$iv$iv;
                    Object element$iv$iv = element$iv$iv$iv = iterator.next();
                    JarLibraryDependency it = (JarLibraryDependency)element$iv$iv;
                    boolean bl = false;
                    if (it.getModuleVersion() == null) continue;
                    GradleModuleVersion it$iv$iv = gradleModuleVersion;
                    destination$iv$iv.add(it$iv$iv);
                }
                list = (List)destination$iv$iv;
            } else {
                list = dependencies = null;
            }
            if (dependencies != null) {
                for (GradleModuleVersion dependency : dependencies) {
                    String version2;
                    String artifact;
                    String group;
                    if (dependency.getGroup() == null) {
                        continue;
                    }
                    if (dependency.getName() == null) {
                        continue;
                    }
                    if (dependency.getVersion() == null) {
                        continue;
                    }
                    TestSupportLibraries.recordTestLibrary((TestLibraries.Builder)testLibraries, (String)group, (String)artifact, (String)version2);
                }
            }
        }
    }

    public void processTerminated(@NotNull String executorId, @NotNull ExecutionEnvironment env, @NotNull ProcessHandler handler, int exitCode) {
        boolean bl;
        TestRun.Builder builder = (TestRun.Builder)handler.getUserData(TEST_RUN_KEY);
        if (builder == null) {
            return;
        }
        TestRun.Builder testRunBuilder = builder;
        switch (exitCode) {
            case -1: 
            case 0: 
            case 255: {
                bl = false;
                break;
            }
            default: {
                bl = true;
            }
        }
        testRunBuilder.setCrashed(bl);
    }

    /*
     * WARNING - void declaration
     */
    public void onTestingFinished(@NotNull SMTestProxy.SMRootTestProxy testsRoot) {
        AndroidStudioEvent.Builder builder;
        int n;
        void $receiver$iv;
        if (testsRoot.getHandler() == null) {
            return;
        }
        TestRun.Builder builder2 = (TestRun.Builder)testsRoot.getHandler().getUserData(TEST_RUN_KEY);
        if (builder2 == null) {
            return;
        }
        TestRun.Builder testRunBuilder = builder2;
        Iterable iterable = testsRoot.getAllTests();
        TestRun.Builder builder3 = testRunBuilder;
        if ($receiver$iv instanceof Collection && ((Collection)$receiver$iv).isEmpty()) {
            n = 0;
        } else {
            int count$iv = 0;
            for (Object element$iv : $receiver$iv) {
                int n2;
                SMTestProxy it = (SMTestProxy)element$iv;
                boolean bl = false;
                if (!it.isLeaf() || (n2 = ++count$iv) >= 0) continue;
                CollectionsKt.throwCountOverflow();
            }
            n = count$iv;
        }
        int n3 = n;
        builder3.setNumberOfTestsExecuted(n3);
        AndroidStudioEvent.Builder $receiver = builder = AndroidStudioEvent.newBuilder();
        boolean bl = false;
        $receiver.setCategory(AndroidStudioEvent.EventCategory.TESTS);
        $receiver.setKind(AndroidStudioEvent.EventKind.TEST_RUN);
        $receiver.setProductDetails(AndroidStudioUsageTracker.getProductDetails());
        $receiver.setTestRun(testRunBuilder.build());
        AndroidStudioEvent.Builder studioEvent = builder;
        UsageTracker.log((AndroidStudioEvent.Builder)studioEvent);
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    public AnalyticsTestRunnerEventsListener(@NotNull Project project) {
        this.project = project;
    }

    static {
        Companion = new Companion(null);
        String string = Reflection.getOrCreateKotlinClass(AnalyticsTestRunnerEventsListener.class).getQualifiedName();
        if (string == null) {
            Intrinsics.throwNpe();
        }
        TEST_RUN_KEY = Key.create((String)string);
    }

    public static final /* synthetic */ void access$findTestLibraries(AnalyticsTestRunnerEventsListener $this, Module module, TestLibraries.Builder testLibraries) {
        $this.findTestLibraries(module, testLibraries);
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u001c\u0010\u0003\u001a\u0010\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/android/tools/idea/stats/AnalyticsTestRunnerEventsListener$Companion;", "", "()V", "TEST_RUN_KEY", "Lcom/intellij/openapi/util/Key;", "Lcom/google/wireless/android/sdk/stats/TestRun$Builder;", "kotlin.jvm.PlatformType", "intellij.android.core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

