/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.stats;

import com.android.tools.analytics.UsageTracker;
import com.android.tools.idea.stats.TypingLatencyTracker;
import com.google.wireless.android.sdk.stats.AndroidStudioEvent;
import com.google.wireless.android.sdk.stats.EditorFileType;
import com.google.wireless.android.sdk.stats.TypingLatencyStats;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.actionSystem.LatencyListener;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.analytics.HistogramUtil;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.HdrHistogram.Histogram;
import org.HdrHistogram.SingleWriterRecorder;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0007\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\tH\u0002J \u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0006\u0010\u0012\u001a\u00020\u000bR\u001a\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/android/tools/idea/stats/TypingLatencyTracker;", "Lcom/intellij/openapi/editor/actionSystem/LatencyListener;", "()V", "latencyRecorders", "Ljava/util/concurrent/ConcurrentHashMap;", "Lcom/google/wireless/android/sdk/stats/EditorFileType;", "Lorg/HdrHistogram/SingleWriterRecorder;", "convertFileType", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "recordTypingLatency", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "action", "", "latencyMs", "", "reportTypingLatency", "intellij.android.core"})
public final class TypingLatencyTracker
implements LatencyListener {
    private static final ConcurrentHashMap<EditorFileType, SingleWriterRecorder> latencyRecorders;
    public static final TypingLatencyTracker INSTANCE;

    public void recordTypingLatency(@NotNull Editor editor2, @NotNull String action2, long latencyMs) {
        if (latencyMs < 0L) {
            return;
        }
        VirtualFile virtualFile = FileDocumentManager.getInstance().getFile(editor2.getDocument());
        if (virtualFile == null) {
            return;
        }
        VirtualFile file = virtualFile;
        EditorFileType fileType = this.convertFileType(file);
        SingleWriterRecorder recorder2 = latencyRecorders.computeIfAbsent(fileType, recordTypingLatency.recorder.1.INSTANCE);
        recorder2.recordValue(latencyMs);
    }

    public final void reportTypingLatency() {
        AndroidStudioEvent.Builder builder;
        TypingLatencyStats.Builder allStats = TypingLatencyStats.newBuilder();
        Map map2 = latencyRecorders;
        Iterator iterator = map2.entrySet().iterator();
        while (iterator.hasNext()) {
            TypingLatencyStats.LatencyRecord.Builder builder2;
            AndroidStudioEvent.Builder builder3 = builder = iterator.next();
            EditorFileType fileType = (EditorFileType)builder3.getKey();
            builder3 = builder;
            SingleWriterRecorder recorder2 = (SingleWriterRecorder)builder3.getValue();
            Histogram histogram = recorder2.getIntervalHistogram();
            if (histogram.getTotalCount() == 0L) continue;
            TypingLatencyStats.LatencyRecord.Builder it = builder2 = TypingLatencyStats.LatencyRecord.newBuilder();
            boolean bl = false;
            it.setFileType(fileType);
            it.setTotalKeysTyped(histogram.getTotalCount());
            it.setTotalLatencyMs((long)((double)histogram.getTotalCount() * histogram.getMean()));
            it.setMaxLatencyMs(histogram.getMaxValue());
            it.setHistogram(HistogramUtil.toProto((Histogram)histogram));
            TypingLatencyStats.LatencyRecord.Builder record = builder2;
            allStats.addLatencyRecords(record.build());
        }
        if (allStats.getLatencyRecordsCount() == 0) {
            return;
        }
        AndroidStudioEvent.Builder $receiver = builder = AndroidStudioEvent.newBuilder();
        boolean bl = false;
        $receiver.setKind(AndroidStudioEvent.EventKind.TYPING_LATENCY_STATS);
        $receiver.setTypingLatencyStats(allStats.build());
        UsageTracker.log((AndroidStudioEvent.Builder)builder);
    }

    private final EditorFileType convertFileType(VirtualFile file) {
        EditorFileType editorFileType;
        switch (file.getFileType().getName()) {
            case "JAVA": {
                editorFileType = EditorFileType.JAVA;
                break;
            }
            case "Kotlin": {
                if (Intrinsics.areEqual((Object)file.getExtension(), (Object)"kts")) {
                    editorFileType = EditorFileType.KOTLIN_SCRIPT;
                    break;
                }
                editorFileType = EditorFileType.KOTLIN;
                break;
            }
            case "XML": {
                editorFileType = EditorFileType.XML;
                break;
            }
            case "Groovy": {
                editorFileType = EditorFileType.GROOVY;
                break;
            }
            case "Properties": {
                editorFileType = EditorFileType.PROPERTIES;
                break;
            }
            case "JSON": {
                editorFileType = EditorFileType.JSON;
                break;
            }
            case "ObjectiveC": {
                editorFileType = EditorFileType.NATIVE;
                break;
            }
            default: {
                editorFileType = EditorFileType.UNKNOWN;
            }
        }
        return editorFileType;
    }

    private TypingLatencyTracker() {
    }

    static {
        TypingLatencyTracker typingLatencyTracker;
        INSTANCE = typingLatencyTracker = new TypingLatencyTracker();
        latencyRecorders = new ConcurrentHashMap();
    }
}

