/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.structure.services;

import com.google.common.collect.Lists;
import java.io.File;
import java.net.URI;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DeveloperServiceMetadata {
    @NotNull
    private final String myId;
    @NotNull
    private final String myName;
    @NotNull
    private final String myDescription;
    @NotNull
    private final Icon myIcon;
    @NotNull
    private final List<String> myDependencies = Lists.newArrayList();
    @NotNull
    private final List<String> myClasspathEntries = Lists.newArrayList();
    @NotNull
    private final List<String> myPlugins = Lists.newArrayList();
    @NotNull
    private final List<String> myPermissions = Lists.newArrayList();
    @NotNull
    private final List<String> myModifiedFiles = Lists.newArrayList();
    @Nullable
    private URI myLearnMoreLink;
    @Nullable
    private URI myApiLink;

    public DeveloperServiceMetadata(@NotNull String id, @NotNull String name, @NotNull String description, @NotNull Icon icon2) {
        this.myId = id;
        this.myName = name;
        this.myDescription = description;
        this.myIcon = icon2;
    }

    public void addDependency(@NotNull String dependency) {
        this.myDependencies.add(dependency);
    }

    public void addClasspathEntry(@NotNull String classpathEntry) {
        this.myClasspathEntries.add(classpathEntry);
    }

    public void addPlugin(@NotNull String plugin) {
        this.myPlugins.add(plugin);
    }

    public void addPermission(@NotNull String permission) {
        this.myPermissions.add(permission);
    }

    public void addModifiedFile(@NotNull File file) {
        this.myModifiedFiles.add(file.getName());
    }

    @NotNull
    public String getId() {
        return this.myId;
    }

    @NotNull
    public String getName() {
        return this.myName;
    }

    @NotNull
    public String getDescription() {
        return this.myDescription;
    }

    @NotNull
    public Icon getIcon() {
        return this.myIcon;
    }

    @Nullable
    public URI getLearnMoreLink() {
        return this.myLearnMoreLink;
    }

    public void setLearnMoreLink(@NotNull URI learnMoreLink) {
        this.myLearnMoreLink = learnMoreLink;
    }

    @Nullable
    public URI getApiLink() {
        return this.myApiLink;
    }

    public void setApiLink(@NotNull URI apiLink) {
        this.myApiLink = apiLink;
    }

    @NotNull
    public List<String> getDependencies() {
        return this.myDependencies;
    }

    @NotNull
    public List<String> getClasspathEntries() {
        return this.myClasspathEntries;
    }

    @NotNull
    public List<String> getPlugins() {
        return this.myPlugins;
    }

    @NotNull
    public List<String> getModifiedFiles() {
        return this.myModifiedFiles;
    }

    @NotNull
    public List<String> getPermissions() {
        return this.myPermissions;
    }
}

