/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.structure.services;

import com.android.tools.idea.observable.AbstractProperty;
import com.android.tools.idea.observable.InvalidationListener;
import com.android.tools.idea.observable.ObservableValue;
import com.android.tools.idea.observable.core.BoolValueProperty;
import com.android.tools.idea.observable.core.ObservableBool;
import com.google.common.base.Splitter;
import com.google.common.collect.Maps;
import com.intellij.openapi.util.EmptyRunnable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.Callable;
import org.jetbrains.annotations.NotNull;

public final class ServiceContext {
    private final Map<String, ObservableValue> myValues = Maps.newHashMap();
    private final Map<String, Runnable> myActions = Maps.newHashMap();
    private final Map<AbstractProperty, Object> myWatched = new WeakHashMap<AbstractProperty, Object>();
    private final BoolValueProperty myInstalled = new BoolValueProperty();
    private final BoolValueProperty myModified = new BoolValueProperty();
    private final BoolValueProperty myHiddenFromStructureDialog = new BoolValueProperty();
    private final InvalidationListener myWatchedListener = () -> this.myModified.set(true);
    @NotNull
    private final String myBuildSystemId;
    private Runnable myBeforeShown = EmptyRunnable.INSTANCE;
    private Callable<Boolean> myTestValidity = new Callable<Boolean>(){

        @Override
        public Boolean call() throws Exception {
            return true;
        }
    };

    public ServiceContext(@NotNull String buildSystemId) {
        this.myBuildSystemId = buildSystemId;
    }

    @NotNull
    String getBuildSystemId() {
        return this.myBuildSystemId;
    }

    public void setBeforeShownCallback(@NotNull Runnable beforeShown) {
        this.myBeforeShown = beforeShown;
    }

    public void setIsValidCallback(@NotNull Callable<Boolean> testValidity) {
        this.myTestValidity = testValidity;
    }

    public void beginEditing() {
        this.myBeforeShown.run();
        if (this.myWatched.isEmpty()) {
            this.myModified.set(this.isValid());
        }
    }

    public void finishEditing() {
        if (!this.myModified.get().booleanValue()) {
            return;
        }
        this.myModified.set(this.isValid());
    }

    public void cancelEditing() {
        this.myModified.set(false);
    }

    public BoolValueProperty installed() {
        return this.myInstalled;
    }

    public ObservableBool modified() {
        return this.myModified;
    }

    public BoolValueProperty hiddenFromStructureDialog() {
        return this.myHiddenFromStructureDialog;
    }

    public void snapshot() {
        for (AbstractProperty property2 : this.myWatched.keySet()) {
            this.myWatched.put(property2, property2.get());
        }
        this.myModified.set(false);
    }

    public void restore() {
        for (AbstractProperty property2 : this.myWatched.keySet()) {
            property2.set(this.myWatched.get(property2));
        }
        this.myModified.set(false);
    }

    public void putValue(@NotNull String key, @NotNull ObservableValue value2) {
        this.myValues.put(key, value2);
    }

    public void putWatchedValue(@NotNull String key, @NotNull AbstractProperty property2) {
        this.putValue(key, property2);
        property2.addWeakListener(this.myWatchedListener);
        this.myWatched.put(property2, property2.get());
    }

    public void putAction(@NotNull String key, @NotNull Runnable action2) {
        this.myActions.put(key, action2);
    }

    @NotNull
    public ObservableValue getValue(@NotNull String key) {
        ObservableValue value2 = this.myValues.get(key);
        if (value2 == null) {
            throw new IllegalArgumentException(String.format("Service context: Value \"%1$s\" not found.", key));
        }
        return value2;
    }

    @NotNull
    public Runnable getAction(@NotNull String key) {
        Runnable action2 = this.myActions.get(key);
        if (action2 == null) {
            throw new IllegalArgumentException(String.format("Service context: Action \"%1$s\" not found.", key));
        }
        return action2;
    }

    @NotNull
    public Map<String, Object> toValueMap() {
        HashMap valueMap = Maps.newHashMap();
        Splitter splitter = Splitter.on((char)'.');
        for (String key : this.myValues.keySet()) {
            ObservableValue value2 = this.getValue(key);
            Map currLevel = valueMap;
            Iterator keyParts = splitter.split((CharSequence)key).iterator();
            while (keyParts.hasNext()) {
                String keyPart = (String)keyParts.next();
                if (keyParts.hasNext()) {
                    if (currLevel.containsKey(keyPart)) {
                        currLevel = (Map)currLevel.get(keyPart);
                        continue;
                    }
                    HashMap nextLevel = Maps.newHashMap();
                    currLevel.put(keyPart, nextLevel);
                    currLevel = nextLevel;
                    continue;
                }
                currLevel.put(keyPart, value2);
            }
        }
        return valueMap;
    }

    private boolean isValid() {
        try {
            return this.myTestValidity.call();
        }
        catch (Exception e) {
            return false;
        }
    }
}

