/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.structure.services;

import com.android.tools.adtui.TabularLayout;
import com.android.tools.idea.observable.BindingsManager;
import com.android.tools.idea.observable.InvalidationListener;
import com.android.tools.idea.observable.collections.ObservableList;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.VerticalFlowLayout;
import com.intellij.ui.CollectionComboBoxModel;
import com.intellij.ui.HyperlinkLabel;
import com.intellij.util.containers.Stack;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.LayoutManager;
import java.io.IOException;
import java.net.URI;
import java.util.List;
import javax.swing.ComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.jetbrains.annotations.NotNull;

public final class ServicePanelBuilder {
    @NotNull
    private final JPanel myRootPanel;
    @NotNull
    private final BindingsManager myBindings = new BindingsManager();
    @NotNull
    private final Stack<UiGrid> myGrids = new Stack();

    public ServicePanelBuilder() {
        this.myRootPanel = new JPanel((LayoutManager)new VerticalFlowLayout(0, 0, 0, true, false));
        this.myRootPanel.putClientProperty("bindings", this.myBindings);
    }

    public JPanel getPanel() {
        assert (this.myGrids.isEmpty()) : "startGrid called without matching endGrid";
        return this.myRootPanel;
    }

    @NotNull
    public BindingsManager getBindings() {
        return this.myBindings;
    }

    public JPanel startGrid(@NotNull String colDefinitions) {
        UiGrid uiGrid = new UiGrid(colDefinitions);
        this.myGrids.push((Object)uiGrid);
        return uiGrid.getPanel();
    }

    public void endGrid() {
        assert (!this.myGrids.isEmpty()) : "endGrid called without matching startGrid";
        this.addComponent(((UiGrid)this.myGrids.pop()).getPanel());
    }

    public void setRow(int row) {
        assert (!this.myGrids.isEmpty()) : "setRow called without calling startGrid";
        ((UiGrid)this.myGrids.peek()).setCurrRow(row);
    }

    public void setCol(int col) {
        assert (!this.myGrids.isEmpty()) : "setCol called without calling startGrid";
        ((UiGrid)this.myGrids.peek()).setCurrCol(col);
    }

    public JButton addButton() {
        JButton button2 = new JButton();
        this.addComponent(button2);
        return button2;
    }

    public JCheckBox addCheckbox() {
        JCheckBox checkbox = new JCheckBox();
        this.addComponent(checkbox);
        return checkbox;
    }

    public JLabel addLabel() {
        JLabel label = new JLabel();
        this.addComponent(label);
        return label;
    }

    public HyperlinkLabel addLink(@NotNull String text, final @NotNull URI uri) {
        HyperlinkLabel linkLabel = new HyperlinkLabel(text);
        linkLabel.addHyperlinkListener(new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent e) {
                try {
                    Desktop.getDesktop().browse(uri);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        });
        this.addComponent((JComponent)linkLabel);
        return linkLabel;
    }

    public JTextField addField() {
        JTextField field2 = new JTextField();
        this.addComponent(field2);
        return field2;
    }

    public JComboBox addComboBox(final @NotNull ObservableList<String> backingList) {
        CollectionComboBoxModel<String> model2 = new CollectionComboBoxModel<String>(backingList){

            @NotNull
            public List<String> getItems() {
                return backingList;
            }
        };
        ComboBox comboBox = new ComboBox((ComboBoxModel)model2);
        InvalidationListener onListModified = () -> ServicePanelBuilder.lambda$addComboBox$0((CollectionComboBoxModel)model2, backingList, comboBox);
        this.addComponent((JComponent)comboBox);
        backingList.addWeakListener(onListModified);
        comboBox.putClientProperty((Object)"onListModified", (Object)onListModified);
        return comboBox;
    }

    private void addComponent(@NotNull JComponent component) {
        if (!this.myGrids.isEmpty()) {
            ((UiGrid)this.myGrids.peek()).addComponent(component);
        } else {
            this.myRootPanel.add(component);
        }
    }

    private static /* synthetic */ void lambda$addComboBox$0(CollectionComboBoxModel model2, ObservableList backingList, ComboBox comboBox) {
        model2.update();
        if (!backingList.isEmpty() && comboBox.getSelectedIndex() < 0) {
            comboBox.setSelectedIndex(0);
        }
    }

    private static class UiGrid {
        @NotNull
        private final JPanel myPanel;
        private final int myNumCols;
        private int myCurrCol;
        private int myCurrRow;

        public UiGrid(@NotNull String colDefinitions) {
            TabularLayout layout2 = new TabularLayout(colDefinitions).setVGap(10);
            this.myNumCols = layout2.getNumColumns();
            this.myPanel = new JPanel((LayoutManager)layout2);
        }

        @NotNull
        public JPanel getPanel() {
            return this.myPanel;
        }

        public void setCurrCol(int col) {
            if (col >= this.myNumCols) {
                throw new IllegalArgumentException(String.format("Can't set col = %1$d on a grid with only %2$d columns", col, this.myNumCols));
            }
            this.myCurrCol = col;
        }

        public void setCurrRow(int row) {
            this.myCurrRow = row;
        }

        public void addComponent(@NotNull JComponent component) {
            this.myPanel.add((Component)component, new TabularLayout.Constraint(this.myCurrRow, this.myCurrCol));
            this.myCurrRow = 0;
            this.myCurrCol = 0;
        }
    }
}

