/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.templates;

import com.android.tools.idea.templates.FmUtil;
import com.android.tools.idea.templates.TemplateUtils;
import freemarker.template.utility.StringUtil;
import java.security.InvalidParameterException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AssetNameConverter {
    private static final String ACTIVITY_NAME_SUFFIX = "Activity";
    private static final String DEFAULT_LAYOUT_NAME_PREFIX = "activity";
    private static final Pattern ACTIVITY_NAME_PATTERN = Pattern.compile("^(.*)Activity(\\d*)$");
    static final String[] STRIP_CLASS_SUFFIXES = new String[]{"Activity", "Fragment", "Service", "Provider"};
    @NotNull
    private final Type myType;
    @NotNull
    private final String myName;
    @Nullable
    private String myLayoutPrefixOverride;

    public AssetNameConverter(@NotNull Type type, @NotNull String name) {
        this.myType = type;
        this.myName = name;
    }

    @NotNull
    private String toClassName() {
        String className;
        switch (this.myType) {
            case ACTIVITY: {
                className = AssetNameConverter.stripActivitySuffix(this.myName);
                break;
            }
            case LAYOUT: {
                String layoutPrefix = this.getLayoutPrefixWithTrailingUnderscore();
                String layoutName = this.myName;
                if (layoutName.startsWith(layoutPrefix)) {
                    layoutName = layoutName.substring(layoutPrefix.length());
                }
                className = TemplateUtils.underlinesToCamelCase(layoutName);
                break;
            }
            case RESOURCE: {
                className = TemplateUtils.underlinesToCamelCase(this.myName);
                break;
            }
            case CLASS_NAME: {
                className = this.myName;
                for (String suffix : STRIP_CLASS_SUFFIXES) {
                    className = FmUtil.stripSuffix(className, suffix, true);
                }
                if (this.myLayoutPrefixOverride == null) break;
                String prefixAsSuffix = TemplateUtils.underlinesToCamelCase(this.myLayoutPrefixOverride);
                className = FmUtil.stripSuffix(className, prefixAsSuffix, false);
                break;
            }
            default: {
                throw new InvalidParameterException("Unhandled type: " + (Object)((Object)this.myType));
            }
        }
        return className;
    }

    @NotNull
    public AssetNameConverter overrideLayoutPrefix(@Nullable String layoutPrefixOverride) {
        this.myLayoutPrefixOverride = layoutPrefixOverride;
        return this;
    }

    @NotNull
    public String getValue(@NotNull Type type) {
        String className = this.toClassName();
        switch (type) {
            case ACTIVITY: {
                String activityName = TemplateUtils.extractClassName(className);
                if (activityName == null) {
                    activityName = "Main";
                }
                return activityName + ACTIVITY_NAME_SUFFIX;
            }
            case LAYOUT: {
                String layoutPrefix = this.getLayoutPrefixWithTrailingUnderscore();
                String layoutName = TemplateUtils.camelCaseToUnderlines(className);
                layoutName = StringUtil.replace((String)layoutName, (String)layoutPrefix, (String)"", (boolean)false, (boolean)true);
                return layoutPrefix + layoutName;
            }
            case RESOURCE: {
                return TemplateUtils.camelCaseToUnderlines(className);
            }
            case CLASS_NAME: {
                return className;
            }
        }
        throw new InvalidParameterException("Unhandled type: " + (Object)((Object)type));
    }

    private static String stripActivitySuffix(@NotNull String activityName) {
        Matcher m;
        String finalName = FmUtil.stripSuffix(activityName, ACTIVITY_NAME_SUFFIX, false);
        if (finalName.equals(activityName) && (m = ACTIVITY_NAME_PATTERN.matcher(activityName)).matches()) {
            String baseName = m.group(1);
            String digits = m.group(2);
            finalName = baseName + digits;
        }
        return finalName;
    }

    @NotNull
    private String getLayoutPrefixWithTrailingUnderscore() {
        return (this.myLayoutPrefixOverride == null ? DEFAULT_LAYOUT_NAME_PREFIX : this.myLayoutPrefixOverride) + "_";
    }

    public static enum Type {
        ACTIVITY,
        LAYOUT,
        CLASS_NAME,
        RESOURCE;

    }
}

