/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.templates;

import com.android.tools.idea.configurations.Configuration;
import com.android.tools.idea.configurations.ConfigurationManager;
import com.android.tools.idea.npw.ThemeHelper;
import com.android.tools.idea.templates.FmUtil;
import com.google.common.collect.Maps;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.vfs.VirtualFile;
import freemarker.template.TemplateMethodModelEx;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;

public class FmGetApplicationThemeMethod
implements TemplateMethodModelEx {
    private final Map<String, Object> myParamMap;

    public FmGetApplicationThemeMethod(Map<String, Object> paramMap) {
        this.myParamMap = paramMap;
    }

    public Object exec(List arguments) {
        String modulePath = (String)this.myParamMap.get("projectOut");
        if (modulePath == null) {
            return null;
        }
        Module module = FmUtil.findModule(modulePath);
        if (module == null) {
            return null;
        }
        ThemeHelper helper = new ThemeHelper(module);
        AndroidFacet facet = AndroidFacet.getInstance(module);
        if (facet == null) {
            return null;
        }
        VirtualFile projectFile = module.getProject().getProjectFile();
        if (projectFile == null) {
            return null;
        }
        ConfigurationManager manager = ConfigurationManager.getOrCreateInstance(module);
        Configuration configuration = manager.getConfiguration(projectFile);
        String themeName = helper.getAppThemeName();
        if (themeName == null) {
            return null;
        }
        HashMap map2 = Maps.newHashMap();
        map2.put("name", themeName);
        map2.put("isAppCompat", helper.isAppCompatTheme(themeName));
        map2.put("exists", true);
        Boolean hasActionBar = ThemeHelper.hasActionBar(configuration, themeName);
        FmGetApplicationThemeMethod.addDerivedTheme(map2, themeName, "NoActionBar", hasActionBar == Boolean.FALSE, helper, configuration);
        FmGetApplicationThemeMethod.addDerivedTheme(map2, themeName, "AppBarOverlay", false, helper, configuration);
        FmGetApplicationThemeMethod.addDerivedTheme(map2, themeName, "PopupOverlay", false, helper, configuration);
        return map2;
    }

    private static void addDerivedTheme(@NotNull Map<String, Object> map2, @NotNull String themeName, @NotNull String derivedThemeName, boolean useBaseThemeAsDerivedTheme, @NotNull ThemeHelper helper, @NotNull Configuration configuration) {
        String fullThemeName = useBaseThemeAsDerivedTheme ? themeName : themeName + "." + derivedThemeName;
        boolean exists = ThemeHelper.themeExists(configuration, fullThemeName);
        if (!exists && !helper.isLocalTheme(themeName)) {
            fullThemeName = derivedThemeName;
            exists = helper.isLocalTheme(derivedThemeName);
        }
        map2.put("name" + derivedThemeName, fullThemeName);
        map2.put("exists" + derivedThemeName, exists);
    }
}

