/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.templates;

import com.android.ide.common.repository.GradleCoordinate;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import com.google.common.collect.Ordering;
import com.intellij.psi.PsiElement;
import java.util.Comparator;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementFactory;

public class GradleFileMergers {
    static final String DEPENDENCIES = "dependencies";
    private static final ImmutableList<String> KNOWN_CONFIGURATIONS_IN_ORDER = ImmutableList.of((Object)"feature", (Object)"api", (Object)"implementation", (Object)"compile", (Object)"testApi", (Object)"testImplementation", (Object)"testCompile", (Object)"androidTestApi", (Object)"androidTestImplementation", (Object)"androidTestCompile", (Object)"androidTestUtil");
    private static final ImmutableSet<ImmutableSet<String>> CONFIGURATION_GROUPS = ImmutableSet.of((Object)ImmutableSet.of((Object)"feature", (Object)"api", (Object)"implementation", (Object)"compile"), (Object)ImmutableSet.of((Object)"testApi", (Object)"testImplementation", (Object)"testCompile"), (Object)ImmutableSet.of((Object)"androidTestApi", (Object)"androidTestImplementation", (Object)"androidTestCompile"));
    static final Ordering<String> CONFIGURATION_ORDERING = Ordering.natural().onResultOf(input -> {
        int result2 = KNOWN_CONFIGURATIONS_IN_ORDER.indexOf(input);
        return Integer.valueOf(result2 != -1 ? result2 : KNOWN_CONFIGURATIONS_IN_ORDER.size());
    }).compound((Comparator)Ordering.natural());

    public static void updateExistingDependencies(@NotNull Map<String, Multimap<String, GradleCoordinate>> newDependencies, @NotNull Map<String, Multimap<String, GradleCoordinate>> existingDependencies, @Nullable Map<GradleCoordinate, PsiElement> psiGradleCoordinates, @Nullable GroovyPsiElementFactory factory) {
        for (String configuration : newDependencies.keySet()) {
            for (String possibleConfiguration : GradleFileMergers.getConfigurationGroup(configuration)) {
                if (!existingDependencies.containsKey(possibleConfiguration)) continue;
                for (Map.Entry possibleConfigurationEntry : existingDependencies.get(possibleConfiguration).entries()) {
                    String coordinateId = (String)possibleConfigurationEntry.getKey();
                    newDependencies.get(configuration).removeAll((Object)coordinateId);
                    if (psiGradleCoordinates == null || factory == null || CONFIGURATION_ORDERING.compare((Object)configuration, (Object)possibleConfiguration) >= 0) continue;
                    PsiElement psiEntry = psiGradleCoordinates.get(possibleConfigurationEntry.getValue());
                    psiEntry.replace((PsiElement)factory.createExpressionFromText((CharSequence)configuration));
                }
            }
        }
    }

    private GradleFileMergers() {
    }

    private static ImmutableSet<String> getConfigurationGroup(String configuration) {
        for (ImmutableSet group : CONFIGURATION_GROUPS) {
            if (!group.contains((Object)configuration)) continue;
            return group;
        }
        return ImmutableSet.of((Object)configuration);
    }
}

