/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.templates;

import com.android.ide.common.repository.GradleCoordinate;
import com.android.repository.io.FileOpUtils;
import com.android.tools.idea.templates.GradleFileMergers;
import com.android.tools.idea.templates.RepositoryUrlManager;
import com.google.common.base.CharMatcher;
import com.google.common.collect.LinkedListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.intellij.ide.startup.impl.StartupManagerImpl;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ex.ProjectManagerEx;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.util.Disposer;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.impl.source.tree.LeafPsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.GroovyFileType;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFile;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementFactory;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrArgumentList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrClosableBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrAssignmentExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrCall;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrMethodCall;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.literals.GrLiteral;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.path.GrCallExpression;

public class GradleFilePsiMerger {
    public static String mergeGradleFiles(@NotNull String source, @NotNull String dest, @Nullable Project project, final @Nullable String supportLibVersionFilter) {
        Project project2;
        source = source.replace("\r", "");
        dest = dest.replace("\r", "");
        boolean projectNeedsCleanup = false;
        if (project != null && !project.isDefault()) {
            project2 = project;
        } else {
            project2 = ProjectManagerEx.getInstanceEx().newProject("MergingOnly", "", false, true);
            assert (project2 != null);
            ((StartupManagerImpl)StartupManager.getInstance((Project)project2)).runStartupActivities();
            projectNeedsCleanup = true;
        }
        source = source.trim();
        dest = dest.trim();
        final GroovyFile templateBuildFile = (GroovyFile)PsiFileFactory.getInstance((Project)project2).createFileFromText("build.gradle", (FileType)GroovyFileType.GROOVY_FILE_TYPE, (CharSequence)source);
        final GroovyFile existingBuildFile = (GroovyFile)PsiFileFactory.getInstance((Project)project2).createFileFromText("build.gradle", (FileType)GroovyFileType.GROOVY_FILE_TYPE, (CharSequence)dest);
        String result2 = (String)new WriteCommandAction<String>(project2, "Merge Gradle Files", new PsiFile[]{existingBuildFile}){

            protected void run(@NotNull Result<String> result2) throws Throwable {
                GradleFilePsiMerger.addTrailingNewLine(existingBuildFile);
                GradleFilePsiMerger.mergePsi((PsiElement)templateBuildFile, (PsiElement)existingBuildFile, project2, supportLibVersionFilter);
                PsiElement formatted = CodeStyleManager.getInstance((Project)project2).reformat((PsiElement)existingBuildFile);
                result2.setResult((Object)formatted.getText());
            }
        }.execute().getResultObject();
        if (projectNeedsCleanup) {
            ApplicationManager.getApplication().runWriteAction(() -> Disposer.dispose((Disposable)project2));
        }
        return result2;
    }

    private static void mergePsi(@NotNull PsiElement fromRoot, @NotNull PsiElement toRoot, @NotNull Project project, @Nullable String supportLibVersionFilter) {
        HashSet<PsiElement> destinationChildren = new HashSet<PsiElement>();
        destinationChildren.addAll(Arrays.asList(toRoot.getChildren()));
        if (toRoot instanceof GrCallExpression && fromRoot instanceof GrCallExpression) {
            PsiElement[] fromArguments = fromRoot.getLastChild().getChildren();
            PsiElement[] toArguments = toRoot.getLastChild().getChildren();
            if (toArguments.length == 1 && fromArguments.length == 1 && toArguments[0] instanceof GrLiteral && fromArguments[0] instanceof GrLiteral) {
                toArguments[0].replace(fromArguments[0]);
                return;
            }
        }
        for (PsiElement child : fromRoot.getChildren()) {
            PsiElement destination = GradleFilePsiMerger.findEquivalentElement(destinationChildren, child);
            if (destination == null) {
                if (destinationChildren.isEmpty()) {
                    toRoot.add(child);
                    continue;
                }
                if (child instanceof GrAssignmentExpression && child.getChildren().length == 2 && child.getChildren()[1] instanceof GrLiteral && child.getText().startsWith("ext.")) {
                    child = toRoot.addAfter(child, toRoot.getFirstChild());
                    GradleFilePsiMerger.ensureCorrectSpacing(child);
                    continue;
                }
                child = toRoot.addBefore(child, toRoot.getLastChild());
                GradleFilePsiMerger.ensureCorrectSpacing(child);
                continue;
            }
            if (child.getFirstChild() != null && child.getFirstChild().getText().equalsIgnoreCase("dependencies") && destination.getFirstChild() != null && destination.getFirstChild().getText().equalsIgnoreCase("dependencies")) {
                GradleFilePsiMerger.mergeDependencies(child.getLastChild(), destination.getLastChild(), project, supportLibVersionFilter);
                continue;
            }
            GradleFilePsiMerger.mergePsi(child, destination, project, supportLibVersionFilter);
        }
    }

    private static void mergeDependencies(@NotNull PsiElement fromRoot, @NotNull PsiElement toRoot, @NotNull Project project, @Nullable String supportLibVersionFilter) {
        TreeMap<String, Multimap<String, GradleCoordinate>> dependencies = new TreeMap<String, Multimap<String, GradleCoordinate>>((Comparator<String>)GradleFileMergers.CONFIGURATION_ORDERING);
        ArrayList unparsedDependencies = Lists.newArrayList();
        HashMap originalDependencies = Maps.newHashMap();
        HashMap psiGradleCoordinate = Maps.newHashMap();
        ArrayList originalUnparsedDependencies = Lists.newArrayList();
        GradleFilePsiMerger.pullDependenciesIntoMap(toRoot, originalDependencies, originalUnparsedDependencies, psiGradleCoordinate);
        GradleFilePsiMerger.pullDependenciesIntoMap(fromRoot, dependencies, unparsedDependencies, null);
        GroovyPsiElementFactory factory = GroovyPsiElementFactory.getInstance((Project)project);
        GradleFileMergers.updateExistingDependencies(dependencies, originalDependencies, psiGradleCoordinate, factory);
        RepositoryUrlManager urlManager = RepositoryUrlManager.get();
        dependencies.forEach((configurationName, unresolvedDependencies) -> {
            List<GradleCoordinate> resolved = urlManager.resolveDynamicSdkDependencies((Multimap<String, GradleCoordinate>)unresolvedDependencies, supportLibVersionFilter, FileOpUtils.create());
            PsiElement nextElement = GradleFilePsiMerger.findInsertionPoint(toRoot, configurationName);
            for (GradleCoordinate dependency : resolved) {
                GrStatement dependencyElement = factory.createStatementFromText((CharSequence)String.format("%s '%s'\n", configurationName, dependency.toString()));
                PsiElement newElement = toRoot.addBefore((PsiElement)dependencyElement, nextElement);
                toRoot.addAfter(factory.createLineTerminator(1), newElement);
            }
        });
        Set originalSet = originalUnparsedDependencies.stream().map(arg_0 -> ((CharMatcher)CharMatcher.WHITESPACE).removeFrom(arg_0)).collect(Collectors.toSet());
        for (String dependency : unparsedDependencies) {
            if (originalSet.contains(CharMatcher.WHITESPACE.removeFrom((CharSequence)dependency))) continue;
            GrStatement dependencyElement = factory.createStatementFromText((CharSequence)dependency);
            toRoot.addBefore((PsiElement)dependencyElement, toRoot.getLastChild());
        }
    }

    private static void addTrailingNewLine(@NotNull GroovyFile file) {
        PsiElement newLineElement = GradleFilePsiMerger.getNewLineElement((PsiElement)file, 1);
        file.addAfter(newLineElement, file.getLastChild());
    }

    @NotNull
    private static PsiElement getNewLineElement(@NotNull PsiElement context, int length) {
        GroovyPsiElementFactory factory = GroovyPsiElementFactory.getInstance((Project)context.getProject());
        return factory.createLineTerminator(length);
    }

    private static boolean scanForNewLineOrNull(@NotNull PsiElement element, boolean searchForward) {
        return GradleFilePsiMerger.scanAndCountNewLinesOrNulls(element, searchForward, 1) > 0;
    }

    private static int scanAndCountNewLinesOrNulls(@NotNull PsiElement element, boolean searchForward, int numberOfNewLines) {
        int foundNewLines = 0;
        HashSet<PsiElement> seen = new HashSet<PsiElement>();
        while (!seen.contains(element)) {
            if (element == null) {
                return Integer.MAX_VALUE;
            }
            if (element.getNode().getElementType().equals(GroovyTokenTypes.mNLS)) {
                foundNewLines += element.getTextLength();
            } else if (!(element instanceof PsiWhiteSpace)) {
                return foundNewLines;
            }
            if (foundNewLines >= numberOfNewLines) {
                return foundNewLines;
            }
            seen.add(element);
            if (!searchForward) {
                element = element.getPrevSibling();
                continue;
            }
            element = element.getNextSibling();
        }
        return Integer.MAX_VALUE;
    }

    private static boolean shouldBeWrappedByNewLines(@NotNull PsiElement element) {
        return !(element.getParent() == null || !(element instanceof GrMethodCall) && !(element instanceof GrAssignmentExpression) || !(element.getParent() instanceof GroovyFile) && !(element.getParent() instanceof GrClosableBlock));
    }

    private static void ensureCorrectSpacing(@NotNull PsiElement element) {
        if (!GradleFilePsiMerger.shouldBeWrappedByNewLines(element)) {
            return;
        }
        PsiElement newLineElement = GradleFilePsiMerger.getNewLineElement(element, 1);
        if (element.getParent() instanceof GroovyFile) {
            int newLines;
            int n = newLines = element.getPrevSibling() == null ? -1 : GradleFilePsiMerger.scanAndCountNewLinesOrNulls(element.getPrevSibling(), false, 2);
            if (newLines >= 0 && newLines < 2) {
                PsiElement doubleNewLineElement = GradleFilePsiMerger.getNewLineElement(element, 2 - newLines);
                element.getParent().addBefore(doubleNewLineElement, element);
            }
        } else if (!GradleFilePsiMerger.scanForNewLineOrNull(element.getPrevSibling(), false)) {
            element.getParent().addBefore(newLineElement, element);
        }
        if (!GradleFilePsiMerger.scanForNewLineOrNull(element.getNextSibling(), true)) {
            element.getParent().addAfter(newLineElement, element);
        }
    }

    @NotNull
    private static PsiElement findInsertionPoint(@NotNull PsiElement root, String configurationName) {
        String currentConfigurationName;
        GrMethodCall current = (GrMethodCall)PsiTreeUtil.getChildOfType((PsiElement)root, GrMethodCall.class);
        while (current != null && ((currentConfigurationName = GradleFilePsiMerger.getConfigurationName(current)) == null || GradleFileMergers.CONFIGURATION_ORDERING.compare((Object)currentConfigurationName, (Object)configurationName) <= 0)) {
            current = (GrMethodCall)PsiTreeUtil.getNextSiblingOfType((PsiElement)current, GrMethodCall.class);
        }
        return current != null ? current : root.getLastChild();
    }

    @Nullable
    private static String getConfigurationName(@NotNull GrMethodCall element) {
        IElementType elementType;
        PsiElement referenceNameElement;
        GrExpression invokedExpression = element.getInvokedExpression();
        if (invokedExpression instanceof GrReferenceExpression && (referenceNameElement = ((GrReferenceExpression)invokedExpression).getReferenceNameElement()) instanceof LeafPsiElement && (elementType = ((LeafPsiElement)referenceNameElement).getElementType()) == GroovyTokenTypes.mIDENT) {
            return referenceNameElement.getText();
        }
        return null;
    }

    private static void pullDependenciesIntoMap(@NotNull PsiElement root, @NotNull Map<String, Multimap<String, GradleCoordinate>> allConfigurations, @NotNull List<String> unparsedDependencies, @Nullable Map<GradleCoordinate, PsiElement> psiGradleCoordinate) {
        for (PsiElement existingElem : root.getChildren()) {
            String coordinateText;
            GradleCoordinate coordinate;
            Object value2;
            PsiElement reference2;
            if (!(existingElem instanceof GrCall) || !((reference2 = existingElem.getFirstChild()) instanceof GrReferenceExpression)) continue;
            String configurationName = reference2.getText();
            boolean parsed = false;
            GrCall call = (GrCall)existingElem;
            GrArgumentList arguments = call.getArgumentList();
            if (arguments == null || call.getClosureArguments().length != 0) continue;
            GrExpression[] expressionArguments = arguments.getExpressionArguments();
            if (expressionArguments.length == 1 && expressionArguments[0] instanceof GrLiteral && (value2 = ((GrLiteral)expressionArguments[0]).getValue()) instanceof String && (coordinate = GradleCoordinate.parseCoordinateString((String)(coordinateText = (String)value2))) != null) {
                parsed = true;
                Multimap map2 = allConfigurations.computeIfAbsent(configurationName, k -> LinkedListMultimap.create());
                if (!map2.get((Object)coordinate.getId()).contains(coordinate)) {
                    map2.put((Object)coordinate.getId(), (Object)coordinate);
                    if (psiGradleCoordinate != null) {
                        psiGradleCoordinate.put(coordinate, reference2);
                    }
                }
            }
            if (parsed || unparsedDependencies == null) continue;
            unparsedDependencies.add(existingElem.getText());
        }
    }

    @Nullable
    private static PsiElement findEquivalentElement(@NotNull Collection<PsiElement> collection, @NotNull PsiElement element) {
        ArrayList matchingItems = Lists.newArrayListWithExpectedSize((int)1);
        for (PsiElement item : collection) {
            if (item.getText() != null && item.getText().equals(element.getText())) {
                return item;
            }
            if (item.getFirstChild() == null || element.getFirstChild() == null || !item.getFirstChild().getText().equals(element.getFirstChild().getText())) continue;
            matchingItems.add(item);
        }
        if (matchingItems.size() == 1) {
            return (PsiElement)matchingItems.get(0);
        }
        return null;
    }
}

