/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.templates;

import com.android.ide.common.repository.GradleCoordinate;
import com.android.repository.io.FileOpUtils;
import com.android.tools.idea.templates.GradleFileMergers;
import com.android.tools.idea.templates.RepositoryUrlManager;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import com.intellij.lexer.LexerPosition;
import com.intellij.lexer.LookAheadLexer;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.TokenType;
import com.intellij.psi.tree.IElementType;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyLexer;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;
import org.jetbrains.plugins.groovy.lang.psi.GroovyElementTypes;

public class GradleFileSimpleMerger {
    public static String mergeGradleFiles(@NotNull String source, @NotNull String dest, @Nullable Project project, @Nullable String supportLibVersionFilter) {
        SimpleGradleBuildFileParser templateParser = new SimpleGradleBuildFileParser(source);
        Ast template = templateParser.parse();
        assert (template != null);
        SimpleGradleBuildFileParser existingParser = new SimpleGradleBuildFileParser(dest);
        Ast existing2 = existingParser.parse();
        PrintContext printContext = new PrintContext();
        if (existing2 != null) {
            MergeContext mergeContext = new MergeContext(project, supportLibVersionFilter);
            existing2.merge(mergeContext, template);
            existing2.print(printContext);
        } else {
            template.print(printContext);
        }
        return printContext.toString();
    }

    private static Logger getLogger() {
        return Logger.getInstance(GradleFileSimpleMerger.class);
    }

    private static class MergeContext {
        private final Project myProject;
        private final String myFilter;

        public MergeContext(@Nullable Project project, @Nullable String supportLibVersionFilter) {
            this.myProject = project;
            this.myFilter = supportLibVersionFilter;
        }

        String getFilter() {
            return this.myFilter;
        }

        Project getProject() {
            return this.myProject;
        }
    }

    private static class PrintContext {
        private int myIndent = 0;
        private StringBuilder myBuilder = new StringBuilder();

        public PrintContext append(@NotNull String value2) {
            if (this.atStartOfLine() && !value2.startsWith("\n")) {
                this.appendIndent();
            }
            this.myBuilder.append(value2);
            return this;
        }

        void increaseIndent() {
            ++this.myIndent;
        }

        void decreaseIndent() {
            --this.myIndent;
        }

        void removePreviousSingleSpaceChar() {
            int len = this.myBuilder.length();
            if (len > 1 && this.myBuilder.charAt(len - 1) == ' ' && Character.isJavaIdentifierPart(len - 2)) {
                this.myBuilder.setLength(this.myBuilder.length() - 1);
            }
        }

        void appendNewLineIfNoIndent() {
            if (this.myIndent == 0) {
                this.myBuilder.append("\n");
            }
        }

        private boolean atStartOfLine() {
            if (this.myBuilder.length() == 0) {
                return true;
            }
            return this.myBuilder.charAt(this.myBuilder.length() - 1) == '\n';
        }

        private void appendIndent() {
            for (int index = 0; index < this.myIndent; ++index) {
                this.myBuilder.append("    ");
            }
        }

        public String toString() {
            return this.myBuilder.toString();
        }
    }

    private static class UnknownAstNode
    extends Ast {
        @NotNull
        private String myText;

        public UnknownAstNode(@NotNull String text) {
            this.myText = text;
        }

        @Override
        public void print(@NotNull PrintContext context) {
            if (!this.myText.isEmpty() && !Character.isJavaIdentifierPart(this.myText.charAt(0))) {
                context.removePreviousSingleSpaceChar();
            }
            context.append(this.myText).append("\n");
            if (this.myNext != null) {
                context.appendNewLineIfNoIndent();
                this.myNext.print(context);
            }
        }

        @Override
        public void merge(@NotNull MergeContext context, @NotNull Ast other) {
            if (this.myNext != null) {
                this.myNext.merge(context, other);
            } else {
                this.myNext = other;
            }
        }

        @Override
        protected boolean isComplex() {
            return this.myNext != null;
        }
    }

    private static class ValueListAst
    extends Ast {
        private Set<String> myValues;

        public ValueListAst(@NotNull List<String> values) {
            this.myValues = Sets.newLinkedHashSetWithExpectedSize((int)(values.size() + 5));
            this.myValues.addAll(values);
        }

        @Override
        public void print(@NotNull PrintContext context) {
            context.append("= [");
            String separator = "";
            for (String value2 : this.myValues) {
                context.append(separator);
                context.append(value2);
                separator = ", ";
            }
            context.append("]\n");
        }

        @Override
        public void merge(@NotNull MergeContext context, @NotNull Ast other) {
            if (other instanceof ValueListAst) {
                ValueListAst list = (ValueListAst)other;
                this.myValues.addAll(list.myValues);
            } else {
                GradleFileSimpleMerger.getLogger().warn("Cannot merge value list with a different construct");
            }
        }
    }

    private static class ValueAst
    extends Ast {
        private String myValue;

        public ValueAst(@NotNull String value2) {
            this.myValue = value2;
        }

        @Override
        public void print(@NotNull PrintContext context) {
            context.append(this.myValue).append("\n");
        }

        @Override
        public void merge(@NotNull MergeContext context, @NotNull Ast other) {
            if (other instanceof ValueAst) {
                this.myValue = ((ValueAst)other).myValue;
            }
        }
    }

    private static class AstNode
    extends Ast {
        @Nullable
        protected Ast myParam;

        public AstNode(@NotNull String id) {
            this.myId = id;
        }

        @Override
        public void print(@NotNull PrintContext context) {
            assert (this.myId != null);
            context.append(this.myId).append(" ");
            if (this.myParam != null) {
                if (this.myParam.isComplex()) {
                    context.increaseIndent();
                    context.append("{\n");
                    this.myParam.print(context);
                    context.decreaseIndent();
                    context.append("}\n");
                } else {
                    this.myParam.print(context);
                }
            }
            if (this.myNext != null) {
                context.appendNewLineIfNoIndent();
                this.myNext.print(context);
            }
        }

        @Override
        public void merge(@NotNull MergeContext context, @NotNull Ast other) {
            assert (this.myId != null);
            Ast first = other;
            Ast similar = other.find(this.myId);
            if (similar instanceof AstNode) {
                first = other.remove(similar);
                AstNode node = (AstNode)similar;
                if (this.myParam == null) {
                    this.myParam = node.myParam;
                } else if (this.myId.equals("dependencies")) {
                    this.mergeDependencies(context, node);
                } else if (node.myParam != null) {
                    this.myParam.merge(context, node.myParam);
                }
            } else if (similar != null) {
                GradleFileSimpleMerger.getLogger().warn("Cannot merge AstNode with a non AstNode");
            }
            if (this.myNext != null && first != null) {
                this.myNext.merge(context, first);
            } else if (first != null) {
                this.myNext = first;
            }
        }

        @Override
        public boolean isComplex() {
            return this.myNext != null || this.myParam != null;
        }

        private void mergeDependencies(@NotNull MergeContext context, @NotNull AstNode other) {
            TreeMap<String, Multimap<String, GradleCoordinate>> dependencies = new TreeMap<String, Multimap<String, GradleCoordinate>>((Comparator<String>)GradleFileMergers.CONFIGURATION_ORDERING);
            ArrayList unparseableDependencies = Lists.newArrayListWithCapacity((int)10);
            HashMap originalDependencies = Maps.newHashMap();
            this.pullDependenciesIntoMap(originalDependencies, null);
            other.pullDependenciesIntoMap(dependencies, unparseableDependencies);
            GradleFileMergers.updateExistingDependencies(dependencies, originalDependencies, null, null);
            RepositoryUrlManager urlManager = RepositoryUrlManager.get();
            dependencies.forEach((configurationName, unresolvedDependencies) -> {
                List<GradleCoordinate> resolved = urlManager.resolveDynamicSdkDependencies((Multimap<String, GradleCoordinate>)unresolvedDependencies, context.getFilter(), FileOpUtils.create());
                Ast prev = this.myParam != null ? this.findInsertionPoint((String)configurationName) : null;
                for (GradleCoordinate coordinate : resolved) {
                    AstNode configurationNode = new AstNode((String)configurationName);
                    configurationNode.myParam = new ValueAst("'" + coordinate + "'");
                    if (prev == null) {
                        configurationNode.myNext = this.myParam;
                        this.myParam = configurationNode;
                    } else {
                        configurationNode.myNext = prev.myNext;
                        prev.myNext = configurationNode;
                    }
                    prev = configurationNode;
                }
            });
            Ast prev = this.myParam != null ? this.myParam.findLast() : null;
            for (Ast node : unparseableDependencies) {
                if (prev == null) {
                    this.myParam = node;
                } else {
                    prev.myNext = node;
                }
                prev = node;
                node.myNext = null;
            }
        }

        @Nullable
        private Ast findInsertionPoint(@NotNull String configuration) {
            assert (this.myParam != null);
            if (this.myParam.myId != null && GradleFileMergers.CONFIGURATION_ORDERING.compare((Object)configuration, (Object)this.myParam.myId) < 0) {
                return null;
            }
            Ast result2 = this.myParam;
            while (result2.myNext != null && (result2.myNext.myId == null || GradleFileMergers.CONFIGURATION_ORDERING.compare((Object)configuration, (Object)result2.myNext.myId) >= 0)) {
                result2 = result2.myNext;
                assert (result2 != null);
            }
            return result2;
        }

        private void pullDependenciesIntoMap(@NotNull Map<String, Multimap<String, GradleCoordinate>> dependencies, @Nullable List<Ast> unparseableDependencies) {
            Ast node = this.myParam;
            while (node != null) {
                assert (this.myParam != null);
                boolean parsed = false;
                if (node instanceof AstNode) {
                    ValueAst value2;
                    String coordinateText;
                    GradleCoordinate coordinate;
                    String configuration = node.myId;
                    AstNode compile = (AstNode)node;
                    if (compile.myParam instanceof ValueAst && (coordinate = GradleCoordinate.parseCoordinateString((String)(coordinateText = StringUtil.unquoteString((String)(value2 = (ValueAst)compile.myParam).myValue)))) != null) {
                        parsed = true;
                        LinkedHashMultimap map2 = dependencies.get(configuration);
                        if (map2 == null) {
                            map2 = LinkedHashMultimap.create();
                            dependencies.put(configuration, (Multimap<String, GradleCoordinate>)map2);
                        }
                        if (!map2.get((Object)coordinate.getId()).contains(coordinate)) {
                            map2.put((Object)coordinate.getId(), (Object)coordinate);
                        }
                    }
                }
                if (!parsed && unparseableDependencies != null) {
                    unparseableDependencies.add(node);
                }
                node = node.myNext;
            }
        }
    }

    private static abstract class Ast {
        @Nullable
        protected String myId = null;
        @Nullable
        protected Ast myNext = null;

        private Ast() {
        }

        public abstract void print(@NotNull PrintContext var1);

        public abstract void merge(@NotNull MergeContext var1, @NotNull Ast var2);

        protected boolean isComplex() {
            return this.myNext != null;
        }

        @Nullable
        private Ast find(@NotNull String id) {
            Ast node = this;
            while (node != null && !id.equals(node.myId)) {
                node = node.myNext;
            }
            return node;
        }

        @Nullable
        Ast remove(@NotNull Ast toRemove) {
            Ast first = this;
            Ast prev = null;
            Ast node = this;
            while (node != null && toRemove != node) {
                prev = node;
                node = node.myNext;
            }
            if (toRemove == node) {
                first = this.remove(toRemove, first, prev);
            }
            return first;
        }

        Ast remove(@NotNull Ast toRemove, @NotNull Ast first, @Nullable Ast prev) {
            Ast newFirst = first;
            if (prev == null) {
                newFirst = toRemove.myNext;
            } else {
                prev.myNext = toRemove.myNext;
            }
            toRemove.myNext = null;
            return newFirst;
        }

        Ast findLast() {
            Ast node = this;
            while (node.myNext != null) {
                node = node.myNext;
            }
            return node;
        }
    }

    private static class SimpleGradleBuildFileParser {
        private GroovyLexer myLexer = new GroovyLexer();
        private IElementType myType = null;

        public SimpleGradleBuildFileParser(@NotNull String source) {
            this.myLexer.start((CharSequence)source);
            this.myType = this.myLexer.getTokenType();
        }

        public void next() {
            this.nextKeepWhiteSpace();
            while (this.myType != null && this.myType == TokenType.WHITE_SPACE) {
                this.nextKeepWhiteSpace();
            }
        }

        public void nextKeepWhiteSpace() {
            if (this.myType != null) {
                this.myLexer.advance();
                this.myType = this.myLexer.getTokenType();
            }
        }

        public void skipNewLine() {
            if (this.myType == GroovyTokenTypes.mNLS) {
                this.next();
            }
        }

        @Nullable
        public Ast parse() {
            if (this.myType == null) {
                return null;
            }
            Ast result2 = this.myType == GroovyTokenTypes.mIDENT ? this.parseBlockOrAssignment() : this.parseUnknown();
            if (this.myType != GroovyTokenTypes.mRCURLY) {
                result2.myNext = this.parse();
            }
            return result2;
        }

        private Ast parseBlockOrAssignment() {
            assert (this.myType == GroovyTokenTypes.mIDENT);
            LookAheadLexer.LookAheadLexerPosition pos = this.myLexer.getCurrentPosition();
            AstNode node = this.parseIdentifier();
            if (node == null) {
                return this.restoreAndParseUnknown((LexerPosition)pos);
            }
            if (this.myType == GroovyTokenTypes.mLCURLY) {
                this.next();
                node.myParam = this.parse();
                if (this.myType != GroovyTokenTypes.mRCURLY) {
                    return this.restoreAndParseUnknown((LexerPosition)pos);
                }
                this.next();
                this.skipNewLine();
            } else {
                node.myParam = this.parseValue();
            }
            return node;
        }

        private AstNode parseIdentifier() {
            assert (this.myType == GroovyTokenTypes.mIDENT);
            String identifier = this.myLexer.getTokenText();
            this.next();
            while (this.myType == GroovyTokenTypes.mDOT) {
                this.next();
                if (this.myType != GroovyTokenTypes.mIDENT) {
                    return null;
                }
                identifier = identifier + ".";
                identifier = identifier + this.myLexer.getTokenText();
                this.next();
            }
            return new AstNode(identifier);
        }

        private Ast parseValue() {
            if (this.myType == GroovyTokenTypes.mASSIGN) {
                return this.parseValueList();
            }
            if (this.myType == GroovyElementTypes.STRING_SQ || this.myType == GroovyElementTypes.STRING_TSQ || this.myType == GroovyElementTypes.STRING_DQ || this.myType == GroovyElementTypes.STRING_TDQ || this.myType == GroovyTokenTypes.mNUM_INT || this.myType == GroovyTokenTypes.mNUM_BIG_INT || this.myType == GroovyTokenTypes.mNUM_BIG_DECIMAL || this.myType == GroovyTokenTypes.mNUM_FLOAT || this.myType == GroovyTokenTypes.mNUM_DOUBLE || this.myType == GroovyTokenTypes.kFALSE || this.myType == GroovyTokenTypes.kTRUE) {
                String value2 = this.myLexer.getTokenText();
                this.next();
                this.skipNewLine();
                return new ValueAst(value2);
            }
            return this.parseUnknown();
        }

        private Ast parseValueList() {
            LookAheadLexer.LookAheadLexerPosition pos = this.myLexer.getCurrentPosition();
            assert (this.myType == GroovyTokenTypes.mASSIGN);
            this.next();
            if (this.myType != GroovyTokenTypes.mLBRACK) {
                return this.restoreAndParseUnknown((LexerPosition)pos);
            }
            this.next();
            ArrayList values = Lists.newArrayListWithCapacity((int)10);
            if (!this.findStringLiteral(values)) {
                return this.restoreAndParseUnknown((LexerPosition)pos);
            }
            while (this.myType == GroovyTokenTypes.mCOMMA) {
                this.next();
                if (this.findStringLiteral(values)) continue;
                return this.restoreAndParseUnknown((LexerPosition)pos);
            }
            if (this.myType != GroovyTokenTypes.mRBRACK) {
                return this.restoreAndParseUnknown((LexerPosition)pos);
            }
            this.next();
            this.skipNewLine();
            return new ValueListAst(values);
        }

        private boolean findStringLiteral(List<String> literals) {
            if (this.myType != GroovyElementTypes.STRING_SQ && this.myType != GroovyElementTypes.STRING_TSQ) {
                return false;
            }
            literals.add(this.myLexer.getTokenText());
            this.next();
            return true;
        }

        private Ast restoreAndParseUnknown(LexerPosition pos) {
            this.myLexer.restore(pos);
            return this.parseUnknown();
        }

        private Ast parseUnknown() {
            int level = 0;
            StringBuilder builder = new StringBuilder();
            while (this.myType != null) {
                if (this.myType == GroovyTokenTypes.mLCURLY) {
                    ++level;
                } else if (this.myType == GroovyTokenTypes.mRCURLY) {
                    if (--level < 0) {
                        break;
                    }
                } else {
                    if (level == 0 && this.myType == GroovyTokenTypes.mNLS) {
                        this.next();
                        break;
                    }
                    if (level == 0 && this.myType == GroovyTokenTypes.mSL_COMMENT) {
                        builder.append(this.myLexer.getTokenSequence());
                        this.next();
                        break;
                    }
                }
                builder.append(this.myLexer.getTokenSequence());
                this.nextKeepWhiteSpace();
            }
            return new UnknownAstNode(builder.toString());
        }
    }
}

