/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.templates;

import com.android.ide.common.repository.GoogleMavenRepository;
import com.android.ide.common.repository.GradleCoordinate;
import com.android.ide.common.repository.GradleVersion;
import com.android.ide.common.repository.MavenRepositories;
import com.android.ide.common.repository.SdkMavenRepository;
import com.android.repository.api.ProgressIndicator;
import com.android.repository.api.RemotePackage;
import com.android.repository.io.FileOp;
import com.android.repository.io.FileOpUtils;
import com.android.sdklib.AndroidVersion;
import com.android.sdklib.repository.AndroidSdkHandler;
import com.android.tools.idea.gradle.util.EmbeddedDistributionPaths;
import com.android.tools.idea.gradle.util.GradleLocalCache;
import com.android.tools.idea.lint.LintIdeClient;
import com.android.tools.idea.model.AndroidModuleInfo;
import com.android.tools.idea.projectsystem.AndroidModuleSystem;
import com.android.tools.idea.projectsystem.GoogleMavenArtifactId;
import com.android.tools.idea.projectsystem.ProjectSystemUtil;
import com.android.tools.idea.sdk.AndroidSdks;
import com.android.tools.idea.sdk.progress.StudioLoggerProgressIndicator;
import com.android.tools.idea.templates.IdeGoogleMavenRepository;
import com.android.tools.idea.templates.OfflineIdeGoogleMavenRepository;
import com.android.tools.lint.checks.GradleDetector;
import com.android.tools.lint.client.api.LintClient;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Multimap;
import com.google.common.collect.Ordering;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import javax.xml.parsers.SAXParserFactory;
import org.apache.commons.io.IOUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class RepositoryUrlManager {
    private static final Logger LOG = Logger.getInstance((String)"#org.jetbrains.android.templates.RepositoryUrlManager");
    private static final String TAG_VERSION = "version";
    public static final String REVISION_ANY = "+";
    private static final Ordering<GradleCoordinate> GRADLE_COORDINATE_ORDERING = Ordering.from((Comparator)GradleCoordinate.COMPARE_PLUS_LOWER);
    private final boolean myForceRepositoryChecksInTests;
    private GoogleMavenRepository myGoogleMavenRepository;
    private GoogleMavenRepository myCachedGoogleMavenRepository;

    public static RepositoryUrlManager get() {
        return (RepositoryUrlManager)ServiceManager.getService(RepositoryUrlManager.class);
    }

    RepositoryUrlManager() {
        this(IdeGoogleMavenRepository.INSTANCE, OfflineIdeGoogleMavenRepository.INSTANCE, false);
    }

    public RepositoryUrlManager(GoogleMavenRepository repository, GoogleMavenRepository localRepository, boolean forceRepositoryChecks) {
        this.myForceRepositoryChecksInTests = forceRepositoryChecks;
        this.myGoogleMavenRepository = repository;
        this.myCachedGoogleMavenRepository = localRepository;
    }

    @Nullable
    public String getArtifactStringCoordinate(GoogleMavenArtifactId artifactId, boolean preview) {
        return this.getArtifactStringCoordinate(artifactId, null, preview);
    }

    @Nullable
    public String getArtifactStringCoordinate(GoogleMavenArtifactId artifactId, @Nullable Predicate<GradleVersion> filter2, boolean preview) {
        String revision = this.getLibraryRevision(artifactId.getMavenGroupId(), artifactId.getMavenArtifactId(), filter2, preview, FileOpUtils.create());
        if (revision == null) {
            return null;
        }
        return artifactId.getCoordinate(revision).toString();
    }

    @Nullable
    public String getLibraryRevision(@NotNull String groupId, @NotNull String artifactId, @Nullable Predicate<GradleVersion> filter2, boolean includePreviews, @NotNull FileOp fileOp) {
        GradleVersion version2;
        if (!ApplicationManager.getApplication().isDispatchThread()) {
            version2 = this.myGoogleMavenRepository.findVersion(groupId, artifactId, filter2, includePreviews);
        } else {
            LOG.warn("RepositoryUrlManager#getLibraryRevision called from the UI thread. Using local cache to avoid network requests");
            version2 = this.myCachedGoogleMavenRepository.findVersion(groupId, artifactId, filter2, includePreviews);
        }
        if (version2 != null) {
            return version2.toString();
        }
        List<File> paths2 = EmbeddedDistributionPaths.getInstance().findAndroidStudioLocalMavenRepoPaths();
        for (File path : paths2) {
            GradleCoordinate versionInEmbedded;
            if (path == null || !path.isDirectory() || (versionInEmbedded = MavenRepositories.getHighestInstalledVersion((String)groupId, (String)artifactId, (File)path, filter2, (boolean)includePreviews, (FileOp)fileOp)) == null) continue;
            return versionInEmbedded.getRevision();
        }
        return null;
    }

    @Nullable
    public File getArchiveForCoordinate(@NotNull GradleCoordinate gradleCoordinate, @NotNull File sdkLocation, @NotNull FileOp fileOp) {
        if (gradleCoordinate.getGroupId() == null || gradleCoordinate.getArtifactId() == null) {
            return null;
        }
        SdkMavenRepository repository = SdkMavenRepository.find((File)sdkLocation, (String)gradleCoordinate.getGroupId(), (String)gradleCoordinate.getArtifactId(), (FileOp)fileOp);
        if (repository == null) {
            return null;
        }
        File repositoryLocation = repository.getRepositoryLocation(sdkLocation, true, fileOp);
        if (repositoryLocation == null) {
            return null;
        }
        File artifactDirectory = MavenRepositories.getArtifactDirectory((File)repositoryLocation, (GradleCoordinate)gradleCoordinate);
        if (!fileOp.isDirectory(artifactDirectory)) {
            return null;
        }
        for (GradleCoordinate.ArtifactType artifactType : ImmutableList.of((Object)GradleCoordinate.ArtifactType.JAR, (Object)GradleCoordinate.ArtifactType.AAR)) {
            File archive = new File(artifactDirectory, String.format("%s-%s.%s", gradleCoordinate.getArtifactId(), gradleCoordinate.getRevision(), artifactType.toString()));
            if (!fileOp.isFile(archive)) continue;
            return archive;
        }
        return null;
    }

    @Nullable
    private static String getLatestVersionFromMavenMetadata(final @NotNull File metadataFile, final @Nullable Predicate<GradleVersion> filter2, final boolean includePreviews, @NotNull FileOp fileOp) throws IOException {
        String xml = fileOp.toString(metadataFile, StandardCharsets.UTF_8);
        final ArrayList versions = new ArrayList();
        try {
            SAXParserFactory.newInstance().newSAXParser().parse(IOUtils.toInputStream((String)xml), new DefaultHandler(){
                boolean inVersionTag = false;

                @Override
                public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
                    if (qName.equals(RepositoryUrlManager.TAG_VERSION)) {
                        this.inVersionTag = true;
                    }
                }

                @Override
                public void characters(char[] ch, int start, int length) throws SAXException {
                    if (this.inVersionTag) {
                        this.inVersionTag = false;
                        String revision = new String(ch, start, length);
                        if ((includePreviews || !"5.2.08".equals(revision) || !metadataFile.getPath().contains(GoogleMavenArtifactId.PLAY_SERVICES.getMavenArtifactId())) && RepositoryUrlManager.applyVersionPredicate(revision, filter2)) {
                            versions.add(GradleCoordinate.parseVersionOnly((String)revision));
                        }
                    }
                }
            });
        }
        catch (Exception e) {
            LOG.warn((Throwable)e);
        }
        if (versions.isEmpty()) {
            return REVISION_ANY;
        }
        if (includePreviews) {
            return ((GradleCoordinate)GRADLE_COORDINATE_ORDERING.max(versions)).getRevision();
        }
        return versions.stream().filter(v -> !v.isPreview()).max((Comparator<GradleCoordinate>)GRADLE_COORDINATE_ORDERING).map(GradleCoordinate::getRevision).orElse(null);
    }

    private static boolean applyVersionPredicate(@NotNull String revision, @Nullable Predicate<GradleVersion> predicate) {
        if (predicate == null) {
            return true;
        }
        GradleVersion version2 = GradleVersion.tryParse((String)revision);
        return version2 != null && predicate.test(version2);
    }

    @Nullable
    public GradleCoordinate resolveDynamicCoordinate(@NotNull GradleCoordinate coordinate, @Nullable Project project) {
        return this.resolveDynamicCoordinate(coordinate, project, AndroidSdks.getInstance().tryToChooseSdkHandler());
    }

    @Nullable
    public GradleCoordinate resolveDynamicCoordinate(@NotNull GradleCoordinate coordinate, @Nullable Project project, @NotNull AndroidSdkHandler sdkHandler) {
        List revisions;
        String version2 = this.resolveDynamicCoordinateVersion(coordinate, project, sdkHandler);
        if (version2 != null && coordinate.getGroupId() != null && coordinate.getArtifactId() != null && !(revisions = GradleCoordinate.parseRevisionNumber((String)version2)).isEmpty()) {
            return new GradleCoordinate(coordinate.getGroupId(), coordinate.getArtifactId(), revisions, coordinate.getArtifactType());
        }
        return null;
    }

    @Nullable
    public String resolveDynamicCoordinateVersion(@NotNull GradleCoordinate coordinate, @Nullable Project project) {
        return this.resolveDynamicCoordinateVersion(coordinate, project, AndroidSdks.getInstance().tryToChooseSdkHandler());
    }

    @Nullable
    String resolveDynamicCoordinateVersion(@NotNull GradleCoordinate coordinate, @Nullable Project project, @NotNull AndroidSdkHandler sdkHandler) {
        String latestString;
        LintIdeClient client;
        GradleVersion latest;
        GradleCoordinate found;
        GradleVersion versionFound;
        String groupId = coordinate.getGroupId();
        String artifactId = coordinate.getArtifactId();
        if (groupId == null || artifactId == null) {
            return null;
        }
        String revision = coordinate.getRevision();
        if (!revision.endsWith(REVISION_ANY)) {
            return revision;
        }
        String versionPrefix = revision.substring(0, revision.length() - 1);
        Predicate<GradleVersion> filter2 = version2 -> version2.toString().startsWith(versionPrefix);
        GradleVersion stable = this.myGoogleMavenRepository.findVersion(groupId, artifactId, filter2, false);
        if (stable != null) {
            return stable.toString();
        }
        GradleVersion version3 = this.myGoogleMavenRepository.findVersion(groupId, artifactId, filter2, true);
        if (version3 != null) {
            return version3.toString();
        }
        File sdkLocation = sdkHandler.getLocation();
        if (sdkLocation != null) {
            String libraryCoordinate = this.getLibraryRevision(groupId, artifactId, filter2, false, sdkHandler.getFileOp());
            if (libraryCoordinate != null) {
                return libraryCoordinate;
            }
            libraryCoordinate = this.getLibraryRevision(groupId, artifactId, filter2, true, sdkHandler.getFileOp());
            if (libraryCoordinate != null) {
                return libraryCoordinate;
            }
        }
        if ((versionFound = GradleLocalCache.getInstance().findLatestArtifactVersion(coordinate, project, revision)) != null) {
            return versionFound.toString();
        }
        StudioLoggerProgressIndicator progress = new StudioLoggerProgressIndicator(this.getClass());
        RemotePackage sdkPackage = SdkMavenRepository.findLatestRemoteVersion((GradleCoordinate)coordinate, (AndroidSdkHandler)sdkHandler, filter2, (ProgressIndicator)progress);
        if (sdkPackage != null && (found = SdkMavenRepository.getCoordinateFromSdkPath((String)sdkPackage.getPath())) != null) {
            return found.getRevision();
        }
        if (project != null && (latest = GradleDetector.getLatestVersionFromRemoteRepo((LintClient)(client = new LintIdeClient(project)), (GradleCoordinate)coordinate, filter2, (boolean)coordinate.isPreview())) != null && (latestString = latest.toString()).startsWith(versionPrefix)) {
            return latestString;
        }
        return null;
    }

    public List<GradleCoordinate> resolveDynamicSdkDependencies(@NotNull Multimap<String, GradleCoordinate> dependencies, @Nullable String supportLibVersionFilter, @NotNull FileOp fileOp) {
        ArrayList<GradleCoordinate> result2 = new ArrayList<GradleCoordinate>(dependencies.size());
        String supportFilter = RepositoryUrlManager.findExistingExplicitVersion(dependencies.values());
        if (supportFilter == null) {
            supportFilter = supportLibVersionFilter;
        }
        for (String key : dependencies.keySet()) {
            String revision;
            GradleCoordinate highest = (GradleCoordinate)Collections.max(dependencies.get((Object)key), GradleCoordinate.COMPARE_PLUS_LOWER);
            if (highest.getGroupId() == null || highest.getArtifactId() == null) {
                return null;
            }
            if ((this.myForceRepositoryChecksInTests || !ApplicationManager.getApplication().isUnitTestMode()) && (revision = highest.getRevision()).endsWith(REVISION_ANY)) {
                String libraryCoordinate;
                GradleCoordinate available;
                String prefix;
                String string = revision = revision.length() > 1 ? revision.substring(0, revision.length() - 1) : null;
                if (("com.android.support".equals(highest.getGroupId()) || "androidx.core".equals(highest.getGroupId())) && revision == null) {
                    revision = supportFilter;
                }
                Predicate<GradleVersion> filter2 = (prefix = revision) != null ? version2 -> version2.toString().startsWith(prefix) : null;
                String version3 = null;
                if (filter2 != null) {
                    version3 = this.getLibraryRevision(highest.getGroupId(), highest.getArtifactId(), filter2, false, fileOp);
                }
                if (version3 == null && filter2 != null) {
                    version3 = this.getLibraryRevision(highest.getGroupId(), highest.getArtifactId(), filter2, true, fileOp);
                }
                if (version3 == null) {
                    version3 = this.getLibraryRevision(highest.getGroupId(), highest.getArtifactId(), null, false, fileOp);
                }
                if (version3 == null) {
                    version3 = this.getLibraryRevision(highest.getGroupId(), highest.getArtifactId(), null, true, fileOp);
                }
                if (version3 != null && (available = GradleCoordinate.parseCoordinateString((String)(libraryCoordinate = highest.getId() + ":" + version3))) != null && GradleCoordinate.COMPARE_PLUS_LOWER.compare(available, highest) >= 0) {
                    highest = available;
                }
            }
            result2.add(highest);
        }
        return result2;
    }

    @Nullable
    public Predicate<GradleVersion> findExistingSupportVersionFilter(@Nullable Module module) {
        if (module == null) {
            return null;
        }
        GradleVersion highest = null;
        AndroidModuleSystem moduleSystem = ProjectSystemUtil.getModuleSystem(module);
        for (GoogleMavenArtifactId artifactId : GoogleMavenArtifactId.values()) {
            GradleVersion version3;
            if (!artifactId.isPlatformSupportLibrary() || !artifactId.getMavenGroupId().equals("com.android.support")) continue;
            GradleCoordinate coordinate = moduleSystem.getResolvedDependency(artifactId.getCoordinate(REVISION_ANY));
            GradleVersion gradleVersion2 = version3 = coordinate != null ? coordinate.getVersion() : null;
            if (version3 == null || highest != null && version3.compareTo(highest) <= 0) continue;
            highest = version3;
        }
        if (highest == null) {
            AndroidVersion compileSdkVersion2;
            AndroidModuleInfo info = AndroidModuleInfo.getInstance(module);
            AndroidVersion androidVersion = compileSdkVersion2 = info != null ? info.getBuildSdkVersion() : null;
            if (compileSdkVersion2 == null) {
                return null;
            }
            String prefix = String.valueOf(compileSdkVersion2.getApiLevel()) + ".";
            return version2 -> version2.toString().startsWith(prefix);
        }
        GradleVersion found = highest;
        String raw = highest.toString();
        if (highest.isPreview() || highest.isSnapshot() || !raw.endsWith(REVISION_ANY)) {
            return version2 -> version2.equals((Object)found);
        }
        String prefix = raw.substring(0, raw.length() - 1);
        return version2 -> version2.toString().startsWith(prefix);
    }

    @Nullable
    public GradleVersion findHighestAndroidxSupportVersion(@Nullable Module module) {
        if (module == null) {
            return null;
        }
        GradleVersion highest = null;
        AndroidModuleSystem moduleSystem = ProjectSystemUtil.getModuleSystem(module);
        for (GoogleMavenArtifactId artifactId : GoogleMavenArtifactId.values()) {
            GradleVersion version2;
            if (!artifactId.isAndroidxPlatformLibrary()) continue;
            GradleCoordinate coordinate = moduleSystem.getResolvedDependency(artifactId.getCoordinate(REVISION_ANY));
            GradleVersion gradleVersion2 = version2 = coordinate != null ? coordinate.getVersion() : null;
            if (version2 == null || highest != null && version2.compareTo(highest) <= 0) continue;
            highest = version2;
        }
        return highest;
    }

    @Nullable
    public Predicate<GradleVersion> findExistingAndroidxSupportVersionFilter(@Nullable GradleVersion highest) {
        if (highest == null) {
            return null;
        }
        String raw = highest.toString();
        if (highest.isPreview() || highest.isSnapshot() || !raw.endsWith(REVISION_ANY)) {
            return version2 -> version2.equals((Object)highest);
        }
        String prefix = raw.substring(0, raw.length() - 1);
        return version2 -> version2.toString().startsWith(prefix);
    }

    @Nullable
    private static String findExistingExplicitVersion(@NotNull Collection<GradleCoordinate> dependencies) {
        Optional<GradleCoordinate> highest = dependencies.stream().filter(coordinate -> "com.android.support".equals(coordinate.getGroupId())).max(GradleCoordinate.COMPARE_PLUS_LOWER);
        if (!highest.isPresent()) {
            return null;
        }
        String version2 = highest.get().getRevision();
        if (version2.endsWith(REVISION_ANY)) {
            return version2.length() > 1 ? version2.substring(0, version2.length() - 1) : null;
        }
        return version2;
    }
}

