/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.templates;

import com.android.tools.idea.templates.FreemarkerConfiguration;
import com.android.tools.idea.templates.FreemarkerUtils;
import freemarker.cache.TemplateLoader;
import freemarker.template.Configuration;
import freemarker.template.Template;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Map;

public class StringEvaluator
implements TemplateLoader {
    private Configuration myFreemarker = new FreemarkerConfiguration();
    private String myCurrentExpression;
    private static final String BOOLEAN_TEMPLATE = "<#if (%s)>true<#else>false</#if>";

    public StringEvaluator() {
        this.myFreemarker.setTemplateLoader((TemplateLoader)this);
    }

    public String evaluate(String expression, Map<String, Object> inputs) {
        try {
            this.myCurrentExpression = expression;
            Template inputsTemplate = this.myFreemarker.getTemplate(expression);
            StringWriter out = new StringWriter();
            Map<String, Object> args = FreemarkerUtils.createParameterMap(inputs);
            inputsTemplate.process(args, (Writer)out);
            out.flush();
            return out.toString();
        }
        catch (Exception e) {
            return null;
        }
    }

    public boolean evaluateBooleanExpression(String expression, Map<String, Object> inputs, boolean defaultValue) {
        try {
            this.myCurrentExpression = String.format(BOOLEAN_TEMPLATE, expression);
            String result2 = this.evaluate(this.myCurrentExpression, inputs);
            return Boolean.parseBoolean(result2);
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public Object findTemplateSource(String name) throws IOException {
        return this.myCurrentExpression;
    }

    public long getLastModified(Object templateSource) {
        return 0L;
    }

    public Reader getReader(Object templateSource, String encoding) throws IOException {
        return new StringReader(this.myCurrentExpression);
    }

    public void closeTemplateSource(Object templateSource) throws IOException {
    }
}

