/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.templates;

import com.android.sdklib.AndroidTargetHash;
import com.android.sdklib.AndroidVersion;
import com.android.tools.idea.npw.assetstudio.icon.AndroidIconType;
import com.android.tools.idea.templates.Parameter;
import com.google.common.base.Function;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class TemplateMetadata {
    public static final String ATTR_PARENT_ACTIVITY_CLASS = "parentActivityClass";
    public static final String ATTR_IS_LAUNCHER = "isLauncher";
    public static final String ATTR_IS_LIBRARY_MODULE = "isLibraryProject";
    public static final String ATTR_CREATE_ICONS = "createIcons";
    public static final String ATTR_COPY_ICONS = "copyIcons";
    public static final String ATTR_TARGET_API = "targetApi";
    public static final String ATTR_TARGET_API_STRING = "targetApiString";
    public static final String ATTR_MIN_API = "minApi";
    public static final String ATTR_MIN_BUILD_API = "minBuildApi";
    public static final String ATTR_REQUIRES_ANDROID_X = "requireAndroidX";
    public static final String ATTR_BUILD_API = "buildApi";
    public static final String ATTR_BUILD_API_STRING = "buildApiString";
    public static final String ATTR_BUILD_API_REVISION = "buildApiRevision";
    public static final String ATTR_HAS_APPLICATION_THEME = "hasApplicationTheme";
    public static final String ATTR_REVISION = "revision";
    public static final String ATTR_MIN_API_LEVEL = "minApiLevel";
    public static final String ATTR_PACKAGE_NAME = "packageName";
    public static final String ATTR_APP_TITLE = "appTitle";
    public static final String ATTR_IS_NEW_PROJECT = "isNewProject";
    public static final String ATTR_THEME_EXISTS = "themeExists";
    public static final String ATTR_IS_GRADLE = "isGradle";
    public static final String ATTR_TOP_OUT = "topOut";
    public static final String ATTR_PROJECT_OUT = "projectOut";
    public static final String ATTR_PROJECT_LOCATION = "projectLocation";
    public static final String ATTR_SRC_OUT = "srcOut";
    public static final String ATTR_RES_OUT = "resOut";
    public static final String ATTR_MANIFEST_OUT = "manifestOut";
    public static final String ATTR_TEST_OUT = "testOut";
    public static final String ATTR_SRC_DIR = "srcDir";
    public static final String ATTR_RES_DIR = "resDir";
    public static final String ATTR_MANIFEST_DIR = "manifestDir";
    public static final String ATTR_TEST_DIR = "testDir";
    public static final String ATTR_AIDL_DIR = "aidlDir";
    public static final String ATTR_AIDL_OUT = "aidlOut";
    public static final String ATTR_DEBUG_KEYSTORE_SHA1 = "debugKeystoreSha1";
    public static final String ATTR_BUILD_TOOLS_VERSION = "buildToolsVersion";
    public static final String ATTR_EXPLICIT_BUILD_TOOLS_VERSION = "explicitBuildToolsVersion";
    public static final String ATTR_GRADLE_PLUGIN_VERSION = "gradlePluginVersion";
    public static final String ATTR_GRADLE_VERSION = "gradleVersion";
    public static final String ATTR_JAVA_VERSION = "javaVersion";
    public static final String ATTR_SDK_DIR = "sdkDir";
    public static final String ATTR_APPLICATION_PACKAGE = "applicationPackage";
    public static final String ATTR_SOURCE_PROVIDER_NAME = "sourceProviderName";
    public static final String ATTR_MODULE_NAME = "projectName";
    public static final String ATTR_MODULE_SIMPLE_NAME = "projectSimpleName";
    public static final String ATTR_CREATE_ACTIVITY = "createActivity";
    public static final String ATTR_INCLUDE_FORM_FACTOR = "included";
    public static final String ATTR_IS_LOW_MEMORY = "isLowMemory";
    public static final String ATTR_NUM_ENABLED_FORM_FACTORS = "NumberOfEnabledFormFactors";
    public static final String ATTR_USE_OFFLINE_REPO = "useOfflineRepo";
    public static final String ATTR_OFFLINE_REPO_PATH = "offlineRepoPath";
    public static final String ATTR_CPP_FLAGS = "cppFlags";
    public static final String ATTR_CPP_SUPPORT = "includeCppSupport";
    public static final String ATTR_DEPENDENCIES_MULTIMAP = "dependenciesMultimap";
    public static final String ATTR_IS_DYNAMIC_FEATURE = "isDynamicFeature";
    public static final String ATTR_DYNAMIC_FEATURE_SUPPORTS_DYNAMIC_DELIVERY = "dynamicFeatureSupportsDynamicDelivery";
    public static final String ATTR_DYNAMIC_FEATURE_INSTALL_TIME_DELIVERY = "dynamicFeatureInstallTimeDelivery";
    public static final String ATTR_DYNAMIC_FEATURE_INSTALL_TIME_WITH_CONDITIONS_DELIVERY = "dynamicFeatureInstallTimeWithConditionsDelivery";
    public static final String ATTR_DYNAMIC_FEATURE_ON_DEMAND_DELIVERY = "dynamicFeatureOnDemandDelivery";
    public static final String ATTR_DYNAMIC_FEATURE_DEVICE_FEATURE_LIST = "dynamicFeatureDeviceFeatureList";
    public static final String ATTR_DYNAMIC_FEATURE_TITLE = "dynamicFeatureTitle";
    public static final String ATTR_DYNAMIC_FEATURE_ON_DEMAND = "dynamicFeatureOnDemand";
    public static final String ATTR_DYNAMIC_FEATURE_FUSING = "dynamicFeatureFusing";
    public static final String ATTR_DYNAMIC_IS_INSTANT_MODULE = "isInstantModule";
    public static final String ATTR_IS_INSTANT_APP = "isInstantApp";
    public static final String ATTR_IS_DYNAMIC_INSTANT_APP = "isDynamicInstantApp";
    public static final String ATTR_HAS_INSTANT_APP_WRAPPER = "hasInstantAppWrapper";
    public static final String ATTR_HAS_MONOLITHIC_APP_WRAPPER = "hasMonolithicAppWrapper";
    public static final String ATTR_MONOLITHIC_MODULE_NAME = "monolithicModuleName";
    public static final String ATTR_INSTANT_APP_PACKAGE_NAME = "instantAppPackageName";
    public static final String ATTR_INSTANT_APP_API_MIN_VERSION = "instantAppApiMinVersion";
    public static final String ATTR_COMPANY_DOMAIN = "companyDomain";
    public static final String ATTR_IS_BASE_FEATURE = "isBaseFeature";
    public static final String ATTR_BASE_FEATURE_NAME = "baseFeatureName";
    public static final String ATTR_BASE_FEATURE_DIR = "baseFeatureDir";
    public static final String ATTR_BASE_FEATURE_RES_DIR = "baseFeatureResDir";
    public static final String ATTR_CLASS_NAME = "className";
    public static final String ATTR_MAKE_IGNORE = "makeIgnore";
    public static final String ATTR_USE_NAV_CONTROLLER = "useNavController";
    public static final String ATTR_KOTLIN_SUPPORT = "includeKotlinSupport";
    public static final String ATTR_ANDROIDX_SUPPORT = "addAndroidXSupport";
    public static final String ATTR_LANGUAGE = "language";
    public static final String ATTR_KOTLIN_VERSION = "kotlinVersion";
    public static final String ATTR_KOTLIN_EAP_REPO = "includeKotlinEapRepo";
    public static final String ATTR_KOTLIN_EAP_REPO_URL = "kotlinEapRepoUrl";
    public static final String KOTLIN_EAP_REPO_URL = "https://dl.bintray.com/kotlin/kotlin-eap";
    public static final String ATTR_APP_THEME_NAME = "name";
    public static final String ATTR_APP_THEME_IS_APP_COMPAT = "isAppCompat";
    public static final String ATTR_APP_THEME_EXISTS = "exists";
    public static final String TAG_CATEGORY = "category";
    public static final String TAG_FORMFACTOR = "formfactor";
    private final Document myDocument;
    private final Map<String, Parameter> myParameterMap;
    private final AndroidIconType myIconType;
    private final String myIconName;
    private String myFormFactor;
    private String myCategory;
    private final Multimap<Parameter, Parameter> myRelatedParameters;

    public TemplateMetadata(@NotNull Document document) {
        Element element;
        NodeList formFactors;
        Element element2;
        this.myDocument = document;
        NodeList parameters2 = this.myDocument.getElementsByTagName("parameter");
        this.myParameterMap = new LinkedHashMap<String, Parameter>(parameters2.getLength());
        int max = parameters2.getLength();
        for (int index = 0; index < max; ++index) {
            element2 = (Element)parameters2.item(index);
            Parameter parameter = new Parameter(this, element2);
            if (parameter.id == null) continue;
            this.myParameterMap.put(parameter.id, parameter);
        }
        NodeList icons = this.myDocument.getElementsByTagName("icons");
        if (icons.getLength() > 0) {
            Element element3 = (Element)icons.item(0);
            if (element3.hasAttribute("type")) {
                String iconTypeName = element3.getAttribute("type").toUpperCase(Locale.US);
                this.myIconType = AndroidIconType.valueOf(iconTypeName);
            } else {
                this.myIconType = null;
            }
            this.myIconName = element3.getAttribute(ATTR_APP_THEME_NAME);
        } else {
            this.myIconType = null;
            this.myIconName = null;
        }
        NodeList categories = this.myDocument.getElementsByTagName(TAG_CATEGORY);
        if (categories.getLength() > 0 && (element2 = (Element)categories.item(0)).hasAttribute("value")) {
            this.myCategory = element2.getAttribute("value");
        }
        if ((formFactors = this.myDocument.getElementsByTagName(TAG_FORMFACTOR)).getLength() > 0 && (element = (Element)formFactors.item(0)).hasAttribute("value")) {
            this.myFormFactor = element.getAttribute("value");
        }
        this.myRelatedParameters = this.computeRelatedParameters();
    }

    private Multimap<Parameter, Parameter> computeRelatedParameters() {
        ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
        for (Parameter p : this.myParameterMap.values()) {
            for (Parameter p2 : this.myParameterMap.values()) {
                if (p == p2 || !p.isRelated(p2)) continue;
                builder.put((Object)p, (Object)p2);
            }
        }
        return builder.build();
    }

    @Nullable
    public String getTitle() {
        return this.getAttrNonEmpty(ATTR_APP_THEME_NAME);
    }

    @Nullable
    public String getDescription() {
        return this.getAttrNonEmpty("description");
    }

    public int getMinSdk() {
        return this.getInteger(ATTR_MIN_API, 1);
    }

    public int getMinBuildApi() {
        return this.getInteger(ATTR_MIN_BUILD_API, 1);
    }

    public boolean getAndroidXRequired() {
        return this.getBoolean(ATTR_REQUIRES_ANDROID_X, false);
    }

    public int getRevision() {
        return this.getInteger(ATTR_REVISION, 1);
    }

    @Nullable
    public String getCategory() {
        return this.myCategory;
    }

    @Nullable
    public String getFormFactor() {
        return this.myFormFactor;
    }

    @Nullable
    public AndroidIconType getIconType() {
        return this.myIconType;
    }

    @Nullable
    public String getIconName() {
        return this.myIconName;
    }

    @Nullable
    public String getThumbnailPath() {
        return this.getThumbnailPath(null);
    }

    @Nullable
    public String getThumbnailPath(Function<String, Object> produceParameterValue) {
        NodeList thumbs = this.myDocument.getElementsByTagName("thumb");
        if (thumbs.getLength() == 0) {
            return null;
        }
        int bestMatchCount = 0;
        Node bestMatch = null;
        int n = thumbs.getLength();
        for (int i2 = 0; i2 < n; ++i2) {
            Element thumb = (Element)thumbs.item(i2);
            NamedNodeMap attributes = thumb.getAttributes();
            if (bestMatch == null && attributes.getLength() == 0) {
                bestMatch = thumb;
                continue;
            }
            if (attributes.getLength() <= bestMatchCount) continue;
            boolean match2 = true;
            int max = attributes.getLength();
            for (int j = 0; j < max; ++j) {
                Attr attribute = (Attr)attributes.item(j);
                String variableName = attribute.getName();
                String thumbNailValue = attribute.getValue();
                if (produceParameterValue != null && thumbNailValue.equals(produceParameterValue.apply((Object)variableName))) continue;
                match2 = false;
                break;
            }
            if (!match2) continue;
            bestMatch = thumb;
            bestMatchCount = attributes.getLength();
        }
        if (bestMatch != null) {
            NodeList children = bestMatch.getChildNodes();
            int n2 = children.getLength();
            for (int i3 = 0; i3 < n2; ++i3) {
                Node child = children.item(i3);
                if (child.getNodeType() != 3) continue;
                return child.getNodeValue().trim();
            }
        }
        return null;
    }

    public boolean isSupported() {
        String versionString = this.myDocument.getDocumentElement().getAttribute("format");
        if (versionString != null && !versionString.isEmpty()) {
            try {
                int version2 = Integer.parseInt(versionString);
                return version2 <= 5;
            }
            catch (NumberFormatException nfe) {
                return false;
            }
        }
        return true;
    }

    public boolean useImplicitRootFolder() {
        String format = this.myDocument.getDocumentElement().getAttribute("format");
        if (format == null || format.isEmpty()) {
            return true;
        }
        try {
            int version2 = Integer.parseInt(format);
            return version2 < 5;
        }
        catch (NumberFormatException ignore) {
            return true;
        }
    }

    @NotNull
    public Collection<Parameter> getParameters() {
        return this.myParameterMap.values();
    }

    @Nullable
    public Parameter getParameter(@NotNull String id) {
        return this.myParameterMap.get(id);
    }

    @Nullable
    private String getAttrNonEmpty(@NotNull String attrName) {
        String attr = this.myDocument.getDocumentElement().getAttribute(attrName);
        return attr == null || attr.isEmpty() ? null : attr;
    }

    private int getInteger(@NotNull String attrName, int defaultValue) {
        try {
            return Integer.parseInt(this.myDocument.getDocumentElement().getAttribute(attrName));
        }
        catch (NumberFormatException nfe) {
            return defaultValue;
        }
        catch (RuntimeException e) {
            return defaultValue;
        }
    }

    private boolean getBoolean(@NotNull String attrName, boolean defaultValue) {
        try {
            return Boolean.parseBoolean(this.myDocument.getDocumentElement().getAttribute(attrName));
        }
        catch (RuntimeException e) {
            return defaultValue;
        }
    }

    @NotNull
    public static String getBuildApiString(@NotNull AndroidVersion version2) {
        return version2.isPreview() ? AndroidTargetHash.getPlatformHashString((AndroidVersion)version2) : version2.getApiString();
    }

    @NotNull
    public Collection<Parameter> getRelatedParams(Parameter param) {
        return this.myRelatedParameters.get((Object)param);
    }
}

