/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.templates;

import com.android.sdklib.AndroidVersion;
import com.android.sdklib.IAndroidTarget;
import com.android.sdklib.SdkVersionInfo;
import com.android.tools.idea.sdk.AndroidSdks;
import com.android.utils.SparseArray;
import com.google.common.base.Charsets;
import com.google.common.io.Files;
import com.intellij.ide.impl.ProjectViewSelectInPaneTarget;
import com.intellij.ide.projectView.ProjectView;
import com.intellij.ide.projectView.impl.AbstractProjectViewPane;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.codeStyle.arrangement.engine.ArrangementEngine;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.regex.Pattern;
import org.jetbrains.android.sdk.AndroidSdkData;
import org.jetbrains.android.sdk.AndroidSdkUtils;
import org.jetbrains.android.uipreview.AndroidEditorSettings;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class TemplateUtils {
    private static final Logger LOG = Logger.getInstance((String)"#org.jetbrains.android.templates.DomUtilities");
    private static final Pattern WINDOWS_NEWLINE = Pattern.compile("\r\n");

    @Nullable
    public static String extractClassName(@NotNull String string) {
        char c;
        int i2;
        StringBuilder sb = new StringBuilder(string.length());
        int n = string.length();
        for (i2 = 0; i2 < n; ++i2) {
            c = Character.toUpperCase(string.charAt(i2));
            if (!Character.isJavaIdentifierStart(c)) continue;
            sb.append(c);
            ++i2;
            break;
        }
        if (sb.length() > 0) {
            while (i2 < n) {
                c = string.charAt(i2);
                if (Character.isJavaIdentifierPart(c)) {
                    sb.append(c);
                }
                ++i2;
            }
            return sb.toString();
        }
        return null;
    }

    public static File stripSuffix(@NotNull File file, @NotNull String suffix) {
        if (file.getName().endsWith(suffix)) {
            String name = file.getName();
            name = name.substring(0, name.length() - suffix.length());
            File parent = file.getParentFile();
            if (parent != null) {
                return new File(parent, name);
            }
            return new File(name);
        }
        return file;
    }

    public static String camelCaseToUnderlines(String string) {
        if (string.isEmpty()) {
            return string;
        }
        StringBuilder sb = new StringBuilder(2 * string.length());
        int n = string.length();
        boolean lastWasUpperCase = Character.isUpperCase(string.charAt(0));
        for (int i2 = 0; i2 < n; ++i2) {
            char c = string.charAt(i2);
            boolean isUpperCase = Character.isUpperCase(c);
            if (isUpperCase && !lastWasUpperCase) {
                sb.append('_');
            }
            lastWasUpperCase = isUpperCase;
            c = Character.toLowerCase(c);
            sb.append(c);
        }
        return sb.toString();
    }

    public static String underlinesToCamelCase(String string) {
        StringBuilder sb = new StringBuilder(string.length());
        int n = string.length();
        boolean upcaseNext = true;
        for (int i2 = 0; i2 < n; ++i2) {
            char c = string.charAt(i2);
            if (c == '_') {
                upcaseNext = true;
                continue;
            }
            if (upcaseNext) {
                c = Character.toUpperCase(c);
            }
            upcaseNext = false;
            sb.append(c);
        }
        return sb.toString();
    }

    @NotNull
    public static String[] getKnownVersions() {
        AndroidSdkData sdkData = AndroidSdks.getInstance().tryToChooseAndroidSdk();
        assert (sdkData != null);
        int max = 28;
        IAndroidTarget[] targets = sdkData.getTargets();
        SparseArray apiTargets = null;
        for (IAndroidTarget target : targets) {
            AndroidVersion version2;
            if (!target.isPlatform() || (version2 = target.getVersion()).isPreview()) continue;
            int apiLevel = version2.getApiLevel();
            max = Math.max(max, apiLevel);
            if (apiLevel <= 29) continue;
            if (apiTargets == null) {
                apiTargets = new SparseArray();
            }
            apiTargets.put(apiLevel, (Object)target);
        }
        String[] versions = new String[max];
        for (int api = 1; api <= max; ++api) {
            String name = SdkVersionInfo.getAndroidName((int)api);
            if (name == null) {
                IAndroidTarget target;
                if (apiTargets != null && (target = (IAndroidTarget)apiTargets.get(api)) != null) {
                    name = AndroidSdkUtils.getTargetLabel(target);
                }
                if (name == null) {
                    name = String.format(Locale.US, "API %1$d", api);
                }
            }
            versions[api - 1] = name;
        }
        return versions;
    }

    @NotNull
    public static List<Element> getChildren(@NotNull Element element) {
        NodeList children = element.getChildNodes();
        ArrayList<Element> result2 = new ArrayList<Element>(children.getLength());
        int n = children.getLength();
        for (int i2 = 0; i2 < n; ++i2) {
            Node node = children.item(i2);
            if (node.getNodeType() != 1) continue;
            Element child = (Element)node;
            result2.add(child);
        }
        return result2;
    }

    public static void reformatAndRearrange(final @NotNull Project project, final @NotNull Iterable<File> files2) {
        WriteCommandAction.runWriteCommandAction((Project)project, (Runnable)new Runnable(){

            @Override
            public void run() {
                LocalFileSystem localFileSystem = LocalFileSystem.getInstance();
                for (File file : files2) {
                    if (!file.isFile()) continue;
                    VirtualFile virtualFile = localFileSystem.findFileByIoFile(file);
                    assert (virtualFile != null);
                    TemplateUtils.reformatAndRearrange(project, virtualFile);
                }
            }
        });
    }

    public static void reformatAndRearrange(@NotNull Project project, @NotNull PsiElement psiElement) {
        TemplateUtils.reformatAndRearrange(project, psiElement.getContainingFile().getVirtualFile(), psiElement, true);
    }

    public static void reformatAndRearrange(@NotNull Project project, @NotNull VirtualFile virtualFile) {
        TemplateUtils.reformatAndRearrange(project, virtualFile, null, false);
    }

    private static void reformatAndRearrange(@NotNull Project project, @NotNull VirtualFile virtualFile, @Nullable PsiElement psiElement, boolean keepDocumentLocked) {
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        if (Objects.equals(virtualFile.getExtension(), "gradle")) {
            return;
        }
        Document document = FileDocumentManager.getInstance().getDocument(virtualFile);
        if (document == null) {
            return;
        }
        PsiDocumentManager psiDocumentManager = PsiDocumentManager.getInstance((Project)project);
        psiDocumentManager.commitDocument(document);
        PsiFile psiFile = psiDocumentManager.getPsiFile(document);
        if (psiFile != null) {
            TextRange textRange = psiElement == null ? psiFile.getTextRange() : psiElement.getTextRange();
            CodeStyleManager.getInstance((Project)project).reformatRange((PsiElement)psiFile, textRange.getStartOffset(), textRange.getEndOffset());
            textRange = psiElement == null ? psiFile.getTextRange() : psiElement.getTextRange();
            psiDocumentManager.doPostponedOperationsAndUnblockDocument(document);
            ((ArrangementEngine)ServiceManager.getService((Project)project, ArrangementEngine.class)).arrange(psiFile, Collections.singleton(textRange));
            if (keepDocumentLocked) {
                psiDocumentManager.commitDocument(document);
            }
        }
    }

    public static boolean openEditors(@NotNull Project project, @NotNull Collection<File> files2, boolean select2) {
        if (!files2.isEmpty()) {
            boolean result2 = true;
            VirtualFile last = null;
            for (File file : files2) {
                if (!file.exists()) continue;
                VirtualFile vFile = VfsUtil.findFileByIoFile((File)file, (boolean)true);
                if (vFile != null) {
                    result2 &= TemplateUtils.openEditor(project, vFile);
                    last = vFile;
                    continue;
                }
                result2 = false;
            }
            if (select2 && last != null) {
                TemplateUtils.selectEditor(project, last);
            }
            return result2;
        }
        return false;
    }

    public static boolean openEditor(@NotNull Project project, @NotNull VirtualFile vFile) {
        OpenFileDescriptor descriptor2 = vFile.getFileType() == StdFileTypes.XML && AndroidEditorSettings.getInstance().getGlobalState().isPreferXmlEditor() ? new OpenFileDescriptor(project, vFile, 0) : new OpenFileDescriptor(project, vFile);
        return !FileEditorManager.getInstance((Project)project).openEditor(descriptor2, true).isEmpty();
    }

    public static void selectEditor(Project project, VirtualFile file) {
        AbstractProjectViewPane currentPane;
        ApplicationManager.getApplication().assertReadAccessAllowed();
        PsiFile psiFile = PsiManager.getInstance((Project)project).findFile(file);
        if (psiFile != null && (currentPane = ProjectView.getInstance((Project)project).getCurrentProjectViewPane()) != null) {
            new ProjectViewSelectInPaneTarget(project, currentPane, true).select((PsiElement)psiFile, false);
        }
    }

    @Nullable
    public static String readTextFromDisk(@NotNull File file, boolean warnIfNotExists) {
        assert (file.isAbsolute());
        try {
            return Files.toString((File)file, (Charset)Charsets.UTF_8);
        }
        catch (IOException e) {
            if (warnIfNotExists) {
                LOG.warn((Throwable)e);
            }
            return null;
        }
    }

    @Nullable
    public static String readTextFromDisk(@NotNull File file) {
        return TemplateUtils.readTextFromDisk(file, true);
    }

    @Nullable
    public static String readTextFromDocument(@NotNull Project project, @NotNull File file) {
        assert (project.isInitialized());
        VirtualFile vFile = LocalFileSystem.getInstance().findFileByIoFile(file);
        if (vFile == null) {
            LOG.debug("Cannot find file " + file.getPath() + " in the VFS");
            return null;
        }
        return TemplateUtils.readTextFromDocument(project, vFile);
    }

    @Nullable
    public static String readTextFromDocument(@NotNull Project project, final @NotNull VirtualFile file) {
        assert (project.isInitialized());
        return (String)ApplicationManager.getApplication().runReadAction((Computable)new Computable<String>(){

            @Nullable
            public String compute() {
                Document document = FileDocumentManager.getInstance().getDocument(file);
                return document != null ? document.getText() : null;
            }
        });
    }

    public static void writeTextFile(@NotNull Object requestor, @Nullable String contents, @NotNull File to) throws IOException {
        Document document;
        if (contents == null) {
            return;
        }
        VirtualFile vf = LocalFileSystem.getInstance().findFileByIoFile(to);
        if (vf == null) {
            VirtualFile parentDir = TemplateUtils.checkedCreateDirectoryIfMissing(to.getParentFile());
            vf = parentDir.createChildData(requestor, to.getName());
        }
        if ((document = FileDocumentManager.getInstance().getDocument(vf)) != null) {
            document.setText((CharSequence)WINDOWS_NEWLINE.matcher(contents).replaceAll("\n"));
            FileDocumentManager.getInstance().saveDocument(document);
        } else {
            vf.setBinaryContent(contents.getBytes(Charsets.UTF_8), -1L, -1L, requestor);
        }
    }

    @NotNull
    public static VirtualFile checkedCreateDirectoryIfMissing(final @NotNull File directory) throws IOException {
        return (VirtualFile)WriteCommandAction.runWriteCommandAction(null, (ThrowableComputable)new ThrowableComputable<VirtualFile, IOException>(){

            public VirtualFile compute() throws IOException {
                VirtualFile dir = VfsUtil.createDirectoryIfMissing((String)directory.getAbsolutePath());
                if (dir == null) {
                    throw new IOException("Unable to create " + directory.getAbsolutePath());
                }
                return dir;
            }
        });
    }

    public static void checkDirectoryIsWriteable(@NotNull File directory) throws IOException {
        while (!directory.exists() || !directory.isDirectory()) {
            directory = directory.getParentFile();
        }
        if (!directory.canWrite()) {
            throw new IOException("Cannot write to folder: " + directory.getAbsolutePath());
        }
    }

    public static boolean hasExtension(File file, String extension) {
        String noDotExtension = extension.startsWith(".") ? extension.substring(1) : extension;
        return Files.getFileExtension((String)file.getName()).equalsIgnoreCase(noDotExtension);
    }
}

