/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.templates;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import java.util.Locale;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.xml.sax.Attributes;

public class TypedVariable {
    private static final Logger LOG = Logger.getInstance(TypedVariable.class);

    @Nullable
    public static Object parse(@NotNull Type type, @Nullable String value2) {
        if (value2 == null) {
            return null;
        }
        switch (type) {
            case STRING: {
                return value2;
            }
            case BOOLEAN: {
                if (Boolean.TRUE.toString().equalsIgnoreCase(value2)) {
                    return Boolean.TRUE;
                }
                if (Boolean.FALSE.toString().equalsIgnoreCase(value2)) {
                    return Boolean.FALSE;
                }
                return null;
            }
            case INTEGER: {
                try {
                    return Integer.parseInt(value2);
                }
                catch (NumberFormatException e) {
                    if (!ApplicationManager.getApplication().isUnitTestMode()) {
                        LOG.error("NumberFormatException while evaluating " + value2);
                    }
                    return null;
                }
            }
        }
        return null;
    }

    @Nullable
    public static Object parseGlobal(@NotNull Attributes attributes) {
        String value2 = attributes.getValue("value");
        Type type = Type.get(attributes.getValue("type"));
        Object result2 = TypedVariable.parse(type, value2);
        return result2 != null ? result2 : value2;
    }

    public static enum Type {
        STRING,
        BOOLEAN,
        INTEGER;


        @NotNull
        public static Type get(@Nullable String name) {
            if (name == null) {
                return STRING;
            }
            try {
                return Type.valueOf(name.toUpperCase(Locale.US));
            }
            catch (IllegalArgumentException e) {
                if (!ApplicationManager.getApplication().isUnitTestMode()) {
                    StringBuilder stringBuilder = new StringBuilder();
                    stringBuilder.append("Unexpected global type '" + name + "'. Expected one of: \n");
                    for (Type s : Type.values()) {
                        stringBuilder.append("   " + s.name().toLowerCase(Locale.US) + "\n");
                    }
                    LOG.error(stringBuilder.toString());
                }
                return STRING;
            }
        }
    }
}

