/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.templates.parse;

import com.android.utils.XmlUtils;
import com.intellij.openapi.util.io.FileUtil;
import java.io.File;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.xml.sax.Attributes;

public final class SaxUtils {
    @Nullable
    public static File getPath(@NotNull Attributes attributes, @NotNull String name) {
        String value2 = attributes.getValue(name);
        if (value2 == null) {
            return null;
        }
        String unescapedString = XmlUtils.fromXmlAttributeValue((String)value2);
        return new File(FileUtil.toSystemDependentName((String)unescapedString));
    }

    @NotNull
    public static String attrOrDefault(@NotNull Attributes attributes, @NotNull String name, @NotNull String defaultValue) {
        String value2 = attributes.getValue(name);
        return value2 != null ? value2 : defaultValue;
    }

    @NotNull
    public static String requireAttr(@NotNull String tag, @NotNull Attributes attributes, @NotNull String name) {
        String result2 = attributes.getValue(name);
        if (result2 == null) {
            throw new RuntimeException(String.format("Required attribute \"%1$s\" not found in element <%2$s %3$s>", name, tag, SaxUtils.attrsToString(attributes)));
        }
        if ("".equals(result2.trim())) {
            throw new RuntimeException(String.format("Required attribute \"%1$s\" found, but empty in element <%2$s %3$s>", name, tag, SaxUtils.attrsToString(attributes)));
        }
        return result2;
    }

    @NotNull
    private static String attrsToString(@NotNull Attributes attributes) {
        StringBuilder builder = new StringBuilder();
        builder.append('[');
        for (int i2 = 0; i2 < attributes.getLength(); ++i2) {
            builder.append(attributes.getQName(i2));
            builder.append('=');
            builder.append(attributes.getValue(i2));
            if (i2 >= attributes.getLength() - 1) continue;
            builder.append("; ");
        }
        builder.append(']');
        return builder.toString();
    }
}

