/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.templates.recipe;

import com.android.tools.idea.templates.recipe.RecipeExecutor;
import com.android.tools.idea.templates.recipe.RenderingContext;
import java.io.File;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;

final class FindReferencesRecipeExecutor
implements RecipeExecutor {
    private final RenderingContext myContext;

    public FindReferencesRecipeExecutor(@NotNull RenderingContext context) {
        this.myContext = context;
    }

    @Override
    public void copy(@NotNull File from, @NotNull File to) {
        if (from.isDirectory()) {
            throw new RuntimeException("Directories not supported for Find References");
        }
        this.addSourceFile(from);
        this.addTargetFile(to);
    }

    @Override
    public void instantiate(@NotNull File from, @NotNull File to) {
        this.addSourceFile(from);
        this.addTargetFile(to);
    }

    @Override
    public void merge(@NotNull File from, @NotNull File to) {
        this.addSourceFile(from);
        this.addTargetFile(to);
    }

    @Override
    public void append(@NotNull File from, @NotNull File to) {
        this.addSourceFile(from);
        this.addTargetFile(to);
    }

    @Override
    public void addGlobalVariable(@NotNull String id, @NotNull Object value2) {
        this.myContext.getParamMap().put(id, value2);
    }

    @Override
    public void mkDir(@NotNull File at) {
    }

    @Override
    public void addFilesToOpen(@NotNull File file) {
        this.myContext.getFilesToOpen().add(this.resolveTargetFile(file));
    }

    @Override
    public void applyPlugin(@NotNull String plugin) {
        this.myContext.getPlugins().add(plugin);
    }

    @Override
    public void addClasspath(@NotNull String mavenUrl) {
        this.myContext.getClasspathEntries().add(mavenUrl);
    }

    @Override
    public void addDependency(@NotNull String configuration, @NotNull String mavenUrl) {
        this.myContext.getDependencies().put((Object)configuration, (Object)mavenUrl);
    }

    @Override
    public void updateAndSync() {
    }

    @Override
    public void pushFolder(@NotNull String folder) {
    }

    @Override
    public void popFolder() {
    }

    public void addSourceFile(@NotNull File file) {
        this.myContext.getSourceFiles().add(this.resolveSourceFile(file));
    }

    public void addTargetFile(@NotNull File file) {
        this.myContext.getTargetFiles().add(this.resolveTargetFile(file));
    }

    private File resolveSourceFile(@NotNull File file) {
        if (file.isAbsolute()) {
            return file;
        }
        try {
            return this.myContext.getLoader().getSourceFile(file);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private File resolveTargetFile(@NotNull File file) {
        if (file.isAbsolute()) {
            return file;
        }
        return new File(this.myContext.getOutputRoot(), file.getPath());
    }
}

