/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.templates.recipe;

import com.android.tools.idea.templates.FreemarkerUtils;
import com.android.tools.idea.templates.TemplateUtils;
import com.android.tools.idea.templates.TypedVariable;
import com.android.tools.idea.templates.parse.StringFileAdapter;
import com.android.tools.idea.templates.recipe.RecipeExecutor;
import com.android.tools.idea.templates.recipe.RecipeInstruction;
import com.google.common.base.MoreObjects;
import com.google.common.collect.Lists;
import java.io.File;
import java.io.Reader;
import java.util.List;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.ValidationEvent;
import javax.xml.bind.ValidationEventHandler;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElements;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@XmlRootElement(name="recipe")
public class Recipe
implements RecipeInstruction {
    @XmlElements(value={@XmlElement(name="copy", type=CopyInstruction.class), @XmlElement(name="instantiate", type=InstantiateInstruction.class), @XmlElement(name="merge", type=MergeInstruction.class), @XmlElement(name="append", type=AppendInstruction.class), @XmlElement(name="mkdir", type=MkDirInstruction.class), @XmlElement(name="open", type=OpenInstruction.class), @XmlElement(name="recipe", type=Recipe.class), @XmlElement(name="global", type=GlobalInstruction.class), @XmlElement(name="apply", type=ApplyInstruction.class), @XmlElement(name="classpath", type=ClasspathInstruction.class), @XmlElement(name="dependency", type=DependencyInstruction.class)})
    private List<RecipeInstruction> instructions = Lists.newArrayList();
    @XmlAttribute(name="folder")
    @Nullable
    private String myFolder;

    public static Recipe parse(@NotNull Reader xmlReader) throws JAXBException {
        Recipe recipe = Recipe.unmarshal(xmlReader);
        recipe.addUpdateAndSyncGradleInstruction();
        return recipe;
    }

    private static Recipe unmarshal(@NotNull Reader xmlReader) throws JAXBException {
        Unmarshaller unmarshaller = JAXBContext.newInstance((Class[])new Class[]{Recipe.class}).createUnmarshaller();
        unmarshaller.setEventHandler(new ValidationEventHandler(){

            public boolean handleEvent(ValidationEvent event) {
                throw new RuntimeException(event.getLinkedException());
            }
        });
        return (Recipe)unmarshaller.unmarshal(xmlReader);
    }

    @NotNull
    private static File cloneWithoutFreemarkerSuffix(@NotNull File file) {
        File clone = new File(file.getPath());
        return TemplateUtils.stripSuffix(clone, ".ftl");
    }

    @Override
    public void execute(@NotNull RecipeExecutor executor) throws FreemarkerUtils.TemplateProcessingException {
        if (this.myFolder == null) {
            this.executeInstructions(executor);
        } else {
            executor.pushFolder(this.myFolder);
            try {
                this.executeInstructions(executor);
            }
            finally {
                executor.popFolder();
            }
        }
    }

    private void executeInstructions(@NotNull RecipeExecutor executor) throws FreemarkerUtils.TemplateProcessingException {
        for (RecipeInstruction instruction : this.instructions) {
            instruction.execute(executor);
        }
    }

    public void addUpdateAndSyncGradleInstruction() {
        this.instructions.add(new UpdateAndSyncInstruction());
    }

    private static final class UpdateAndSyncInstruction
    implements RecipeInstruction {
        private UpdateAndSyncInstruction() {
        }

        @Override
        public void execute(@NotNull RecipeExecutor executor) {
            executor.updateAndSync();
        }
    }

    private static final class GlobalInstruction
    implements RecipeInstruction {
        @XmlAttribute(required=true)
        @NotNull
        private String id;
        @XmlAttribute
        @NotNull
        private String value;
        @XmlAttribute
        private String type;

        private GlobalInstruction() {
        }

        @Override
        public void execute(@NotNull RecipeExecutor executor) {
            TypedVariable.Type typeVariable = TypedVariable.Type.get(this.type);
            Object result2 = TypedVariable.parse(typeVariable, this.value);
            executor.addGlobalVariable(this.id, result2 != null ? result2 : this.value);
        }
    }

    private static final class DependencyInstruction
    implements RecipeInstruction {
        @XmlAttribute(required=true)
        @NotNull
        private String mavenUrl;
        @XmlAttribute
        private String gradleConfiguration;

        private DependencyInstruction() {
        }

        @Override
        public void execute(@NotNull RecipeExecutor executor) {
            String configuration = (String)MoreObjects.firstNonNull((Object)this.gradleConfiguration, (Object)"compile");
            executor.addDependency(configuration, this.mavenUrl);
        }
    }

    private static final class ClasspathInstruction
    implements RecipeInstruction {
        @XmlAttribute(required=true)
        @NotNull
        private String mavenUrl;

        private ClasspathInstruction() {
        }

        @Override
        public void execute(@NotNull RecipeExecutor executor) {
            executor.addClasspath(this.mavenUrl);
        }
    }

    private static final class ApplyInstruction
    implements RecipeInstruction {
        @XmlAttribute(required=true)
        @NotNull
        private String plugin;

        private ApplyInstruction() {
        }

        @Override
        public void execute(@NotNull RecipeExecutor executor) {
            executor.applyPlugin(this.plugin);
        }
    }

    private static final class OpenInstruction
    implements RecipeInstruction {
        @XmlJavaTypeAdapter(value=StringFileAdapter.class)
        @XmlAttribute(required=true)
        @NotNull
        private File file;

        private OpenInstruction() {
        }

        @Override
        public void execute(@NotNull RecipeExecutor executor) {
            executor.addFilesToOpen(this.file);
        }
    }

    private static final class MkDirInstruction
    implements RecipeInstruction {
        @XmlJavaTypeAdapter(value=StringFileAdapter.class)
        @XmlAttribute(required=true)
        @NotNull
        private File at;

        private MkDirInstruction() {
        }

        @Override
        public void execute(@NotNull RecipeExecutor executor) {
            executor.mkDir(this.at);
        }
    }

    private static final class MergeInstruction
    implements RecipeInstruction {
        @XmlJavaTypeAdapter(value=StringFileAdapter.class)
        @XmlAttribute(required=true)
        @NotNull
        private File from;
        @XmlJavaTypeAdapter(value=StringFileAdapter.class)
        @XmlAttribute
        @Nullable
        private File to;

        private MergeInstruction() {
        }

        @Override
        public void execute(@NotNull RecipeExecutor executor) throws FreemarkerUtils.TemplateProcessingException {
            assert (this.to != null);
            executor.merge(this.from, this.to);
        }

        private void afterUnmarshal(Unmarshaller u, Object parent) {
            if (this.to == null || this.to.getPath().isEmpty()) {
                this.to = Recipe.cloneWithoutFreemarkerSuffix(this.from);
            }
        }
    }

    private static final class AppendInstruction
    implements RecipeInstruction {
        @XmlJavaTypeAdapter(value=StringFileAdapter.class)
        @XmlAttribute(required=true)
        @NotNull
        private File from;
        @XmlJavaTypeAdapter(value=StringFileAdapter.class)
        @XmlAttribute
        @NotNull
        private File to;

        private AppendInstruction() {
        }

        @Override
        public void execute(@NotNull RecipeExecutor executor) throws FreemarkerUtils.TemplateProcessingException {
            executor.append(this.from, this.to);
        }
    }

    private static final class InstantiateInstruction
    implements RecipeInstruction {
        @XmlJavaTypeAdapter(value=StringFileAdapter.class)
        @XmlAttribute(required=true)
        @NotNull
        private File from;
        @XmlJavaTypeAdapter(value=StringFileAdapter.class)
        @XmlAttribute
        @Nullable
        private File to;

        private InstantiateInstruction() {
        }

        @Override
        public void execute(@NotNull RecipeExecutor executor) throws FreemarkerUtils.TemplateProcessingException {
            assert (this.to != null);
            executor.instantiate(this.from, this.to);
        }

        private void afterUnmarshal(Unmarshaller u, Object parent) {
            if (this.to == null || this.to.getPath().isEmpty()) {
                this.to = Recipe.cloneWithoutFreemarkerSuffix(this.from);
            }
        }
    }

    private static final class CopyInstruction
    implements RecipeInstruction {
        @XmlJavaTypeAdapter(value=StringFileAdapter.class)
        @XmlAttribute(required=true)
        @NotNull
        private File from;
        @XmlJavaTypeAdapter(value=StringFileAdapter.class)
        @XmlAttribute
        @Nullable
        private File to;

        private CopyInstruction() {
        }

        @Override
        public void execute(@NotNull RecipeExecutor executor) {
            assert (this.to != null);
            executor.copy(this.from, this.to);
        }

        private void afterUnmarshal(Unmarshaller u, Object parent) {
            if (this.to == null || this.to.getPath().isEmpty()) {
                this.to = Recipe.cloneWithoutFreemarkerSuffix(this.from);
            }
        }
    }
}

