/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.testartifacts.junit;

import com.android.tools.idea.IdeInfo;
import com.android.tools.idea.testartifacts.junit.AndroidJUnitConfiguration;
import com.intellij.execution.configuration.ConfigurationFactoryEx;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.execution.configurations.ConfigurationTypeUtil;
import com.intellij.execution.configurations.ModuleBasedConfiguration;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.junit.JUnitConfigurationType;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.ui.LayeredIcon;
import icons.StudioIcons;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public class AndroidJUnitConfigurationType
extends JUnitConfigurationType {
    private static final String ANDROID_JUNIT_DESCRIPTION = "Android JUnit test configuration";
    private static final String ANDROID_JUNIT_NAME = "Android JUnit";
    private static final String ANDROID_JUNIT_ID = "AndroidJUnit";
    private static final NotNullLazyValue<Icon> ANDROID_TEST_ICON = new NotNullLazyValue<Icon>(){

        @NotNull
        protected Icon compute() {
            LayeredIcon icon2 = new LayeredIcon(2);
            icon2.setIcon(StudioIcons.Shell.Filetree.ANDROID_PROJECT, 0);
            icon2.setIcon(AllIcons.Nodes.JunitTestMark, 1);
            return icon2;
        }
    };
    private final ConfigurationFactory myFactory = new ConfigurationFactoryEx((ConfigurationType)this){

        @NotNull
        public RunConfiguration createTemplateConfiguration(@NotNull Project project) {
            AndroidJUnitConfiguration configuration = new AndroidJUnitConfiguration(project, (ConfigurationFactory)this);
            configuration.setVMParameters("-ea");
            configuration.setWorkingDirectory("$MODULE_DIR$");
            return configuration;
        }

        public void onNewConfigurationCreated(@NotNull RunConfiguration configuration) {
            ((ModuleBasedConfiguration)configuration).onNewConfigurationCreated();
        }
    };

    public String getDisplayName() {
        return ANDROID_JUNIT_NAME;
    }

    public String getConfigurationTypeDescription() {
        return ANDROID_JUNIT_DESCRIPTION;
    }

    public Icon getIcon() {
        return IdeInfo.getInstance().isAndroidStudio() ? AllIcons.RunConfigurations.Junit : (Icon)ANDROID_TEST_ICON.getValue();
    }

    public ConfigurationFactory[] getConfigurationFactories() {
        return new ConfigurationFactory[]{this.myFactory};
    }

    @NotNull
    public String getId() {
        return ANDROID_JUNIT_ID;
    }

    @NotNull
    public static AndroidJUnitConfigurationType getInstance() {
        return (AndroidJUnitConfigurationType)ConfigurationTypeUtil.findConfigurationType(AndroidJUnitConfigurationType.class);
    }

    public String getHelpTopic() {
        return "reference.dialogs.rundebug.AndroidJUnit";
    }
}

