/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.testartifacts.junit;

import com.android.tools.idea.AndroidPsiUtils;
import com.android.tools.idea.testartifacts.junit.AndroidJUnitConfigurationProducer;
import com.android.tools.idea.testartifacts.junit.AndroidJUnitConfigurationType;
import com.android.tools.idea.testartifacts.junit.AndroidJUnitConfigurations;
import com.intellij.execution.JavaRunConfigurationExtensionManager;
import com.intellij.execution.Location;
import com.intellij.execution.actions.ConfigurationContext;
import com.intellij.execution.actions.ConfigurationFromContext;
import com.intellij.execution.actions.RunConfigurationProducer;
import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.execution.configurations.JavaRunConfigurationModule;
import com.intellij.execution.configurations.ModuleBasedConfiguration;
import com.intellij.execution.configurations.RunConfigurationBase;
import com.intellij.execution.junit.JUnitConfiguration;
import com.intellij.execution.junit.JUnitConfigurationProducer;
import com.intellij.execution.junit.JUnitUtil;
import com.intellij.execution.junit.PatternConfigurationProducer;
import com.intellij.execution.junit2.PsiMemberParameterizedLocation;
import com.intellij.execution.junit2.info.MethodLocation;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TestMethodAndroidConfigurationProducer
extends JUnitConfigurationProducer
implements AndroidJUnitConfigurationProducer {
    protected TestMethodAndroidConfigurationProducer() {
        super((ConfigurationType)AndroidJUnitConfigurationType.getInstance());
    }

    public boolean isPreferredConfiguration(ConfigurationFromContext self, ConfigurationFromContext other) {
        return super.isPreferredConfiguration(self, other) && AndroidJUnitConfigurations.shouldUseAndroidJUnitConfigurations(self, other);
    }

    public boolean shouldReplace(@NotNull ConfigurationFromContext self, @NotNull ConfigurationFromContext other) {
        return super.isPreferredConfiguration(self, other) && AndroidJUnitConfigurations.shouldUseAndroidJUnitConfigurations(self, other);
    }

    protected boolean setupConfigurationFromContext(JUnitConfiguration configuration, ConfigurationContext context, Ref<PsiElement> sourceElement) {
        if (((PatternConfigurationProducer)RunConfigurationProducer.getInstance(PatternConfigurationProducer.class)).isMultipleElementsSelected(context)) {
            return false;
        }
        Location contextLocation = context.getLocation();
        assert (contextLocation != null);
        PsiMethod method = TestMethodAndroidConfigurationProducer.getTestMethod(contextLocation);
        if (method == null || method.getContainingClass() == null) {
            return false;
        }
        MethodLocation methodLocation = MethodLocation.elementInClass((PsiMethod)method, (PsiClass)method.getContainingClass());
        if (methodLocation == null) {
            return false;
        }
        if (contextLocation instanceof PsiMemberParameterizedLocation) {
            PsiClass containingClass;
            String paramSetName = ((PsiMemberParameterizedLocation)contextLocation).getParamSetName();
            if (paramSetName != null) {
                configuration.setProgramParameters(paramSetName);
            }
            if ((containingClass = ((PsiMemberParameterizedLocation)contextLocation).getContainingClass()) != null) {
                methodLocation = MethodLocation.elementInClass((PsiMethod)((PsiMethod)methodLocation.getPsiElement()), (PsiClass)containingClass);
            }
        }
        sourceElement.set((Object)methodLocation.getPsiElement());
        this.setupConfigurationModule(context, (ModuleBasedConfiguration)configuration);
        Module originalModule = ((JavaRunConfigurationModule)configuration.getConfigurationModule()).getModule();
        configuration.beMethodConfiguration((Location)methodLocation);
        configuration.restoreOriginalModule(originalModule);
        JavaRunConfigurationExtensionManager.getInstance().extendCreatedConfiguration((RunConfigurationBase)configuration, contextLocation);
        configuration.setForkMode("none");
        return true;
    }

    private static PsiMethod getTestMethod(Location<?> location) {
        PsiMethod elementMethod = AndroidPsiUtils.getPsiParentOfType(location.getPsiElement(), PsiMethod.class, false);
        return TestMethodAndroidConfigurationProducer.isTestMethod(elementMethod) ? elementMethod : null;
    }

    private static boolean isTestMethod(@Nullable PsiMethod method) {
        if (method == null) {
            return false;
        }
        PsiClass testClass = method.getContainingClass();
        if (testClass != null && JUnitUtil.isTestClass((PsiClass)testClass)) {
            return new JUnitUtil.TestMethodFilter(testClass).value(method);
        }
        return false;
    }

    public boolean isConfigurationFromContext(JUnitConfiguration unitConfiguration, ConfigurationContext context) {
        return AndroidJUnitConfigurations.isFromContext(unitConfiguration, context, this.getConfigurationFactory());
    }
}

