/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.testartifacts.scopes;

import com.android.builder.model.JavaArtifact;
import com.android.ide.common.gradle.model.IdeAndroidArtifact;
import com.android.ide.common.gradle.model.IdeJavaArtifact;
import com.android.tools.idea.gradle.project.GradleProjectInfo;
import com.android.tools.idea.gradle.project.model.AndroidModuleModel;
import com.android.tools.idea.gradle.project.model.JavaModuleModel;
import com.android.tools.idea.io.FilePaths;
import com.android.tools.idea.testartifacts.scopes.FileRootSearchScope;
import com.android.tools.idea.testartifacts.scopes.TestArtifactSearchScopes;
import com.intellij.execution.JUnitPatcher;
import com.intellij.execution.configurations.JavaParameters;
import com.intellij.openapi.compiler.CompileScope;
import com.intellij.openapi.compiler.CompilerManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.PathsList;
import java.io.File;
import java.util.ArrayList;
import org.jetbrains.android.sdk.AndroidPlatform;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.model.ExtIdeaCompilerOutput;

public class AndroidJunitPatcher
extends JUnitPatcher {
    public void patchJavaParameters(@Nullable Module module, @NotNull JavaParameters javaParameters) {
        if (module == null || !GradleProjectInfo.getInstance(module.getProject()).isBuildWithGradle()) {
            return;
        }
        AndroidModuleModel androidModel = AndroidModuleModel.get(module);
        if (androidModel == null) {
            AndroidJunitPatcher.addFoldersToClasspath(module, null, javaParameters.getClassPath());
            return;
        }
        IdeJavaArtifact testArtifact = androidModel.getSelectedVariant().getUnitTestArtifact();
        if (testArtifact == null) {
            return;
        }
        PathsList classPath = javaParameters.getClassPath();
        TestArtifactSearchScopes testScopes = TestArtifactSearchScopes.get(module);
        if (testScopes == null) {
            return;
        }
        FileRootSearchScope excludeScope = testScopes.getUnitTestExcludeScope();
        for (String path : classPath.getPathList()) {
            if (!excludeScope.accept(new File(path))) continue;
            classPath.remove(path);
        }
        AndroidPlatform platform = AndroidPlatform.getInstance(module);
        if (platform == null) {
            return;
        }
        String originalClassPath = classPath.getPathsString();
        try {
            AndroidJunitPatcher.addRuntimeJarsToClasspath(testArtifact, classPath);
            AndroidJunitPatcher.replaceAndroidJarWithMockableJar(classPath, platform, (JavaArtifact)testArtifact);
            AndroidJunitPatcher.addFoldersToClasspath(module, (JavaArtifact)testArtifact, classPath);
        }
        catch (RuntimeException e) {
            throw new RuntimeException(String.format("Error patching the JUnit class path. Original class path:%n%s", originalClassPath), e);
        }
    }

    private static void replaceAndroidJarWithMockableJar(@NotNull PathsList classPath, @NotNull AndroidPlatform platform, @NotNull JavaArtifact artifact) {
        String androidJarPath = platform.getTarget().getPath(1);
        for (Object entry : classPath.getPathList()) {
            if (!FileUtil.pathsEqual((String)androidJarPath, (String)entry)) continue;
            classPath.remove((String)entry);
        }
        ArrayList<String> mockableJars = new ArrayList<String>();
        for (String path : classPath.getPathList()) {
            if (!FilePaths.toSystemDependentPath((String)path).getName().startsWith("mockable-")) continue;
            mockableJars.add(path);
        }
        for (String mockableJar : mockableJars) {
            classPath.remove(mockableJar);
        }
        File mockableJar = artifact.getMockablePlatformJar();
        if (mockableJar != null) {
            classPath.addTail(mockableJar.getPath());
        } else {
            for (String mockableJarPath : mockableJars) {
                if (!mockableJarPath.endsWith("-" + platform.getApiLevel() + ".jar")) continue;
                classPath.addTail(mockableJarPath);
                return;
            }
        }
    }

    private static void addFoldersToClasspath(@NotNull Module module, @Nullable JavaArtifact testArtifact, @NotNull PathsList classPath) {
        CompilerManager compilerManager = CompilerManager.getInstance((Project)module.getProject());
        CompileScope scope = compilerManager.createModulesCompileScope(new Module[]{module}, true, true);
        if (testArtifact != null) {
            classPath.add(testArtifact.getJavaResourcesFolder());
            for (File additionalTestClasses : testArtifact.getAdditionalClassesFolders()) {
                classPath.add(additionalTestClasses);
            }
        }
        FileRootSearchScope excludeScope = null;
        TestArtifactSearchScopes testScopes = TestArtifactSearchScopes.get(module);
        if (testScopes != null) {
            excludeScope = testScopes.getUnitTestExcludeScope();
        }
        for (Module affectedModule : scope.getAffectedModules()) {
            File kotlinClasses;
            File javaMainResources;
            File javaTestResources;
            JavaModuleModel javaModel;
            AndroidModuleModel affectedAndroidModel = AndroidModuleModel.get(affectedModule);
            if (affectedAndroidModel != null) {
                IdeAndroidArtifact mainArtifact = affectedAndroidModel.getMainArtifact();
                AndroidJunitPatcher.addToClasspath(mainArtifact.getJavaResourcesFolder(), classPath, excludeScope);
                for (File additionalClassesFolder : mainArtifact.getAdditionalClassesFolders()) {
                    AndroidJunitPatcher.addToClasspath(additionalClassesFolder, classPath, excludeScope);
                }
            }
            if ((javaModel = JavaModuleModel.get(affectedModule)) == null) continue;
            ExtIdeaCompilerOutput output = javaModel.getCompilerOutput();
            File file = javaTestResources = output == null ? null : output.getTestResourcesDir();
            if (javaTestResources != null) {
                AndroidJunitPatcher.addToClasspath(javaTestResources, classPath, excludeScope);
            }
            File file2 = javaMainResources = output == null ? null : output.getMainResourcesDir();
            if (javaMainResources != null) {
                AndroidJunitPatcher.addToClasspath(javaMainResources, classPath, excludeScope);
            }
            if (javaModel.getBuildFolderPath() == null || !(kotlinClasses = javaModel.getBuildFolderPath().toPath().resolve("classes").resolve("kotlin").toFile()).exists()) continue;
            AndroidJunitPatcher.addToClasspath(new File(kotlinClasses, "main"), classPath, excludeScope);
            AndroidJunitPatcher.addToClasspath(new File(kotlinClasses, "test"), classPath, excludeScope);
        }
    }

    private static void addToClasspath(@NotNull File folder, @NotNull PathsList classPath, @Nullable FileRootSearchScope excludeScope) {
        if (excludeScope != null && excludeScope.accept(folder)) {
            return;
        }
        classPath.add(folder);
    }

    private static void addRuntimeJarsToClasspath(@NotNull IdeJavaArtifact testArtifact, @NotNull PathsList classPath) {
        for (File runtimeClasspath : testArtifact.getLevel2Dependencies().getRuntimeOnlyClasses()) {
            classPath.add(runtimeClasspath);
        }
    }
}

