/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.testartifacts.scopes;

import com.android.tools.idea.testartifacts.scopes.FileRootSearchScope;
import com.android.tools.idea.testartifacts.scopes.TestArtifactSearchScopes;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.TestSourcesFilter;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.ResolveScopeProvider;
import com.intellij.psi.search.GlobalSearchScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TestArtifactResolveScopeProvider
extends ResolveScopeProvider {
    @Nullable
    public GlobalSearchScope getResolveScope(@NotNull VirtualFile file, @Nullable Project project) {
        FileRootSearchScope excludeScope;
        if (project == null) {
            return null;
        }
        if (!TestSourcesFilter.isTestSources((VirtualFile)file, (Project)project)) {
            return null;
        }
        TestArtifactSearchScopes testScopes = TestArtifactSearchScopes.get(file, project);
        if (testScopes == null) {
            return null;
        }
        GlobalSearchScope scope = GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)testScopes.getModule(), (boolean)true);
        boolean inAndroidTest = testScopes.isAndroidTestSource(file);
        boolean inUnitTest = testScopes.isUnitTestSource(file);
        if (inAndroidTest && inUnitTest) {
            excludeScope = testScopes.getSharedTestsExcludeScope();
        } else if (inAndroidTest) {
            excludeScope = testScopes.getAndroidTestExcludeScope();
        } else if (inUnitTest) {
            excludeScope = testScopes.getUnitTestExcludeScope();
        } else {
            return null;
        }
        return scope.intersectWith(GlobalSearchScope.notScope((GlobalSearchScope)excludeScope));
    }
}

