/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.transport;

import com.intellij.openapi.application.PathManager;
import java.io.File;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DeployableFile {
    @NotNull
    private final String myFileName;
    @NotNull
    private final String myReleaseDir;
    @NotNull
    private final String myDevDir;
    @Nullable
    private final String myOnDeviceAbiFileNameFormat;
    private final boolean myExecutable;
    @NotNull
    private final Supplier<String> myHomePathSupplier;

    private DeployableFile(@NotNull Builder builder) {
        this.myFileName = builder.myFileName;
        this.myReleaseDir = builder.myReleaseDir;
        this.myDevDir = builder.myDevDir;
        this.myOnDeviceAbiFileNameFormat = builder.myOnDeviceAbiFileNameFormat;
        this.myHomePathSupplier = builder.myHomePathSupplier;
        this.myExecutable = builder.myExecutable;
    }

    @NotNull
    public String getFileName() {
        return this.myFileName;
    }

    public boolean isExecutable() {
        return this.myExecutable;
    }

    public boolean isAbiDependent() {
        return this.myOnDeviceAbiFileNameFormat != null;
    }

    @Nullable
    public String getOnDeviceAbiFileNameFormat() {
        return this.myOnDeviceAbiFileNameFormat;
    }

    @NotNull
    public File getDir() {
        File dir = new File(this.myHomePathSupplier.get(), this.myReleaseDir);
        if (!dir.exists()) {
            dir = new File(this.myHomePathSupplier.get(), this.myDevDir);
        }
        return dir;
    }

    public static class Builder {
        @NotNull
        private final String myFileName;
        @NotNull
        private String myReleaseDir = "plugins/android/resources";
        @NotNull
        private String myDevDir = "../../bazel-genfiles/tools/base/profiler/app";
        @Nullable
        private String myOnDeviceAbiFileNameFormat;
        @NotNull
        private Supplier<String> myHomePathSupplier = () -> PathManager.getHomePath();
        private boolean myExecutable = false;

        public Builder(@NotNull String fileName) {
            this.myFileName = fileName;
        }

        @NotNull
        public Builder setReleaseDir(@NotNull String releaseDir) {
            this.myReleaseDir = releaseDir;
            return this;
        }

        @NotNull
        public Builder setDevDir(@NotNull String devDir) {
            this.myDevDir = devDir;
            return this;
        }

        @NotNull
        public Builder setExecutable(boolean executable) {
            this.myExecutable = executable;
            return this;
        }

        @NotNull
        public Builder setOnDeviceAbiFileNameFormat(@NotNull String format) {
            this.myOnDeviceAbiFileNameFormat = format;
            return this;
        }

        @NotNull
        public Builder setHomePathSupplier(Supplier<String> pathSupplier) {
            this.myHomePathSupplier = pathSupplier;
            return this;
        }

        @NotNull
        public DeployableFile build() {
            return new DeployableFile(this);
        }
    }
}

