/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.transport;

import io.grpc.ClientCall;
import io.grpc.MethodDescriptor;
import io.grpc.ServerCallHandler;
import io.grpc.ServerServiceDefinition;
import io.grpc.ServiceDescriptor;
import io.grpc.stub.AbstractStub;
import io.grpc.stub.ClientCalls;
import io.grpc.stub.ServerCalls;
import io.grpc.stub.StreamObserver;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import sun.reflect.generics.reflectiveObjects.NotImplementedException;

public abstract class ServiceProxy {
    private final ServiceDescriptor myServiceDescriptor;

    public ServiceProxy(@NotNull ServiceDescriptor serviceDescriptor) {
        this.myServiceDescriptor = serviceDescriptor;
    }

    public abstract ServerServiceDefinition getServiceDefinition();

    public void disconnect() {
    }

    protected final ServerServiceDefinition generatePassThroughDefinitions(@NotNull Map<MethodDescriptor, ServerCallHandler> overrides, @NotNull AbstractStub blockingStub) {
        ServerServiceDefinition.Builder builder = ServerServiceDefinition.builder((ServiceDescriptor)this.myServiceDescriptor);
        overrides.forEach((method, handler) -> builder.addMethod(method, handler));
        this.myServiceDescriptor.getMethods().forEach(descriptor2 -> {
            if (overrides.containsKey(descriptor2)) {
                return;
            }
            switch (descriptor2.getType()) {
                case UNARY: {
                    builder.addMethod(descriptor2, ServerCalls.asyncUnaryCall((request, observer) -> this.invokeAsyncUnaryCalls((MethodDescriptor)descriptor2, blockingStub, (Object)request, (StreamObserver)observer)));
                    break;
                }
                case CLIENT_STREAMING: 
                case SERVER_STREAMING: 
                case BIDI_STREAMING: 
                case UNKNOWN: {
                    throw new NotImplementedException();
                }
            }
        });
        return builder.build();
    }

    private <Req, Resp> void invokeAsyncUnaryCalls(@NotNull MethodDescriptor descriptor2, @NotNull AbstractStub stubInstance, Req request, @NotNull StreamObserver<Resp> observer) {
        ClientCalls.asyncUnaryCall((ClientCall)stubInstance.getChannel().newCall(descriptor2, stubInstance.getCallOptions()), request, observer);
    }
}

