/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.transport;

import com.android.ddmlib.AdbCommandRejectedException;
import com.android.ddmlib.AndroidDebugBridge;
import com.android.ddmlib.IDevice;
import com.android.ddmlib.IShellOutputReceiver;
import com.android.ddmlib.ShellCommandUnresponsiveException;
import com.android.ddmlib.SyncException;
import com.android.ddmlib.TimeoutException;
import com.android.tools.analytics.UsageTracker;
import com.android.tools.datastore.DataStoreService;
import com.android.tools.idea.run.AndroidRunConfigurationBase;
import com.android.tools.idea.stats.AndroidStudioUsageTracker;
import com.android.tools.idea.transport.TransportFileManager;
import com.android.tools.idea.transport.TransportProxy;
import com.android.tools.idea.transport.TransportServiceProxy;
import com.android.tools.profiler.proto.Agent;
import com.android.tools.profiler.proto.Common;
import com.android.tools.profiler.proto.Transport;
import com.google.common.base.Charsets;
import com.google.wireless.android.sdk.stats.AndroidProfilerEvent;
import com.google.wireless.android.sdk.stats.AndroidStudioEvent;
import com.google.wireless.android.sdk.stats.PerfdCrashInfo;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.messages.MessageBus;
import com.intellij.util.messages.Topic;
import com.intellij.util.net.NetUtils;
import io.grpc.ManagedChannel;
import io.grpc.inprocess.InProcessChannelBuilder;
import io.grpc.internal.ManagedChannelImpl;
import io.grpc.netty.NettyChannelBuilder;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;

public final class TransportDeviceManager
implements AndroidDebugBridge.IDebugBridgeChangeListener,
AndroidDebugBridge.IDeviceChangeListener,
Disposable {
    public static final Topic<TransportDeviceManagerListener> TOPIC = new Topic("TransportDevice", TransportDeviceManagerListener.class);
    private static final String BOOT_COMPLETE_PROPERTY = "dev.bootcomplete";
    private static final String BOOT_COMPLETE_MESSAGE = "1";
    private static final int MAX_MESSAGE_SIZE = 0x1FFFFFFF;
    private static final int DEVICE_PORT = 12389;
    public static final String DEVICE_SOCKET_NAME = "AndroidStudioTransport";
    @NotNull
    private final DataStoreService myDataStoreService;
    @NotNull
    private final MessageBus myMessageBus;
    private final Map<String, DeviceContext> mySerialToDeviceContextMap = new ConcurrentHashMap<String, DeviceContext>();

    private static Logger getLogger() {
        return Logger.getInstance(TransportDeviceManager.class);
    }

    public TransportDeviceManager(@NotNull DataStoreService dataStoreService, @NotNull MessageBus messageBus) {
        this.myDataStoreService = dataStoreService;
        this.myMessageBus = messageBus;
        AndroidDebugBridge.addDebugBridgeChangeListener((AndroidDebugBridge.IDebugBridgeChangeListener)this);
        AndroidDebugBridge.addDeviceChangeListener((AndroidDebugBridge.IDeviceChangeListener)this);
    }

    public void dispose() {
        AndroidDebugBridge.removeDebugBridgeChangeListener((AndroidDebugBridge.IDebugBridgeChangeListener)this);
        AndroidDebugBridge.removeDeviceChangeListener((AndroidDebugBridge.IDeviceChangeListener)this);
        this.disconnectProxies();
    }

    public void bridgeChanged(AndroidDebugBridge bridge) {
        if (bridge != null) {
            for (IDevice device : bridge.getDevices()) {
                this.deviceConnected(device);
            }
        } else {
            this.disconnectProxies();
        }
    }

    public void deviceConnected(IDevice device) {
        this.mySerialToDeviceContextMap.computeIfAbsent(device.getSerialNumber(), serial -> new DeviceContext());
        if (device.isOnline()) {
            this.spawnTransportThread(device);
        }
    }

    private static boolean isAtLeastO(IDevice device) {
        return device.getVersion().getFeatureLevel() >= 26;
    }

    public void deviceDisconnected(IDevice device) {
        this.disconnectProxy(device);
    }

    public void deviceChanged(IDevice device, int changeMask) {
        if ((changeMask & 1) != 0) {
            if (device.isOnline()) {
                this.spawnTransportThread(device);
            } else {
                this.disconnectProxy(device);
            }
        }
    }

    @NotNull
    private Runnable getDisconnectRunnable(@NotNull String serialNumber) {
        return () -> this.mySerialToDeviceContextMap.compute(serialNumber, (unused, context) -> {
            assert (context != null);
            TransportProxy proxy = context.myLastKnownTransportProxy;
            if (proxy != null) {
                proxy.disconnect();
            }
            context.myLastKnownTransportProxy = null;
            if (context.myDevice != null) {
                this.myDataStoreService.disconnect(context.myDevice.getDeviceId());
            }
            context.myDevice = null;
            return context;
        });
    }

    private void disconnectProxy(IDevice device) {
        this.mySerialToDeviceContextMap.compute(device.getSerialNumber(), (serial, context) -> {
            assert (context != null);
            if (context.myLastKnownTransportThreadFuture != null) {
                context.myLastKnownTransportThreadFuture.cancel(true);
                context.myLastKnownTransportThreadFuture = null;
            }
            context.myExecutor.execute(this.getDisconnectRunnable((String)serial));
            return context;
        });
    }

    private void disconnectProxies() {
        this.mySerialToDeviceContextMap.forEach((serial, context) -> {
            assert (context != null);
            if (context.myLastKnownTransportThreadFuture != null) {
                context.myLastKnownTransportThreadFuture.cancel(true);
                context.myLastKnownTransportThreadFuture = null;
            }
            context.myExecutor.execute(this.getDisconnectRunnable((String)serial));
        });
    }

    private void spawnTransportThread(IDevice device) {
        TransportThread transportThread = new TransportThread(device, this.myDataStoreService, this.myMessageBus, this.mySerialToDeviceContextMap);
        this.mySerialToDeviceContextMap.compute(device.getSerialNumber(), (serial, context) -> {
            assert (context != null && (context.myLastKnownTransportProxy == null || context.myLastKnownTransportProxy.getDevice() != device));
            context.myLastKnownTransportThreadFuture = context.myExecutor.submit(transportThread);
            return context;
        });
    }

    public static interface TransportDeviceManagerListener {
        public void onPreTransportDaemonStart(@NotNull Common.Device var1);

        public void onStartTransportDaemonFail(@NotNull Common.Device var1, @NotNull Exception var2);

        public void onTransportProxyCreationFail(@NotNull Common.Device var1, @NotNull Exception var2);

        public void customizeProxyService(@NotNull TransportProxy var1);

        public void customizeDaemonConfig(@NotNull Transport.DaemonConfig.Builder var1);

        public void customizeAgentConfig(@NotNull Agent.AgentConfig.Builder var1, AndroidRunConfigurationBase var2);
    }

    private static class DeviceContext {
        @NotNull
        public final ExecutorService myExecutor = new ThreadPoolExecutor(0, 1, 1L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>());
        public TransportProxy myLastKnownTransportProxy;
        public Future<?> myLastKnownTransportThreadFuture;
        public Common.Device myDevice;

        private DeviceContext() {
        }
    }

    private static final class TransportThread
    implements Runnable {
        @NotNull
        private final DataStoreService myDataStore;
        @NotNull
        private final IDevice myDevice;
        @NotNull
        private final MessageBus myMessageBus;
        private volatile TransportProxy myTransportProxy;
        private final Map<String, DeviceContext> mySerialToDeviceContextMap;

        private TransportThread(@NotNull IDevice device, @NotNull DataStoreService datastore, @NotNull MessageBus messageBus, @NotNull Map<String, DeviceContext> serialToDeviceContextMap) {
            this.myDataStore = datastore;
            this.myMessageBus = messageBus;
            this.myDevice = device;
            this.mySerialToDeviceContextMap = serialToDeviceContextMap;
        }

        @Override
        public void run() {
            Common.Device transportDevice = Common.Device.getDefaultInstance();
            try {
                if (!this.waitForBootComplete()) {
                    throw new TimeoutException("Timed out waiting for device to be ready.");
                }
                transportDevice = TransportServiceProxy.transportDeviceFromIDevice(this.myDevice);
                ((TransportDeviceManagerListener)this.myMessageBus.syncPublisher(TOPIC)).onPreTransportDaemonStart(transportDevice);
                TransportFileManager fileManager = new TransportFileManager(this.myDevice, this.myMessageBus);
                fileManager.copyFilesToDevice();
                this.startTransportDaemon(transportDevice);
                TransportDeviceManager.getLogger().info("Terminating Transport thread");
            }
            catch (ShellCommandUnresponsiveException | SyncException e) {
                ((TransportDeviceManagerListener)this.myMessageBus.syncPublisher(TOPIC)).onStartTransportDaemonFail(transportDevice, (Exception)e);
                TransportDeviceManager.getLogger().error("Error when trying to spawn Transport daemon", e);
            }
            catch (AdbCommandRejectedException | IOException e) {
                TransportDeviceManager.getLogger().warn("Error when trying to spawn Transport", e);
                ((TransportDeviceManagerListener)this.myMessageBus.syncPublisher(TOPIC)).onStartTransportDaemonFail(transportDevice, (Exception)e);
            }
            catch (TimeoutException | InterruptedException e) {
                ((TransportDeviceManagerListener)this.myMessageBus.syncPublisher(TOPIC)).onStartTransportDaemonFail(transportDevice, (Exception)e);
            }
        }

        private void startTransportDaemon(final @NotNull Common.Device transportDevice) throws TimeoutException, AdbCommandRejectedException, ShellCommandUnresponsiveException, IOException {
            String command = TransportFileManager.getTransportExecutablePath() + " -config_file=" + TransportFileManager.getDaemonConfigPath();
            TransportDeviceManager.getLogger().info("[Transport]: Executing " + command);
            this.myDevice.executeShellCommand(command, new IShellOutputReceiver(){

                public void addOutput(byte[] data, int offset, int length) {
                    String s = new String(data, offset, length, Charsets.UTF_8);
                    if (s.contains("Perfd Segmentation Fault:")) {
                        this.reportTransportSegmentationFault(s);
                    }
                    TransportDeviceManager.getLogger().info("[Transport]: " + s);
                    if (myDevice.getVersion().getApiLevel() >= 21 && !s.startsWith("Server listening on")) {
                        return;
                    }
                    boolean[] alreadyExists = new boolean[]{false};
                    mySerialToDeviceContextMap.compute(myDevice.getSerialNumber(), (serial, context) -> {
                        assert (context != null);
                        if (context.myLastKnownTransportProxy != null) {
                            TransportDeviceManager.getLogger().info(String.format("TransportProxy was already created for device: %s", myDevice));
                            alreadyExists[0] = true;
                        }
                        return context;
                    });
                    if (alreadyExists[0]) {
                        return;
                    }
                    try {
                        this.createTransportProxy(transportDevice);
                        TransportDeviceManager.getLogger().info(String.format("TransportProxy successfully created for device: %s", myDevice));
                    }
                    catch (AdbCommandRejectedException | TimeoutException | IOException e) {
                        ((TransportDeviceManagerListener)myMessageBus.syncPublisher(TOPIC)).onTransportProxyCreationFail(transportDevice, (Exception)e);
                        TransportDeviceManager.getLogger().error(String.format("TransportProxy failed for device: %s", myDevice), e);
                    }
                }

                public void flush() {
                }

                public boolean isCancelled() {
                    if (Thread.interrupted()) {
                        Thread.currentThread().interrupt();
                        return true;
                    }
                    return false;
                }
            }, 0L, null);
        }

        private void createTransportProxy(@NotNull Common.Device transportDevice) throws TimeoutException, AdbCommandRejectedException, IOException {
            int localPort = NetUtils.findAvailableSocketPort();
            if (localPort < 0) {
                throw new RuntimeException("Unable to find available socket port");
            }
            if (TransportDeviceManager.isAtLeastO(this.myDevice)) {
                this.myDevice.createForward(localPort, TransportDeviceManager.DEVICE_SOCKET_NAME, IDevice.DeviceUnixSocketNamespace.ABSTRACT);
            } else {
                this.myDevice.createForward(localPort, 12389);
            }
            TransportDeviceManager.getLogger().info(String.format("Port forwarding created for port: %d", localPort));
            ClassLoader stashedContextClassLoader = Thread.currentThread().getContextClassLoader();
            Thread.currentThread().setContextClassLoader(NettyChannelBuilder.class.getClassLoader());
            ManagedChannelImpl transportChannel = NettyChannelBuilder.forAddress((String)"localhost", (int)localPort).usePlaintext(true).maxMessageSize(0x1FFFFFFF).build();
            Thread.currentThread().setContextClassLoader(stashedContextClassLoader);
            String channelName = this.myDevice.getSerialNumber();
            this.myTransportProxy = new TransportProxy(this.myDevice, transportDevice, (ManagedChannel)transportChannel);
            ((TransportDeviceManagerListener)this.myMessageBus.syncPublisher(TOPIC)).customizeProxyService(this.myTransportProxy);
            this.myTransportProxy.initializeProxyServer(channelName);
            try {
                this.myTransportProxy.connect();
            }
            catch (IOException exception) {
                this.myTransportProxy.disconnect();
                throw exception;
            }
            this.mySerialToDeviceContextMap.compute(this.myDevice.getSerialNumber(), (serial, context) -> {
                assert (context != null);
                context.myLastKnownTransportProxy = this.myTransportProxy;
                context.myDevice = transportDevice;
                return context;
            });
            ManagedChannelImpl proxyChannel = InProcessChannelBuilder.forName((String)channelName).build();
            this.myDataStore.connect(Common.Stream.newBuilder().setStreamId(transportDevice.getDeviceId()).setType(Common.Stream.Type.DEVICE).setDevice(transportDevice).build(), (ManagedChannel)proxyChannel);
        }

        private boolean waitForBootComplete() throws InterruptedException {
            for (int i2 = 0; i2 < 60; ++i2) {
                String state = this.myDevice.getProperty(TransportDeviceManager.BOOT_COMPLETE_PROPERTY);
                if (TransportDeviceManager.BOOT_COMPLETE_MESSAGE.equals(state)) {
                    return true;
                }
                Thread.sleep(TimeUnit.SECONDS.toMillis(1L));
            }
            return false;
        }

        private void reportTransportSegmentationFault(String crashString) {
            PerfdCrashInfo.Builder crashInfo = PerfdCrashInfo.newBuilder();
            String[] stack = crashString.split("[:,]+");
            for (int i2 = 1; i2 < stack.length; ++i2) {
                crashInfo.addBackstackAddressList(Long.parseLong(stack[i2].trim()));
            }
            AndroidStudioEvent.Builder event = AndroidStudioEvent.newBuilder().setKind(AndroidStudioEvent.EventKind.ANDROID_PROFILER).setDeviceInfo(AndroidStudioUsageTracker.deviceToDeviceInfo(this.myDevice)).setAndroidProfilerEvent(AndroidProfilerEvent.newBuilder().setType(AndroidProfilerEvent.Type.PERFD_CRASHED).setPerfdCrashInfo(crashInfo));
            UsageTracker.log((AndroidStudioEvent.Builder)event);
        }
    }
}

