/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.transport;

import com.android.ddmlib.AdbCommandRejectedException;
import com.android.ddmlib.IDevice;
import com.android.ddmlib.IShellOutputReceiver;
import com.android.ddmlib.MultiLineReceiver;
import com.android.ddmlib.NullOutputReceiver;
import com.android.ddmlib.ShellCommandUnresponsiveException;
import com.android.ddmlib.SyncException;
import com.android.ddmlib.TimeoutException;
import com.android.sdklib.devices.Abi;
import com.android.tools.idea.run.AndroidRunConfigurationBase;
import com.android.tools.idea.transport.DeployableFile;
import com.android.tools.idea.transport.TransportDeviceManager;
import com.android.tools.profiler.proto.Agent;
import com.android.tools.profiler.proto.Common;
import com.android.tools.profiler.proto.Transport;
import com.google.common.base.Charsets;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.messages.MessageBus;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class TransportFileManager {
    static final String DEVICE_DIR = "/data/local/tmp/perfd/";
    private static final String CODE_CACHE_DIR = "code_cache";
    private static final String DAEMON_CONFIG_FILE = "daemon.config";
    private static final String AGENT_CONFIG_FILE = "agent.config";
    private static final int DEVICE_PORT = 12389;
    @NotNull
    private final IDevice myDevice;
    @NotNull
    private final MessageBus myMessageBus;

    private static Logger getLogger() {
        return Logger.getInstance(TransportFileManager.class);
    }

    public TransportFileManager(@NotNull IDevice device, @NotNull MessageBus messageBus) {
        this.myDevice = device;
        this.myMessageBus = messageBus;
    }

    public void copyFilesToDevice() throws AdbCommandRejectedException, IOException, ShellCommandUnresponsiveException, SyncException, TimeoutException {
        this.copyFileToDevice(HostFiles.TRANSPORT);
        if (TransportFileManager.isAtLeastO(this.myDevice)) {
            this.copyFileToDevice(HostFiles.PERFA);
            this.copyFileToDevice(HostFiles.PERFA_OKHTTP);
            this.copyFileToDevice(HostFiles.JVMTI_AGENT);
            this.copyFileToDevice(HostFiles.SIMPLEPERF);
        }
        if (TransportFileManager.isAtLeastP(this.myDevice)) {
            this.copyFileToDevice(HostFiles.PERFETTO);
            this.copyFileToDevice(HostFiles.PERFETTO_SO);
            this.copyFileToDevice(HostFiles.TRACED);
            this.copyFileToDevice(HostFiles.TRACED_PROBE);
        }
        this.pushDaemonConfig();
        this.pushAgentConfig(AGENT_CONFIG_FILE, null);
    }

    @NotNull
    static String getTransportExecutablePath() {
        return DEVICE_DIR + HostFiles.TRANSPORT.getFileName();
    }

    @NotNull
    public static String getDaemonConfigPath() {
        return "/data/local/tmp/perfd/daemon.config";
    }

    @NotNull
    public static String getAgentConfigFile() {
        return "/data/local/tmp/perfd/agent.config";
    }

    void copyHostFileToDevice(@NotNull DeployableFile hostFile) throws AdbCommandRejectedException, IOException {
        this.copyFileToDevice(hostFile);
    }

    private static boolean isAtLeastO(IDevice device) {
        return device.getVersion().getFeatureLevel() >= 26;
    }

    private static boolean isAtLeastP(IDevice device) {
        return device.getVersion().getFeatureLevel() >= 28;
    }

    private void pushDaemonConfig() throws AdbCommandRejectedException, IOException, TimeoutException, SyncException, ShellCommandUnresponsiveException {
        Transport.DaemonConfig.Builder configBuilder = Transport.DaemonConfig.newBuilder().setCommon(this.buildCommonConfig());
        ((TransportDeviceManager.TransportDeviceManagerListener)this.myMessageBus.syncPublisher(TransportDeviceManager.TOPIC)).customizeDaemonConfig(configBuilder);
        File configFile = FileUtil.createTempFile((String)DAEMON_CONFIG_FILE, null, (boolean)true);
        FileOutputStream oStream = new FileOutputStream(configFile);
        configBuilder.build().writeTo((OutputStream)oStream);
        this.myDevice.executeShellCommand("rm -f /data/local/tmp/perfd/daemon.config", (IShellOutputReceiver)new NullOutputReceiver());
        this.myDevice.pushFile(configFile.getAbsolutePath(), "/data/local/tmp/perfd/daemon.config");
    }

    public void pushAgentConfig(@NotNull String configName, @Nullable AndroidRunConfigurationBase runConfig) throws AdbCommandRejectedException, IOException, TimeoutException, SyncException, ShellCommandUnresponsiveException {
        Agent.AgentConfig.Builder agentConfigBuilder = Agent.AgentConfig.newBuilder().setCommon(this.buildCommonConfig());
        ((TransportDeviceManager.TransportDeviceManagerListener)this.myMessageBus.syncPublisher(TransportDeviceManager.TOPIC)).customizeAgentConfig(agentConfigBuilder, runConfig);
        File configFile = FileUtil.createTempFile((String)configName, null, (boolean)true);
        FileOutputStream oStream = new FileOutputStream(configFile);
        agentConfigBuilder.build().writeTo((OutputStream)oStream);
        this.myDevice.executeShellCommand("rm -f /data/local/tmp/perfd/" + configName, (IShellOutputReceiver)new NullOutputReceiver());
        this.myDevice.pushFile(configFile.getAbsolutePath(), DEVICE_DIR + configName);
    }

    @NotNull
    private Common.CommonConfig.Builder buildCommonConfig() {
        Common.CommonConfig.SocketType socketType = TransportFileManager.isAtLeastO(this.myDevice) ? Common.CommonConfig.SocketType.ABSTRACT_SOCKET : Common.CommonConfig.SocketType.UNSPECIFIED_SOCKET;
        return Common.CommonConfig.newBuilder().setSocketType(socketType).setServiceAddress("127.0.0.1:12389").setServiceSocketName("@AndroidStudioTransport");
    }

    protected void copyFileToDevice(@NotNull DeployableFile hostFile) throws AdbCommandRejectedException, IOException {
        File dir = hostFile.getDir();
        if (!hostFile.isExecutable()) {
            File file = new File(dir, hostFile.getFileName());
            this.pushFileToDevice(file, hostFile.getFileName(), hostFile.isExecutable());
            return;
        }
        if (!hostFile.isAbiDependent()) {
            Abi abi = this.getBestAbi(hostFile);
            File file = new File(dir, abi + "/" + hostFile.getFileName());
            this.pushFileToDevice(file, hostFile.getFileName(), true);
        } else {
            String format = hostFile.getOnDeviceAbiFileNameFormat();
            assert (format != null);
            for (Abi abi : this.getBestAbis(hostFile)) {
                File file = new File(dir, abi + "/" + hostFile.getFileName());
                this.pushFileToDevice(file, String.format(format, abi.getCpuArch()), true);
            }
        }
    }

    private void pushFileToDevice(File file, String fileName, boolean executable) throws AdbCommandRejectedException, IOException {
        try {
            if (file == null) {
                throw new RuntimeException(String.format("File %s could not be found for device: %s", fileName, this.myDevice));
            }
            String deviceFilePath = DEVICE_DIR + fileName;
            TransportFileManager.getLogger().info(String.format("Pushing %s to %s...", fileName, DEVICE_DIR));
            this.myDevice.executeShellCommand("rm -f " + deviceFilePath, (IShellOutputReceiver)new NullOutputReceiver());
            this.myDevice.executeShellCommand("mkdir -p " + deviceFilePath.substring(0, deviceFilePath.lastIndexOf("/")), (IShellOutputReceiver)new NullOutputReceiver());
            this.myDevice.pushFile(file.getAbsolutePath(), deviceFilePath);
            if (executable) {
                ChmodOutputListener chmodListener = new ChmodOutputListener();
                this.myDevice.executeShellCommand("chmod +x " + deviceFilePath, (IShellOutputReceiver)chmodListener);
                if (chmodListener.hasErrors()) {
                    this.myDevice.executeShellCommand("chmod 777 " + deviceFilePath, (IShellOutputReceiver)new NullOutputReceiver());
                }
            }
            TransportFileManager.getLogger().info(String.format("Successfully pushed %s to %s.", fileName, DEVICE_DIR));
        }
        catch (ShellCommandUnresponsiveException | SyncException | TimeoutException e) {
            throw new RuntimeException(e);
        }
    }

    public String configureStartupAgent(@NotNull String packageName, @NotNull String configName) {
        if (this.myDevice.getVersion().getFeatureLevel() < 27) {
            return "";
        }
        String packageDataPath = this.getPackageDataPath(packageName);
        if (packageDataPath.isEmpty()) {
            return "";
        }
        String agentName = String.format(HostFiles.JVMTI_AGENT.getOnDeviceAbiFileNameFormat(), this.getBestAbi(HostFiles.JVMTI_AGENT).getCpuArch());
        String[] requiredAgentFiles = new String[]{agentName, HostFiles.PERFA.getFileName()};
        try {
            for (String agentFile : requiredAgentFiles) {
                this.myDevice.executeShellCommand(this.buildRunAsCommand(packageName, String.format("rm -rf ./%s/%s", CODE_CACHE_DIR, agentFile)), (IShellOutputReceiver)new NullOutputReceiver());
                this.myDevice.executeShellCommand(this.buildRunAsCommand(packageName, String.format("cp %s ./%s/", DEVICE_DIR + agentFile, CODE_CACHE_DIR)), (IShellOutputReceiver)new NullOutputReceiver());
            }
        }
        catch (AdbCommandRejectedException | ShellCommandUnresponsiveException | TimeoutException | IOException ignored) {
            return "";
        }
        return String.format("--attach-agent %s/%s/%s=%s", packageDataPath, CODE_CACHE_DIR, agentName, DEVICE_DIR + configName);
    }

    @NotNull
    private String getPackageDataPath(@NotNull String packageName) {
        final String[] result2 = new String[1];
        try {
            this.myDevice.executeShellCommand(this.buildRunAsCommand(packageName, "pwd"), (IShellOutputReceiver)new MultiLineReceiver(){

                public void processNewLines(String[] lines) {
                    if (result2[0] == null) {
                        result2[0] = lines[0];
                    }
                }

                public boolean isCancelled() {
                    return false;
                }
            });
        }
        catch (AdbCommandRejectedException | ShellCommandUnresponsiveException | TimeoutException | IOException throwable) {
            // empty catch block
        }
        if (result2[0] == null || result2[0].startsWith("run-as: ")) {
            return "";
        }
        return result2[0];
    }

    @NotNull
    private String buildRunAsCommand(@NotNull String packageName, @NotNull String command) {
        return String.format("run-as %s sh -c '%s'", packageName, command);
    }

    @NotNull
    private Abi getBestAbi(@NotNull DeployableFile hostFile) {
        return this.getBestAbis(hostFile).get(0);
    }

    @NotNull
    private List<Abi> getBestAbis(@NotNull DeployableFile hostFile) {
        File dir = hostFile.getDir();
        List supportedAbis = this.myDevice.getAbis().stream().map(abi -> Abi.getEnum((String)abi)).filter(abi -> new File(dir, abi + "/" + hostFile.getFileName()).exists()).collect(Collectors.toList());
        ArrayList<Abi> bestAbis = new ArrayList<Abi>();
        HashSet<String> seenCpuArch = new HashSet<String>();
        for (Abi abi2 : supportedAbis) {
            if (seenCpuArch.contains(abi2.getCpuArch())) continue;
            seenCpuArch.add(abi2.getCpuArch());
            bestAbis.add(abi2);
        }
        return bestAbis;
    }

    private static class ChmodOutputListener
    implements IShellOutputReceiver {
        private static final String BAD_MODE = "Bad mode";
        private boolean myHasErrors;

        private ChmodOutputListener() {
        }

        public void addOutput(byte[] data, int offset, int length) {
            String s = new String(data, Charsets.UTF_8);
            this.myHasErrors = s.contains(BAD_MODE);
        }

        public void flush() {
        }

        public boolean isCancelled() {
            return false;
        }

        private boolean hasErrors() {
            return this.myHasErrors;
        }
    }

    private static class HostFiles {
        @NotNull
        static final DeployableFile TRANSPORT = new DeployableFile.Builder("transport").setReleaseDir("plugins/android/resources/transport").setDevDir("../../bazel-bin/tools/base/transport/android").setExecutable(true).build();
        @NotNull
        static final DeployableFile PERFA = new DeployableFile.Builder("perfa.jar").build();
        @NotNull
        static final DeployableFile PERFA_OKHTTP = new DeployableFile.Builder("perfa_okhttp.dex").build();
        @NotNull
        static final DeployableFile JVMTI_AGENT = new DeployableFile.Builder("libjvmtiagent.so").setReleaseDir("plugins/android/resources/transport/agent").setDevDir("../../bazel-bin/tools/base/transport/agent/android").setExecutable(true).setOnDeviceAbiFileNameFormat("libjvmtiagent_%s.so").build();
        @NotNull
        static final DeployableFile SIMPLEPERF = new DeployableFile.Builder("simpleperf").setReleaseDir("plugins/android/resources/simpleperf").setDevDir("../../prebuilts/tools/common/simpleperf").setExecutable(true).setOnDeviceAbiFileNameFormat("simpleperf_%s").build();
        @NotNull
        static final DeployableFile PERFETTO = new DeployableFile.Builder("perfetto").setReleaseDir("plugins/android/resources/perfetto").setDevDir("../../prebuilts/tools/common/perfetto").setExecutable(true).setOnDeviceAbiFileNameFormat("perfetto_%s").build();
        @NotNull
        static final DeployableFile PERFETTO_SO = new DeployableFile.Builder("libperfetto.so").setReleaseDir("plugins/android/resources/perfetto").setDevDir("../../prebuilts/tools/common/perfetto").setExecutable(true).setOnDeviceAbiFileNameFormat("%s/libperfetto.so").build();
        @NotNull
        static final DeployableFile TRACED = new DeployableFile.Builder("traced").setReleaseDir("plugins/android/resources/perfetto").setDevDir("../../prebuilts/tools/common/perfetto").setExecutable(true).setOnDeviceAbiFileNameFormat("traced_%s").build();
        @NotNull
        static final DeployableFile TRACED_PROBE = new DeployableFile.Builder("traced_probes").setReleaseDir("plugins/android/resources/perfetto").setDevDir("../../prebuilts/tools/common/perfetto").setExecutable(true).setOnDeviceAbiFileNameFormat("traced_probes_%s").build();

        private HostFiles() {
        }
    }
}

