/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.transport;

import com.android.ddmlib.IDevice;
import com.android.tools.idea.transport.ServiceProxy;
import com.android.tools.idea.transport.TransportServiceProxy;
import com.android.tools.profiler.proto.Commands;
import com.android.tools.profiler.proto.Common;
import com.android.tools.profiler.proto.Transport;
import io.grpc.ManagedChannel;
import io.grpc.Server;
import io.grpc.ServerBuilder;
import io.grpc.inprocess.InProcessServerBuilder;
import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;

public final class TransportProxy {
    private Server myProxyServer;
    @NotNull
    private final List<ServiceProxy> myProxyServices;
    @NotNull
    private final Map<Commands.Command.CommandType, Function<Commands.Command, Transport.ExecuteResponse>> myProxyHandlers;
    @NotNull
    private IDevice myDevice;
    @NotNull
    private ManagedChannel myTransportChannel;
    @NotNull
    private final TransportServiceProxy myProxyService;

    public TransportProxy(@NotNull IDevice ddmlibDevice, @NotNull Common.Device tranportDevice, @NotNull ManagedChannel transportChannel) {
        this.myDevice = ddmlibDevice;
        this.myTransportChannel = transportChannel;
        this.myProxyServices = new LinkedList<ServiceProxy>();
        this.myProxyHandlers = new HashMap<Commands.Command.CommandType, Function<Commands.Command, Transport.ExecuteResponse>>();
        this.myProxyService = new TransportServiceProxy(ddmlibDevice, tranportDevice, transportChannel);
    }

    public void registerProxyService(ServiceProxy proxyService) {
        this.myProxyServices.add(proxyService);
    }

    public void registerProxyCommandHandler(Commands.Command.CommandType commandType, Function<Commands.Command, Transport.ExecuteResponse> handler) {
        this.myProxyService.registerCommandHandler(commandType, handler);
    }

    public void initializeProxyServer(String channelName) {
        InProcessServerBuilder builder = InProcessServerBuilder.forName((String)channelName);
        this.myProxyServices.add(this.myProxyService);
        this.myProxyServices.forEach(arg_0 -> TransportProxy.lambda$initializeProxyServer$0((ServerBuilder)builder, arg_0));
        this.myProxyServer = builder.build();
    }

    public void connect() throws IOException {
        if (this.myProxyServer == null) {
            throw new IllegalStateException("Proxy server has not been built");
        }
        this.myProxyServer.start();
    }

    public void disconnect() {
        if (this.myProxyServer == null) {
            throw new IllegalStateException("Proxy server has not been built");
        }
        this.myProxyServices.forEach(ServiceProxy::disconnect);
        this.myProxyServer.shutdown();
    }

    @NotNull
    public IDevice getDevice() {
        return this.myDevice;
    }

    @NotNull
    public ManagedChannel getTransportChannel() {
        return this.myTransportChannel;
    }

    private static /* synthetic */ void lambda$initializeProxyServer$0(ServerBuilder builder, ServiceProxy service) {
        builder.addService(service.getServiceDefinition());
    }
}

