/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.transport;

import com.android.tools.datastore.DataStoreService;
import com.android.tools.datastore.LogService;
import com.android.tools.idea.transport.IntellijLogService;
import com.android.tools.idea.transport.TransportDeviceManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.messages.MessageBus;
import java.io.File;
import java.nio.file.Paths;
import org.jetbrains.annotations.NotNull;

public class TransportService
implements Disposable {
    private static final String DATASTORE_NAME = "DataStoreService";
    private static boolean ourServiceInitialized = false;
    @NotNull
    private final MessageBus myMessageBus;
    @NotNull
    private final DataStoreService myDataStoreService;
    @NotNull
    private final TransportDeviceManager myDeviceManager;

    public static TransportService getInstance() {
        return (TransportService)ServiceManager.getService(TransportService.class);
    }

    public static boolean isServiceInitialized() {
        return ourServiceInitialized;
    }

    private TransportService() {
        String datastoreDirectory = Paths.get(PathManager.getSystemPath(), ".android").toString() + File.separator;
        this.myDataStoreService = new DataStoreService(DATASTORE_NAME, datastoreDirectory, arg_0 -> ((Application)ApplicationManager.getApplication()).executeOnPooledThread(arg_0), (LogService)new IntellijLogService());
        this.myMessageBus = ApplicationManager.getApplication().getMessageBus();
        this.myDeviceManager = new TransportDeviceManager(this.myDataStoreService, this.myMessageBus);
        Disposer.register((Disposable)this, () -> ((DataStoreService)this.myDataStoreService).shutdown());
        Disposer.register((Disposable)this, (Disposable)this.myDeviceManager);
        ourServiceInitialized = true;
    }

    public void dispose() {
    }

    @NotNull
    public MessageBus getMessageBus() {
        return this.myMessageBus;
    }

    @NotNull
    public DataStoreService getDataStoreService() {
        return this.myDataStoreService;
    }

    @NotNull
    public String getChannelName() {
        return DATASTORE_NAME;
    }
}

