/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.ui;

import com.android.tools.idea.ui.GuiTestingStatusProvider;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.util.Key;
import javax.annotation.concurrent.GuardedBy;
import org.jetbrains.annotations.NotNull;

public class GuiTestingService {
    public static final Key<Runnable> EXECUTE_BEFORE_PROJECT_BUILD_IN_GUI_TEST_KEY = Key.create((String)"gui.test.execute.before.build");
    public static final Key<String> GRADLE_BUILD_OUTPUT_IN_GUI_TEST_KEY = Key.create((String)"gui.test.gradle.build.output");
    private final Object LOCK = new Object();
    @GuardedBy(value="LOCK")
    private boolean myGuiTestingMode;
    @GuardedBy(value="LOCK")
    private GuiTestSuiteState myGuiTestSuiteState;

    public static GuiTestingService getInstance() {
        return (GuiTestingService)ServiceManager.getService(GuiTestingService.class);
    }

    private GuiTestingService() {
        boolean en = false;
        ExtensionPointName epName = ExtensionPointName.create((String)"com.android.tools.idea.ui.guiTestingStatusProvider");
        for (GuiTestingStatusProvider provider : (GuiTestingStatusProvider[])epName.getExtensions()) {
            en = provider.enableUiTestMode() || en;
        }
        this.setGuiTestingMode(en);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isGuiTestingMode() {
        Object object = this.LOCK;
        synchronized (object) {
            return this.myGuiTestingMode;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setGuiTestingMode(boolean guiTestingMode) {
        Object object = this.LOCK;
        synchronized (object) {
            this.myGuiTestingMode = guiTestingMode;
            this.myGuiTestSuiteState = this.myGuiTestingMode ? new GuiTestSuiteState() : null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public GuiTestSuiteState getGuiTestSuiteState() {
        Object object = this.LOCK;
        synchronized (object) {
            if (!this.myGuiTestingMode) {
                throw new UnsupportedOperationException("The method 'getGuiTestSuiteState' can only be invoked when running UI tests");
            }
            return this.myGuiTestSuiteState;
        }
    }

    public static class GuiTestSuiteState {
        private boolean mySkipSdkMerge;

        public boolean isSkipSdkMerge() {
            return this.mySkipSdkMerge;
        }

        public void setSkipSdkMerge(boolean skipSdkMerge) {
            this.mySkipSdkMerge = skipSdkMerge;
        }
    }
}

