/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.ui.resourcechooser;

import com.android.ide.common.rendering.api.ResourceNamespace;
import com.android.ide.common.rendering.api.ResourceValue;
import com.android.ide.common.rendering.api.ResourceValueImpl;
import com.android.ide.common.rendering.api.SampleDataResourceValue;
import com.android.ide.common.resources.ResourceItem;
import com.android.ide.common.resources.configuration.FolderConfiguration;
import com.android.ide.common.util.PathString;
import com.android.resources.ResourceType;
import com.android.tools.idea.res.SampleDataResourceItem;
import com.android.tools.idea.res.SampleDataResourceRepository;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.intellij.openapi.util.Pair;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ResourceChooserItem {
    public static final String DEFAULT_FOLDER_NAME = "Default";
    @NotNull
    protected final ResourceType myType;
    @NotNull
    protected final String myName;
    private final HashMap<Integer, Icon> myIcons = Maps.newHashMapWithExpectedSize((int)2);

    public ResourceChooserItem(@NotNull ResourceType type, @NotNull String name) {
        this.myType = type;
        this.myName = name;
    }

    @NotNull
    public List<String> getQualifiers() {
        return Collections.singletonList(DEFAULT_FOLDER_NAME);
    }

    @NotNull
    public ResourceType getType() {
        return this.myType;
    }

    @NotNull
    public String getName() {
        return this.myName;
    }

    @NotNull
    public String getQualifiedName() {
        return this.isFramework() ? "android:" + this.getName() : this.getName();
    }

    @Nullable
    public PathString getFile() {
        return null;
    }

    @Nullable
    public String getPath() {
        return null;
    }

    @Nullable
    public String getFileForQualifiers(String qualifiers) {
        return null;
    }

    @NotNull
    public abstract String getResourceUrl();

    @NotNull
    public ResourceValue getResourceValue() {
        return new ResourceValueImpl(ResourceNamespace.fromBoolean((boolean)this.isFramework()), this.getType(), this.getName(), this.getResourceUrl());
    }

    public String toString() {
        return this.getName();
    }

    @Nullable
    public Icon getIcon(int iconSize) {
        return this.myIcons.get(iconSize);
    }

    public void setIcon(@NotNull Icon icon2) {
        assert (icon2.getIconWidth() == icon2.getIconHeight());
        this.myIcons.put(icon2.getIconWidth(), icon2);
    }

    public abstract boolean isFramework();

    public boolean isAttr() {
        return false;
    }

    public boolean isReference() {
        String s = this.getDefaultValue();
        if (s != null) {
            return s.startsWith("@") || s.startsWith("?");
        }
        return false;
    }

    @Nullable
    public abstract String getDefaultValue();

    @NotNull
    public List<Pair<FolderConfiguration, String>> getQualifiersAndValues() {
        return Collections.emptyList();
    }

    public static ResourceChooserItem createProjectItem(@NotNull ResourceType type, @NotNull String name, @NotNull List<ResourceItem> resourceItems) {
        return new ResourceChooserItemImpl(type, name, resourceItems, false);
    }

    public static ResourceChooserItem createFrameworkItem(@NotNull ResourceType type, @NotNull String name, @NotNull List<ResourceItem> resourceItems) {
        return new ResourceChooserItemImpl(type, name, resourceItems, true);
    }

    public static class SampleDataItem
    extends ResourceChooserItem {
        @NotNull
        private final SampleDataResourceItem myItem;
        private int myIndex = -1;

        public SampleDataItem(@NotNull SampleDataResourceItem item) {
            super(ResourceType.SAMPLE_DATA, item.getName());
            this.myItem = item;
        }

        @NotNull
        public SampleDataResourceItem getResourceItem() {
            return this.myItem;
        }

        @Override
        @NotNull
        public String getResourceUrl() {
            boolean isPredefinedData = SampleDataResourceRepository.PREDEFINED_SAMPLES_NS.equals((Object)this.myItem.getResourceValue().getNamespace());
            String prefix = isPredefinedData ? "@tools:sample/" : "@sample/";
            return prefix + this.myName + (this.myIndex >= 0 ? "[" + this.myIndex + "]" : "");
        }

        @Override
        public boolean isFramework() {
            return false;
        }

        @Override
        @Nullable
        public String getDefaultValue() {
            return (String)Iterables.getFirst((Iterable)this.getSampleDataResourceValue().getValueAsLines(), (Object)this.getResourceUrl());
        }

        @NotNull
        private SampleDataResourceValue getSampleDataResourceValue() {
            SampleDataResourceValue value2 = (SampleDataResourceValue)this.myItem.getResourceValue();
            return value2;
        }

        public void setValueIndex(int index) {
            if (index >= this.getSampleDataResourceValue().getValueAsLines().size()) {
                throw new IndexOutOfBoundsException();
            }
            this.myIndex = index;
        }

        @Override
        @NotNull
        public List<Pair<FolderConfiguration, String>> getQualifiersAndValues() {
            FolderConfiguration folderConfiguration = new FolderConfiguration();
            return this.getSampleDataResourceValue().getValueAsLines().stream().limit(10L).map(string -> Pair.create((Object)folderConfiguration, (Object)string)).collect(Collectors.toList());
        }

        @Override
        @NotNull
        public ResourceValue getResourceValue() {
            ResourceType type = this.myItem.getContentType() == SampleDataResourceItem.ContentType.IMAGE ? ResourceType.DRAWABLE : this.myItem.getType();
            SampleDataResourceValue value2 = this.getSampleDataResourceValue();
            return new ResourceValueImpl(this.myItem.getNamespace(), type, this.myItem.getName(), (String)value2.getValueAsLines().get(0), value2.getLibraryName());
        }
    }

    public static class AttrItem
    extends ResourceChooserItem {
        private boolean myFramework;

        public AttrItem(@NotNull ResourceType type, boolean framework, @NotNull String name) {
            super(type, name);
            this.myFramework = framework;
        }

        @Override
        public boolean isAttr() {
            return true;
        }

        @Override
        public boolean isFramework() {
            return this.myFramework;
        }

        @Override
        @NotNull
        public String getResourceUrl() {
            if (this.isFramework()) {
                return "?android:" + ResourceType.ATTR.getName() + '/' + this.myName;
            }
            return "?" + ResourceType.ATTR.getName() + '/' + this.myName;
        }

        @Override
        public String toString() {
            return this.getQualifiedName();
        }

        @Override
        public boolean isReference() {
            return true;
        }

        @Override
        public String getDefaultValue() {
            return null;
        }
    }

    private static class ResourceChooserItemImpl
    extends ResourceChooserItem {
        @NotNull
        private final List<ResourceItem> myResourceItems;
        private final boolean myIsFramework;

        public ResourceChooserItemImpl(@NotNull ResourceType type, @NotNull String name, @NotNull List<ResourceItem> resourceItems, boolean isFramework) {
            super(type, name);
            this.myResourceItems = resourceItems;
            this.myIsFramework = isFramework;
        }

        @Override
        public boolean isFramework() {
            return this.myIsFramework;
        }

        @Override
        @Nullable
        public PathString getFile() {
            return !this.myResourceItems.isEmpty() ? this.myResourceItems.get(0).getSource() : null;
        }

        @Override
        @Nullable
        public String getPath() {
            PathString file = this.getFile();
            return file != null ? file.getNativePath() : null;
        }

        @Override
        @Nullable
        public String getFileForQualifiers(String qualifiers) {
            for (ResourceItem item : this.myResourceItems) {
                PathString file;
                if (!qualifiers.equals(item.getConfiguration().getQualifierString()) || (file = item.getSource()) == null) continue;
                return file.getNativePath();
            }
            return null;
        }

        @Override
        @NotNull
        public String getResourceUrl() {
            StringBuilder builder = new StringBuilder("@");
            if (this.isFramework()) {
                builder.append("android:");
            }
            return builder.append(this.myType.getName()).append('/').append(this.myName).toString();
        }

        @Override
        @NotNull
        public List<String> getQualifiers() {
            HashSet set = Sets.newHashSet();
            for (ResourceItem item : this.myResourceItems) {
                String q = item.getConfiguration().getQualifierString();
                if (!q.isEmpty()) {
                    set.add(q);
                    continue;
                }
                set.add(ResourceChooserItem.DEFAULT_FOLDER_NAME);
            }
            ArrayList<String> qualifiers = new ArrayList<String>(set);
            Collections.sort(qualifiers);
            return qualifiers;
        }

        @Override
        public String getDefaultValue() {
            ResourceItem first = this.myResourceItems.get(0);
            ResourceValue value2 = first.getResourceValue();
            if (value2 != null) {
                return value2.getValue();
            }
            return null;
        }

        @Override
        @NotNull
        public List<Pair<FolderConfiguration, String>> getQualifiersAndValues() {
            ArrayList<Pair<FolderConfiguration, String>> pairs = new ArrayList<Pair<FolderConfiguration, String>>(this.myResourceItems.size());
            for (ResourceItem item : this.myResourceItems) {
                ResourceValue resourceValue2 = item.getResourceValue();
                FolderConfiguration configuration = item.getConfiguration();
                pairs.add((Pair<FolderConfiguration, String>)Pair.create((Object)configuration, (Object)(resourceValue2 != null ? resourceValue2.getValue() : null)));
            }
            return pairs;
        }
    }
}

