/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.ui.resourcechooser;

import com.android.ide.common.rendering.api.RenderResources;
import com.android.ide.common.rendering.api.ResourceValue;
import com.android.ide.common.resources.ResourceRepository;
import com.android.ide.common.resources.ResourceResolver;
import com.android.resources.ResourceFolderType;
import com.android.resources.ResourceType;
import com.android.resources.ResourceUrl;
import com.android.sdklib.IAndroidTarget;
import com.android.tools.idea.configurations.Configuration;
import com.android.tools.idea.editors.theme.ThemeEditorUtils;
import com.android.tools.idea.editors.theme.attributes.editors.DrawableRendererEditor;
import com.android.tools.idea.editors.theme.attributes.editors.GraphicalResourceRendererEditor;
import com.android.tools.idea.editors.theme.ui.ResourceComponent;
import com.android.tools.idea.rendering.RenderTask;
import com.android.tools.idea.res.ResourceHelper;
import com.android.tools.idea.res.StateList;
import com.android.tools.idea.res.StateListState;
import com.android.tools.idea.ui.resourcechooser.ChooseResourceDialog;
import com.android.tools.idea.ui.resourcechooser.ResourceSwatchComponent;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.JBPopupMenu;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.components.JBLabel;
import com.intellij.util.ui.JBFont;
import com.intellij.util.ui.JBUI;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.util.EnumSet;
import java.util.List;
import java.util.Locale;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.sdk.AndroidTargetData;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StateListPicker
extends JPanel {
    private static final EnumSet<ResourceType> DIMENSIONS_ONLY = EnumSet.of(ResourceType.DIMEN);
    private final Module myModule;
    private final Configuration myConfiguration;
    @Nullable
    private StateList myStateList;
    private List<StateComponent> myStateComponents;
    @NotNull
    private final RenderTask myRenderTask;
    private boolean myIsBackgroundStateList;
    @NotNull
    private ImmutableMap<String, Color> myContrastColorsWithDescription = ImmutableMap.of();

    public StateListPicker(@Nullable StateList stateList, @NotNull Module module, @NotNull Configuration configuration) {
        this.myModule = module;
        this.myConfiguration = configuration;
        this.myRenderTask = DrawableRendererEditor.configureRenderTask(module, configuration);
        this.setLayout(new BoxLayout(this, 1));
        if (stateList != null) {
            this.setStateList(stateList);
        }
    }

    public void setStateList(@NotNull StateList stateList) {
        this.myStateList = stateList;
        this.myStateComponents = Lists.newArrayListWithCapacity((int)this.myStateList.getStates().size());
        this.removeAll();
        if (this.myStateList.getStates().isEmpty()) {
            this.add(new JLabel("Empty " + this.myStateList.getType() + " StateList"));
        }
        for (StateListState state : this.myStateList.getStates()) {
            StateComponent stateComponent = this.createStateComponent(state);
            this.add(stateComponent);
        }
        this.revalidate();
        this.repaint();
    }

    @NotNull
    private StateComponent createStateComponent(@NotNull StateListState state) {
        StateComponent stateComponent = new StateComponent(this.myModule.getProject());
        this.myStateComponents.add(stateComponent);
        String stateValue = state.getValue();
        String alphaValue = state.getAlpha();
        stateComponent.addValueActionListener(new ValueActionListener(state, stateComponent));
        stateComponent.addAlphaActionListener(new AlphaActionListener(state, stateComponent));
        stateComponent.setValueText(stateValue);
        stateComponent.setAlphaValue(alphaValue);
        stateComponent.setAlphaVisible(!StringUtil.isEmpty((String)alphaValue));
        stateComponent.setNameText(state.getDescription());
        stateComponent.setComponentPopupMenu((JPopupMenu)this.createAlphaPopupMenu(state, stateComponent));
        AndroidFacet facet = AndroidFacet.getInstance(this.myModule);
        assert (facet != null);
        assert (this.myStateList != null);
        List<String> completionStrings = ResourceHelper.getCompletionFromTypes(facet, this.myStateList.getFolderType() == ResourceFolderType.COLOR ? GraphicalResourceRendererEditor.COLORS_ONLY : GraphicalResourceRendererEditor.DRAWABLES_ONLY);
        stateComponent.getResourceComponent().setCompletionStrings(completionStrings);
        stateComponent.getAlphaComponent().setCompletionStrings(ResourceHelper.getCompletionFromTypes(facet, DIMENSIONS_ONLY));
        return stateComponent;
    }

    @NotNull
    private JBPopupMenu createAlphaPopupMenu(@NotNull StateListState state, @NotNull StateComponent stateComponent) {
        JBPopupMenu popupMenu = new JBPopupMenu();
        JMenuItem deleteAlpha = new JMenuItem("Delete alpha");
        popupMenu.add(deleteAlpha);
        deleteAlpha.setVisible(!StringUtil.isEmpty((String)state.getAlpha()));
        JMenuItem createAlpha = new JMenuItem("Create alpha");
        popupMenu.add(createAlpha);
        createAlpha.setVisible(StringUtil.isEmpty((String)state.getAlpha()));
        deleteAlpha.addActionListener(e -> {
            stateComponent.getAlphaComponent().setVisible(false);
            stateComponent.setAlphaValue(null);
            state.setAlpha(null);
            this.updateIcon(stateComponent);
            deleteAlpha.setVisible(false);
            createAlpha.setVisible(true);
        });
        createAlpha.addActionListener(e -> {
            AlphaActionListener listener2 = stateComponent.getAlphaActionListener();
            if (listener2 == null) {
                return;
            }
            listener2.actionPerformed(new ActionEvent(stateComponent.getAlphaComponent(), 1001, null));
            if (!StringUtil.isEmpty((String)state.getAlpha())) {
                stateComponent.getAlphaComponent().setVisible(true);
                createAlpha.setVisible(false);
                deleteAlpha.setVisible(true);
            }
        });
        return popupMenu;
    }

    @Nullable
    public ValidationInfo doValidate(int minApi) {
        IAndroidTarget target = this.myConfiguration.getRealTarget();
        assert (target != null);
        AndroidTargetData androidTargetData = AndroidTargetData.getTargetData(target, this.myModule);
        assert (androidTargetData != null);
        ResourceRepository frameworkResources = this.myConfiguration.getFrameworkResources();
        assert (frameworkResources != null);
        for (StateComponent component : this.myStateComponents) {
            ValidationInfo error = component.doValidate(minApi, androidTargetData);
            if (error == null) continue;
            return error;
        }
        return null;
    }

    public void setContrastParameters(@NotNull ImmutableMap<String, Color> contrastColorsWithDescription, boolean isBackgroundStateList) {
        this.myContrastColorsWithDescription = contrastColorsWithDescription;
        this.myIsBackgroundStateList = isBackgroundStateList;
    }

    @Nullable
    public StateList getStateList() {
        return this.myStateList;
    }

    private void updateIcon(@NotNull StateComponent component) {
        component.showAlphaError(false);
        ResourceResolver resourceResolver = this.myConfiguration.getResourceResolver();
        assert (resourceResolver != null);
        component.setValueIcon(StateListPicker.getSwatchIcon(component.getResourceValue(), resourceResolver, this.myRenderTask));
        String alphaValue = component.getAlphaValue();
        if (!StringUtil.isEmpty((String)alphaValue)) {
            try {
                float alpha = Float.parseFloat(ResourceHelper.resolveStringValue((RenderResources)resourceResolver, alphaValue));
                JBFont iconFont = JBUI.Fonts.smallFont().asBold();
                component.getAlphaComponent().setSwatchIcon(new ResourceSwatchComponent.TextIcon(String.format(Locale.US, "%.2f", Float.valueOf(alpha)), (Font)iconFont));
            }
            catch (NumberFormatException e) {
                component.showAlphaError(true);
                component.getAlphaComponent().setSwatchIcon(ResourceSwatchComponent.WARNING_ICON);
            }
        } else {
            JBFont iconFont = JBUI.Fonts.smallFont().asBold();
            component.getAlphaComponent().setSwatchIcon(new ResourceSwatchComponent.TextIcon("1.00", (Font)iconFont));
        }
    }

    @NotNull
    public static ResourceSwatchComponent.SwatchIcon getSwatchIcon(@Nullable String resourceName, @NotNull ResourceResolver resourceResolver, @NotNull RenderTask renderTask) {
        ResourceSwatchComponent.SwatchIcon icon2;
        ResourceValue resValue = resourceResolver.findResValue(resourceName, false);
        if ((resValue = resourceResolver.resolveResValue(resValue)) == null || resValue.getResourceType() == ResourceType.COLOR) {
            ResourceSwatchComponent.SwatchIcon icon3;
            List<Color> colors = ResourceHelper.resolveMultipleColors((RenderResources)resourceResolver, resValue, renderTask.getContext().getModule().getProject());
            if (colors.isEmpty()) {
                Color colorValue = ResourceHelper.parseColor(resourceName);
                icon3 = colorValue != null ? new ResourceSwatchComponent.ColorIcon(colorValue) : ResourceSwatchComponent.WARNING_ICON;
            } else {
                icon3 = new ResourceSwatchComponent.ColorIcon((Color)Iterables.getLast(colors));
                icon3.setIsStack(colors.size() > 1);
            }
            return icon3;
        }
        List<BufferedImage> images = renderTask.renderDrawableAllStates(resValue);
        if (images.isEmpty()) {
            icon2 = ResourceSwatchComponent.WARNING_ICON;
        } else {
            icon2 = new ResourceSwatchComponent.SquareImageIcon((BufferedImage)Iterables.getLast(images));
            icon2.setIsStack(images.size() > 1);
        }
        return icon2;
    }

    private void repaintAllComponents() {
        for (StateComponent component : this.myStateComponents) {
            this.updateIcon(component);
            component.repaint();
        }
    }

    private class StateComponent
    extends Box {
        private final ResourceComponent myResourceComponent;
        private final ResourceSwatchComponent myAlphaComponent;
        private final JBLabel myAlphaErrorLabel;
        private AlphaActionListener myAlphaActionListener;

        public StateComponent(Project project) {
            super(3);
            this.myResourceComponent = new ResourceComponent(project, true);
            this.add(this.myResourceComponent);
            this.myAlphaComponent = new ResourceSwatchComponent(project, true);
            this.add(this.myAlphaComponent);
            Font font = StateListPicker.this.getFont();
            this.setFont(ThemeEditorUtils.scaleFontForAttribute(font));
            Box alphaErrorComponent = new Box(2);
            this.myAlphaErrorLabel = new JBLabel("This value does not resolve to a floating-point number.", AllIcons.General.BalloonWarning, 10);
            this.myAlphaErrorLabel.setVisible(false);
            alphaErrorComponent.add((Component)this.myAlphaErrorLabel);
            alphaErrorComponent.add(Box.createHorizontalGlue());
            this.add(alphaErrorComponent);
        }

        @NotNull
        public ResourceComponent getResourceComponent() {
            return this.myResourceComponent;
        }

        @NotNull
        public ResourceSwatchComponent getAlphaComponent() {
            return this.myAlphaComponent;
        }

        public void showAlphaError(boolean hasError) {
            this.myAlphaErrorLabel.setVisible(hasError);
            this.myAlphaComponent.setWarningBorder(hasError);
        }

        public void setNameText(@NotNull String name) {
            this.myResourceComponent.setNameText(name);
        }

        public void setValueText(@NotNull String value2) {
            this.myResourceComponent.setValueText(value2);
            StateListPicker.this.updateIcon(this);
        }

        public void setAlphaValue(@Nullable String alphaValue) {
            this.myAlphaComponent.setText(Strings.nullToEmpty((String)alphaValue));
        }

        public void setAlphaVisible(boolean isVisible) {
            this.myAlphaComponent.setVisible(isVisible);
        }

        public void setValueIcon(@NotNull ResourceSwatchComponent.SwatchIcon icon2) {
            this.myResourceComponent.setSwatchIcon(icon2);
        }

        @NotNull
        public String getResourceValue() {
            return this.myResourceComponent.getValueText();
        }

        @Nullable
        public String getAlphaValue() {
            return this.myAlphaComponent.getText();
        }

        public void addValueActionListener(@NotNull ValueActionListener listener2) {
            this.myResourceComponent.addSwatchListener(listener2);
            this.myResourceComponent.addTextDocumentListener(listener2);
        }

        public void addAlphaActionListener(@NotNull AlphaActionListener listener2) {
            this.myAlphaComponent.addSwatchListener(listener2);
            this.myAlphaComponent.addTextDocumentListener(listener2);
            this.myAlphaActionListener = listener2;
        }

        @Nullable
        public AlphaActionListener getAlphaActionListener() {
            return this.myAlphaActionListener;
        }

        @Override
        public void setComponentPopupMenu(JPopupMenu popup2) {
            super.setComponentPopupMenu(popup2);
            this.myResourceComponent.setComponentPopupMenu(popup2);
            this.myAlphaComponent.setComponentPopupMenu(popup2);
        }

        @Override
        public void setFont(Font font) {
            super.setFont(font);
            if (this.myResourceComponent != null) {
                this.myResourceComponent.setFont(font);
            }
            if (this.myAlphaComponent != null) {
                this.myAlphaComponent.setFont(font);
            }
        }

        @Nullable
        public ValidationInfo doValidate(int minApi, @NotNull AndroidTargetData androidTargetData) {
            ValidationInfo error = this.getResourceComponent().doValidate(minApi, androidTargetData);
            if (error == null && this.getAlphaValue() != null) {
                error = this.getAlphaComponent().doValidate(minApi, androidTargetData);
            }
            return error;
        }
    }

    private class AlphaActionListener
    implements ActionListener,
    DocumentListener {
        private final StateListState myState;
        private final StateComponent myComponent;

        public AlphaActionListener(StateListState state, StateComponent stateComponent) {
            this.myState = state;
            this.myComponent = stateComponent;
        }

        public void documentChanged(@NotNull DocumentEvent e) {
            this.myState.setAlpha(this.myComponent.getAlphaValue());
            ApplicationManager.getApplication().invokeLater(() -> {
                StateListPicker.this.updateIcon(this.myComponent);
                this.myComponent.repaint();
            }, ModalityState.any());
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ResourceSwatchComponent source = this.myComponent.getAlphaComponent();
            String itemValue = source.getText();
            ResourceResolver resourceResolver = StateListPicker.this.myConfiguration.getResourceResolver();
            assert (resourceResolver != null);
            ResourceValue resValue = resourceResolver.findResValue(itemValue, false);
            String resolvedResource = resValue != null ? resourceResolver.resolveResValue(resValue).getName() : itemValue;
            ChooseResourceDialog dialog2 = ChooseResourceDialog.builder().setModule(StateListPicker.this.myModule).setTypes(DIMENSIONS_ONLY).setCurrentValue(resolvedResource).setConfiguration(StateListPicker.this.myConfiguration).build();
            dialog2.show();
            if (dialog2.isOK()) {
                String resourceName = dialog2.getResourceName();
                this.myState.setAlpha(resourceName);
                this.myComponent.setAlphaValue(resourceName);
                StateListPicker.this.repaintAllComponents();
            }
        }
    }

    class ValueActionListener
    implements ActionListener,
    DocumentListener {
        private final StateListState myState;
        private final StateComponent myComponent;

        public ValueActionListener(StateListState state, StateComponent stateComponent) {
            this.myState = state;
            this.myComponent = stateComponent;
        }

        public void documentChanged(@NotNull DocumentEvent e) {
            this.myState.setValue(this.myComponent.getResourceValue());
            ApplicationManager.getApplication().invokeLater(() -> {
                StateListPicker.this.updateIcon(this.myComponent);
                this.myComponent.repaint();
            }, ModalityState.any());
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String nameSuggestion;
            ResourceComponent resourceComponent = this.myComponent.getResourceComponent();
            String attributeValue = resourceComponent.getValueText();
            ResourceUrl attributeValueUrl = ResourceUrl.parse((String)attributeValue);
            boolean isFrameworkValue = attributeValueUrl != null && attributeValueUrl.isFramework();
            String string = nameSuggestion = attributeValueUrl != null ? attributeValueUrl.name : attributeValue;
            assert (StateListPicker.this.myStateList != null);
            EnumSet<ResourceType> allowedTypes = StateListPicker.this.myStateList.getFolderType() == ResourceFolderType.COLOR ? GraphicalResourceRendererEditor.COLORS_ONLY : GraphicalResourceRendererEditor.DRAWABLES_ONLY;
            ChooseResourceDialog.ResourceNameVisibility resourceNameVisibility = ChooseResourceDialog.ResourceNameVisibility.FORCE;
            if (nameSuggestion.startsWith("#")) {
                nameSuggestion = null;
                resourceNameVisibility = ChooseResourceDialog.ResourceNameVisibility.SHOW;
            }
            ChooseResourceDialog dialog2 = ChooseResourceDialog.builder().setModule(StateListPicker.this.myModule).setTypes(allowedTypes).setCurrentValue(attributeValue).setIsFrameworkValue(isFrameworkValue).setResourceNameVisibility(resourceNameVisibility).setResourceNameSuggestion(nameSuggestion).setConfiguration(StateListPicker.this.myConfiguration).build();
            if (!StateListPicker.this.myContrastColorsWithDescription.isEmpty()) {
                dialog2.setContrastParameters((ImmutableMap<String, Color>)StateListPicker.this.myContrastColorsWithDescription, StateListPicker.this.myIsBackgroundStateList, !StateListPicker.this.myStateList.getDisabledStates().contains((Object)this.myState));
            }
            dialog2.show();
            if (dialog2.isOK()) {
                String resourceName = dialog2.getResourceName();
                this.myComponent.setValueText(resourceName);
                StateListPicker.this.repaintAllComponents();
            }
        }
    }
}

